/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.Util;

public abstract class RrdFileBackendFactory
extends RrdBackendFactory {
    @Override
    protected boolean exists(String path) {
        return Util.fileExists(path);
    }

    @Override
    public boolean canStore(URI uri) {
        if ((uri.isOpaque() || uri.isAbsolute()) && !"file".equals(uri.getScheme())) {
            return false;
        }
        return uri.getAuthority() == null && uri.getFragment() == null && uri.getQuery() == null;
    }

    @Override
    public URI getCanonicalUri(URI uri) {
        try {
            if (uri.isOpaque()) {
                return new File(uri.getSchemeSpecificPart()).getCanonicalFile().toURI();
            }
            if (uri.isAbsolute()) {
                return new File(uri).getCanonicalFile().toURI();
            }
            return new File(uri.getPath()).getCanonicalFile().toURI();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't get canonical URI from " + uri + ": " + e);
        }
    }

    @Override
    public URI getUri(String path) {
        try {
            return new File(path).getCanonicalFile().toURI();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't get canonical URI from path " + path + ": " + e);
        }
    }

    @Override
    public String getPath(URI uri) {
        if (uri.isOpaque()) {
            return uri.getSchemeSpecificPart();
        }
        if (uri.isAbsolute()) {
            return new File(uri).getPath();
        }
        return uri.getPath();
    }
}

