/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.io.Serializable;
import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.CountCollector;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SumCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class MeanFunction
extends DoubleValue.AbstractDoubleValue
implements ReductionFunction {
    private SumCollector sumCollector;
    private CountCollector countCollector;
    public static final String name = "mean";
    private final String exprStr;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        DoubleValueStream casted;
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mean function requires 1 paramater, " + params.length + " found.");
        }
        try {
            casted = (DoubleValueStream)params[0];
        }
        catch (ClassCastException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The mean function requires numeric parameter. Incorrect parameter: " + params[0].getExpressionStr());
        }
        return new MeanFunction(casted);
    };

    public MeanFunction(DoubleValueStream param) {
        this.sumCollector = new SumCollector(param);
        this.countCollector = new CountCollector.ExpressionCountCollector(param);
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    @Override
    public double getDouble() {
        return this.countCollector.count() > 0L ? this.sumCollector.sum() / (double)this.countCollector.count() : 0.0;
    }

    @Override
    public boolean exists() {
        return this.sumCollector.exists() && this.countCollector.count() > 0L;
    }

    @Override
    public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
        this.sumCollector = (SumCollector)sync.apply(this.sumCollector);
        this.countCollector = (CountCollector)sync.apply(this.countCollector);
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.REDUCTION;
    }

    protected static class SumData
    extends ReductionData
    implements Serializable {
        private static final long serialVersionUID = 5920718235872898338L;
        double sum;

        protected SumData() {
        }
    }
}

