/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

class CloudStorageWriteFileChannel
extends FileChannel {
    private static final String WRITE_ONLY = "This FileChannel is write-only";
    private SeekableByteChannel writeChannel;
    private boolean valid = true;

    CloudStorageWriteFileChannel(SeekableByteChannel writeChannel) {
        this.writeChannel = writeChannel;
    }

    private void checkValid() throws IOException {
        if (!this.valid) {
            throw new IOException("This FileChannel is no longer valid. A Cloud Storage FileChannel is invalidated after calling one of the methods FileChannel#write(ByteBuffer, long) or FileChannel#transferFrom(ReadableByteChannel, long, long)");
        }
        if (!this.writeChannel.isOpen()) {
            throw new IOException("This FileChannel is closed");
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        throw new UnsupportedOperationException(WRITE_ONLY);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(WRITE_ONLY);
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        this.checkValid();
        return this.writeChannel.write(src);
    }

    @Override
    public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.checkValid();
        long res = 0L;
        for (int i = offset; i < offset + length; ++i) {
            res += (long)this.writeChannel.write(srcs[i]);
        }
        return res;
    }

    @Override
    public synchronized long position() throws IOException {
        this.checkValid();
        return this.writeChannel.position();
    }

    @Override
    public synchronized FileChannel position(long newPosition) throws IOException {
        if (newPosition != this.position()) {
            this.writeChannel.position(newPosition);
        }
        return this;
    }

    @Override
    public synchronized long size() throws IOException {
        this.checkValid();
        return this.writeChannel.size();
    }

    @Override
    public synchronized FileChannel truncate(long size) throws IOException {
        this.checkValid();
        this.writeChannel.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException(WRITE_ONLY);
    }

    @Override
    public synchronized long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position != this.position()) {
            throw new UnsupportedOperationException("This FileChannel only supports transferFrom at the current position");
        }
        int blockSize = (int)Math.min(count, 1048575L);
        long res = 0L;
        int bytesRead = 0;
        ByteBuffer buffer = ByteBuffer.allocate(blockSize);
        while (res < count && bytesRead >= 0) {
            buffer.position(0);
            bytesRead = src.read(buffer);
            if (bytesRead <= 0) continue;
            buffer.position(0);
            buffer.limit(bytesRead);
            this.write(buffer);
            res += (long)bytesRead;
        }
        this.valid = false;
        return res;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        throw new UnsupportedOperationException(WRITE_ONLY);
    }

    @Override
    public synchronized int write(ByteBuffer src, long position) throws IOException {
        if (position != this.position()) {
            throw new UnsupportedOperationException("This FileChannel only supports write at the current position");
        }
        int res = this.writeChannel.write(src);
        this.valid = false;
        return res;
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.writeChannel.close();
    }
}

