/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.file.FileUserPasswdStore;
import org.elasticsearch.xpack.security.authc.file.FileUserRolesStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;

public class FileRealm
extends CachingUsernamePasswordRealm {
    private final FileUserPasswdStore userPasswdStore;
    private final FileUserRolesStore userRolesStore;

    public FileRealm(RealmConfig config, ResourceWatcherService watcherService, ThreadPool threadPool) {
        this(config, new FileUserPasswdStore(config, watcherService), new FileUserRolesStore(config, watcherService), threadPool);
    }

    FileRealm(RealmConfig config, FileUserPasswdStore userPasswdStore, FileUserRolesStore userRolesStore, ThreadPool threadPool) {
        super("file", config, threadPool);
        this.userPasswdStore = userPasswdStore;
        userPasswdStore.addListener(this::expireAll);
        this.userRolesStore = userRolesStore;
        userRolesStore.addListener(this::expireAll);
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        AuthenticationResult result = this.userPasswdStore.verifyPassword(token.principal(), token.credentials(), () -> {
            String[] roles = this.userRolesStore.roles(token.principal());
            return new User(token.principal(), roles);
        });
        listener.onResponse((Object)result);
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (this.userPasswdStore.userExists(username)) {
            String[] roles = this.userRolesStore.roles(username);
            listener.onResponse((Object)new User(username, roles));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public void usageStats(ActionListener<Map<String, Object>> listener) {
        super.usageStats((ActionListener<Map<String, Object>>)ActionListener.wrap(stats -> {
            stats.put("size", this.userPasswdStore.usersCount());
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

