/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryOptionalMathProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryOptionalNumericFunction
extends ScalarFunction {
    private final Expression left;
    private final Expression right;

    public BinaryOptionalNumericFunction(Source source, Expression left, Expression right) {
        super(source, right != null ? Arrays.asList(left, right) : Arrays.asList(left));
        this.left = left;
        this.right = right;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric(this.left, this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.right == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isInteger(this.right, this.sourceText(), Expressions.ParamOrdinal.SECOND);
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryOptionalMathPipe(this.source(), this, Expressions.pipe(this.left), this.right == null ? null : Expressions.pipe(this.right), this.operation());
    }

    protected abstract BinaryOptionalMathProcessor.BinaryOptionalMathOperation operation();

    @Override
    public boolean foldable() {
        return this.left.foldable() && (this.right == null || this.right.foldable());
    }

    @Override
    public Object fold() {
        return this.operation().apply((Number)this.left.fold(), this.right == null ? (Number)null : (Number)((Number)this.right.fold()));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (this.right() != null && newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        if (this.right() == null && newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replacedChildrenInstance(newChildren);
    }

    protected abstract Expression replacedChildrenInstance(List<Expression> var1);

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.left);
        ScriptTemplate rightScript = this.asOptionalScript(this.right);
        return this.asScriptFrom(leftScript, rightScript);
    }

    private ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s)"), this.operation().name().toLowerCase(Locale.ROOT), leftScript.template(), rightScript.template()), ParamsBuilder.paramsBuilder().script(leftScript.params()).script(rightScript.params()).build(), this.dataType());
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    protected Expression left() {
        return this.left;
    }

    protected Expression right() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryOptionalNumericFunction other = (BinaryOptionalNumericFunction)obj;
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right()) && Objects.equals(other.operation(), this.operation());
    }
}

