/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class BinaryStringFunction<T, R>
extends BinaryScalarFunction {
    protected BinaryStringFunction(Source source, Expression left, Expression right) {
        super(source, left, right);
    }

    protected abstract BiFunction<String, T, R> operation();

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact(this.left(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.resolveSecondParameterInputType(this.right());
    }

    protected abstract Expression.TypeResolution resolveSecondParameterInputType(Expression var1);

    @Override
    public Object fold() {
        Object fold = this.right().fold();
        return this.operation().apply((String)this.left().fold(), (String)fold);
    }

    @Override
    protected String scriptMethodName() {
        return this.operation().toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryStringFunction other = (BinaryStringFunction)obj;
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right());
    }
}

