/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class ConcatFunctionProcessor
extends BinaryProcessor {
    public static final String NAME = "scon";

    public ConcatFunctionProcessor(Processor source1, Processor source2) {
        super(source1, source2);
    }

    public ConcatFunctionProcessor(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Object process(Object input) {
        Object l = this.left().process(input);
        this.checkParameter(l);
        Object r = this.right().process(input);
        this.checkParameter(r);
        return this.doProcess(l, r);
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        return ConcatFunctionProcessor.process(left, right);
    }

    public static Object process(Object source1, Object source2) {
        if (source1 == null && source2 == null) {
            return "";
        }
        if (source1 == null) {
            return source2;
        }
        if (source2 == null) {
            return source1;
        }
        if (!(source1 instanceof String) && !(source1 instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source1);
        }
        if (!(source2 instanceof String) && !(source2 instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source2);
        }
        return source1.toString().concat(source2.toString());
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConcatFunctionProcessor other = (ConcatFunctionProcessor)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
    }
}

