/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ValidationDriver {
    private static final PropertyId[] requiredProperties = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER};
    private static final Class[] defaultClasses = new Class[]{Jaxp11XMLReaderCreator.class, ErrorHandlerImpl.class};
    private final XMLReaderCreator xrc;
    private XMLReader xr;
    private final CountingErrorHandler eh;
    private final SchemaReader sr;
    private final PropertyMap schemaProperties;
    private final PropertyMap instanceProperties;
    private Validator validator;
    private Schema schema;

    public ValidationDriver(PropertyMap schemaProperties, PropertyMap instanceProperties, SchemaReader schemaReader) {
        int i;
        PropertyMapBuilder builder = new PropertyMapBuilder(schemaProperties);
        for (i = 0; i < requiredProperties.length; ++i) {
            if (builder.contains(requiredProperties[i])) continue;
            try {
                builder.put(requiredProperties[i], defaultClasses[i].newInstance());
                continue;
            }
            catch (InstantiationException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        this.schemaProperties = builder.toPropertyMap();
        builder = new PropertyMapBuilder(instanceProperties);
        for (i = 0; i < requiredProperties.length; ++i) {
            if (builder.contains(requiredProperties[i])) continue;
            builder.put(requiredProperties[i], this.schemaProperties.get(requiredProperties[i]));
        }
        this.eh = new CountingErrorHandler((ErrorHandler)builder.get(ValidateProperty.ERROR_HANDLER));
        ValidateProperty.ERROR_HANDLER.put(builder, this.eh);
        this.instanceProperties = builder.toPropertyMap();
        this.xrc = ValidateProperty.XML_READER_CREATOR.get(this.instanceProperties);
        this.sr = schemaReader == null ? new AutoSchemaReader() : schemaReader;
    }

    public ValidationDriver(PropertyMap schemaProperties, PropertyMap instanceProperties) {
        this(schemaProperties, instanceProperties, null);
    }

    public ValidationDriver(PropertyMap properties, SchemaReader sr) {
        this(properties, properties, sr);
    }

    public ValidationDriver(PropertyMap properties) {
        this(properties, properties, null);
    }

    public ValidationDriver(SchemaReader sr) {
        this(PropertyMap.EMPTY, sr);
    }

    public ValidationDriver() {
        this(PropertyMap.EMPTY, PropertyMap.EMPTY, null);
    }

    public boolean loadSchema(InputSource in) throws SAXException, IOException {
        try {
            this.schema = this.sr.createSchema(in, this.schemaProperties);
            this.validator = null;
            return true;
        }
        catch (IncorrectSchemaException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(InputSource in) throws SAXException, IOException {
        if (this.schema == null) {
            throw new IllegalStateException("cannot validate without schema");
        }
        if (this.validator == null) {
            this.validator = this.schema.createValidator(this.instanceProperties);
        }
        if (this.xr == null) {
            this.xr = this.xrc.createXMLReader();
            this.xr.setErrorHandler(this.eh);
        }
        this.eh.reset();
        this.xr.setContentHandler(this.validator.getContentHandler());
        DTDHandler dh = this.validator.getDTDHandler();
        if (dh != null) {
            this.xr.setDTDHandler(dh);
        }
        try {
            this.xr.parse(in);
            boolean bl = !this.eh.getHadErrorOrFatalError();
            return bl;
        }
        finally {
            this.validator.reset();
        }
    }

    public static InputSource fileInputSource(String filename) throws MalformedURLException {
        return ValidationDriver.fileInputSource(new File(filename));
    }

    public static InputSource fileInputSource(File file) throws MalformedURLException {
        return new InputSource(UriOrFile.fileToUri(file));
    }

    public static InputSource uriOrFileInputSource(String uriOrFile) throws MalformedURLException {
        return new InputSource(UriOrFile.toUri(uriOrFile));
    }
}

