/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.gwt.dev.util.Name;
import com.google.web.bindery.requestfactory.apt.RfValidator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class ValidationTool {
    public static void main(String[] args) throws IOException {
        System.exit(ValidationTool.exec(args) ? 0 : -1);
    }

    public static boolean exec(String[] args) throws IOException {
        return ValidationTool.exec(args, ToolProvider.getSystemJavaCompiler());
    }

    public static boolean exec(String[] args, JavaCompiler compiler) throws IOException {
        return ValidationTool.exec(args, compiler, null);
    }

    public static boolean exec(String[] args, JavaCompiler compiler, Iterable<String> javacOpts) throws IOException {
        if (args.length < 2) {
            System.err.println("java -cp requestfactory-client.jar:your_server-code.jar " + ValidationTool.class.getCanonicalName() + " (/some/directory | output.jar) com.example.shared.MyRequestFactory");
            System.err.println("See http://code.google.com/p/google-web-toolkit/wiki/RequestFactoryInterfaceValidation for more information.");
            return false;
        }
        if (compiler == null) {
            System.err.println("This tool must be run with a JDK, not a JRE");
            return false;
        }
        if (!compiler.getSourceVersions().contains((Object)SourceVersion.RELEASE_6)) {
            System.err.println("This tool must be run with a Java 1.6 compiler");
            return false;
        }
        boolean clientOnly = false;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (((String)argList.get(0)).equals("-client")) {
            clientOnly = true;
            argList.remove(0);
        }
        JarOrDirectoryOutputFileManager fileManager = new JarOrDirectoryOutputFileManager(new File((String)argList.remove(0)), compiler.getStandardFileManager(null, null, null));
        RfValidator processor = new RfValidator();
        if (clientOnly) {
            processor.setClientOnly(true);
        } else {
            processor.setMustResolveAllMappings(true);
        }
        processor.setRootOverride(argList);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, javacOpts, null, Arrays.asList(new FakeJavaFileObject()));
        task.setProcessors(Arrays.asList(processor));
        if (!task.call().booleanValue()) {
            return false;
        }
        fileManager.close();
        return true;
    }

    private static URI uri(String contents) {
        try {
            return new URI(contents);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MemoryJavaFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream bytes;
        private StringWriter charContents;

        public MemoryJavaFileObject(URI uri, JavaFileObject.Kind kind) {
            super(uri, kind);
        }

        @Override
        public CharSequence getCharContent(boolean ignored) throws IOException {
            return this.charContents.toString();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            this.bytes = new ByteArrayOutputStream();
            return this.bytes;
        }

        @Override
        public Writer openWriter() throws IOException {
            this.charContents = new StringWriter();
            return this.charContents;
        }
    }

    private static class FakeJavaFileObject
    extends SimpleJavaFileObject {
        public FakeJavaFileObject() {
            super(ValidationTool.uri("fake:///fake/Fake.java"), JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean arg0) throws IOException {
            return "package fake; interface Fake {}";
        }
    }

    static class JarOrDirectoryOutputFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final List<MemoryJavaFileObject> toOutput = new ArrayList<MemoryJavaFileObject>();
        private final File output;

        JarOrDirectoryOutputFileManager(File output, JavaFileManager fileManager) {
            super(fileManager);
            this.output = output;
        }

        @Override
        public void close() throws IOException {
            if (this.output.isDirectory()) {
                this.writeToDirectory();
            } else {
                this.writeToJar();
            }
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            throw new UnsupportedOperationException("Not expecting to write " + packageName + "/" + relativeName);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            String suffix;
            String path = Name.BinaryName.toInternalName(className);
            switch (kind) {
                case CLASS: {
                    suffix = ".class";
                    break;
                }
                case SOURCE: {
                    suffix = ".java";
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected kind " + (Object)((Object)kind));
                }
            }
            MemoryJavaFileObject toReturn = new MemoryJavaFileObject(ValidationTool.uri("memory:///" + path + suffix), kind);
            if (StandardLocation.CLASS_OUTPUT.equals(location) && JavaFileObject.Kind.CLASS.equals((Object)kind)) {
                this.toOutput.add(toReturn);
            }
            return toReturn;
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            if (a instanceof MemoryJavaFileObject && b instanceof MemoryJavaFileObject) {
                MemoryJavaFileObject memoryA = (MemoryJavaFileObject)a;
                MemoryJavaFileObject memoryB = (MemoryJavaFileObject)b;
                return memoryA.getKind().equals((Object)memoryB.getKind()) && memoryA.toUri().equals(memoryB.toUri());
            }
            if (a instanceof FakeJavaFileObject && b instanceof FakeJavaFileObject) {
                return true;
            }
            return super.isSameFile(a, b);
        }

        private void writeToDirectory() throws IOException {
            for (MemoryJavaFileObject file : this.toOutput) {
                String path = file.toUri().getPath();
                if (path.equals("/fake/Fake.class")) continue;
                File target = new File(this.output, path);
                target.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(target);
                out.write(file.bytes.toByteArray());
                out.close();
            }
        }

        private void writeToJar() throws IOException, FileNotFoundException {
            JarOutputStream jar = new JarOutputStream(new FileOutputStream(this.output));
            for (MemoryJavaFileObject file : this.toOutput) {
                String path = file.toUri().getPath();
                if (path.equals("/fake/Fake.class")) continue;
                ZipEntry entry = new ZipEntry(path.substring(1));
                jar.putNextEntry(entry);
                jar.write(file.bytes.toByteArray());
            }
            jar.close();
        }
    }
}

