/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.EndPoint;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.authenticator.LoginManager;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a<Q!\u0001\u0002\t\u0002\u001d\tQ\u0003R=oC6L7\rT5ti\u0016tWM]\"p]\u001aLwM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005U!\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u0017\u0013\t\u0007I\u0011A\f\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\t\u0001\u0004E\u0002\u001a9yi\u0011A\u0007\u0006\u000379\t!bY8mY\u0016\u001cG/[8o\u0013\ti\"DA\u0002TKR\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O%\u0001\u000b\u0011\u0002\r\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00022AA\u0003\u0002\u0001SM!\u0001\u0006\u0004\u0016.!\tA1&\u0003\u0002-\u0005\t!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iz#a\u0002'pO\u001eLgn\u001a\u0005\t\u0007!\u0012\t\u0011)A\u0005iA\u0011\u0001\"N\u0005\u0003m\t\u00111bS1gW\u0006\u001cVM\u001d<fe\")1\u0003\u000bC\u0001qQ\u0011\u0011H\u000f\t\u0003\u0011!BQaA\u001cA\u0002QBQ\u0001\u0010\u0015\u0005Bu\nQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001?!\rIBd\u0010\t\u0003\u0001\u001es!!Q#\u0011\u0005\tsQ\"A\"\u000b\u0005\u00113\u0011A\u0002\u001fs_>$h(\u0003\u0002G\u001d\u00051\u0001K]3eK\u001aL!!\n%\u000b\u0005\u0019s\u0001\"\u0002&)\t\u0003Y\u0015a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\tau\n\u0005\u0002\u000e\u001b&\u0011aJ\u0004\u0002\u0005+:LG\u000fC\u0003Q\u0013\u0002\u0007\u0011+A\u0005oK^\u001cuN\u001c4jOB\u0011\u0001BU\u0005\u0003'\n\u00111bS1gW\u0006\u001cuN\u001c4jO\")Q\u000b\u000bC\u0001-\u0006Y!/Z2p]\u001aLw-\u001e:f)\rau+\u0017\u0005\u00061R\u0003\r!U\u0001\n_2$7i\u001c8gS\u001eDQ\u0001\u0015+A\u0002ECQa\u0017\u0015\u0005\nq\u000ba\u0002\\5ti\u0016tWM]:U_6\u000b\u0007\u000f\u0006\u0002^gB!\u0011D\u00181n\u0013\ty&DA\u0002NCB\u0004\"!Y6\u000e\u0003\tT!a\u00193\u0002\u000f9,Go^8sW*\u0011QMZ\u0001\u0007G>lWn\u001c8\u000b\u0005\u00159'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001eL!\u0001\u001c2\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\u00059\fX\"A8\u000b\u0005A$\u0011aB2mkN$XM]\u0005\u0003e>\u0014\u0001\"\u00128e!>Lg\u000e\u001e\u0005\u0006ij\u0003\r!^\u0001\nY&\u001cH/\u001a8feN\u00042!\u0007<n\u0013\t9(DA\u0002TKF\u0004")
public class DynamicListenerConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaServer server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicListenerConfig dynamicListenerConfig = this;
        synchronized (dynamicListenerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        KafkaConfig oldConfig = this.server.config();
        Map<ListenerName, EndPoint> newListeners = this.listenersToMap(newConfig.listeners());
        Map<ListenerName, EndPoint> newAdvertisedListeners = this.listenersToMap(newConfig.advertisedListeners());
        Map<ListenerName, EndPoint> oldListeners = this.listenersToMap(oldConfig.listeners());
        if (!newAdvertisedListeners.keySet().subsetOf((GenSet)newListeners.keySet())) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Advertised listeners '", "' must be a subset of listeners '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newAdvertisedListeners, newListeners})));
        }
        if (!newListeners.keySet().subsetOf((GenSet)newConfig.listenerSecurityProtocolMap().keySet())) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listeners '", "' must be subset of listener map '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newListeners, newConfig.listenerSecurityProtocolMap()})));
        }
        ((IterableLike)newListeners.keySet().intersect((GenSet)oldListeners.keySet())).foreach((Function1 & Serializable & scala.Serializable)listenerName -> {
            DynamicListenerConfig.$anonfun$validateReconfiguration$7(newConfig, oldConfig, listenerName);
            return BoxedUnit.UNIT;
        });
        if (!newAdvertisedListeners.contains((Object)newConfig.interBrokerListenerName())) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Advertised listener must be specified for inter-broker listener ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newConfig.interBrokerListenerName()})));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Seq<EndPoint> newListeners = newConfig.listeners();
        Map<ListenerName, EndPoint> newListenerMap = this.listenersToMap(newListeners);
        Seq<EndPoint> oldListeners = oldConfig.listeners();
        Map<ListenerName, EndPoint> oldListenerMap = this.listenersToMap(oldListeners);
        Seq listenersRemoved = (Seq)oldListeners.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)newListenerMap.contains((Object)e.listenerName())));
        Seq listenersAdded = (Seq)newListeners.filterNot((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)oldListenerMap.contains((Object)e.listenerName())));
        if (listenersAdded.nonEmpty() || listenersRemoved.nonEmpty()) {
            LoginManager.closeAll();
        }
        this.server.socketServer().removeListeners((Seq<EndPoint>)listenersRemoved);
        if (listenersAdded.nonEmpty()) {
            this.server.socketServer().addListeners((Seq<EndPoint>)listenersAdded);
        }
        this.server.kafkaController().updateBrokerInfo(this.server.createBrokerInfo());
    }

    private Map<ListenerName, EndPoint> listenersToMap(Seq<EndPoint> listeners) {
        return ((TraversableOnce)listeners.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)e.listenerName(), e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$6(String k) {
        return !DynamicBrokerConfig$.MODULE$.DynamicSecurityConfigs().contains((Object)k);
    }

    private static final Map immutableListenerConfigs$1(KafkaConfig kafkaConfig, String prefix, KafkaConfig newConfig$4) {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newConfig$4.originals()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(prefix))).filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DynamicListenerConfig.$anonfun$validateReconfiguration$6(k)));
    }

    public static final /* synthetic */ void $anonfun$validateReconfiguration$7(KafkaConfig newConfig$4, KafkaConfig oldConfig$3, ListenerName listenerName) {
        String prefix = listenerName.configPrefix();
        Map newListenerProps = DynamicListenerConfig.immutableListenerConfigs$1(newConfig$4, prefix, newConfig$4);
        Map oldListenerProps = DynamicListenerConfig.immutableListenerConfigs$1(oldConfig$3, prefix, newConfig$4);
        Map map = newListenerProps;
        Map map2 = oldListenerProps;
        if (map == null ? map2 != null : !map.equals(map2)) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configs cannot be updated dynamically for existing listener ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName})) + "restart broker or create a new listener for update");
        }
        if (!BoxesRunTime.equals((Object)oldConfig$3.listenerSecurityProtocolMap().apply((Object)listenerName), (Object)newConfig$4.listenerSecurityProtocolMap().apply((Object)listenerName))) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Security protocol cannot be updated for existing listener ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName})));
        }
    }

    public DynamicListenerConfig(KafkaServer server) {
        this.server = server;
        Logging.$init$(this);
    }
}

