/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.security.auth.Acl;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.zk.AclChangeNotificationZNode$;
import kafka.zk.AclZNode$;
import kafka.zk.AdminZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConsumerOffset$;
import kafka.zk.ControllerEpochZNode$;
import kafka.zk.ControllerZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ResourceTypeZNode$;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkData$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZNodeChangeHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r5d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cS1gW\u0006T6n\u00117jK:$H+Z:u\u0015\t\u0019A!\u0001\u0002{W*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013%!#A\u0003he>,\b/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003mC:<'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011aa\u0015;sS:<\u0007B\u0002\u000f\u0001A\u0003%1#\u0001\u0004he>,\b\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dc!1\u0001\u0005\u0001Q\u0001\nM\tq\u0001^8qS\u000e\f\u0004\u0005C\u0004#\u0001\t\u0007I\u0011\u0002\n\u0002\rQ|\u0007/[23\u0011\u0019!\u0003\u0001)A\u0005'\u00059Ao\u001c9jGJ\u0002\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8ocA*\u0012\u0001\u000b\t\u0003SEj\u0011A\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]F\u0002\u0004\u0005C\u00047\u0001\t\u0007I\u0011A\u0014\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]F\n\u0004B\u0002\u001d\u0001A\u0003%\u0001&A\tu_BL7\rU1si&$\u0018n\u001c82c\u0001BqA\u000f\u0001C\u0002\u0013\u0005q%\u0001\tu_BL7\rU1si&$\u0018n\u001c83a!1A\b\u0001Q\u0001\n!\n\u0011\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0019!\u0011\u001dq\u0004A1A\u0005\u0002}\nA\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u00191?F\nT#\u0001!\u0011\u0007\u00053\u0005&D\u0001C\u0015\t\u0019E)\u0001\u0006d_2dWm\u0019;j_:T\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\n\u00131aU3r\u0011\u0019I\u0005\u0001)A\u0005\u0001\u0006)Bo\u001c9jGB\u000b'\u000f^5uS>t7/\r\u0019`cE\u0002\u0003\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u00035yG\u000f[3s5.\u001cE.[3oiV\tQ\n\u0005\u0002\n\u001d&\u0011qJ\u0001\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0016!E8uQ\u0016\u0014(l[\"mS\u0016tGo\u0018\u0013fcR\u00111k\u0016\t\u0003)Vk\u0011\u0001R\u0005\u0003-\u0012\u0013A!\u00168ji\"9\u0001\fUA\u0001\u0002\u0004i\u0015a\u0001=%c!I!\f\u0001a\u0001\u0002\u0003\u0006K!T\u0001\u000f_RDWM\u001d.l\u00072LWM\u001c;!\u0011\u0015a\u0006\u0001\"\u0011^\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0006FA.`!\t\u00017-D\u0001b\u0015\t\u0011w&A\u0003kk:LG/\u0003\u0002eC\n1!)\u001a4pe\u0016DQA\u001a\u0001\u0005Bu\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003K\"\u0004\"\u0001Y5\n\u0005)\f'!B!gi\u0016\u0014\bb\u00027\u0001\u0005\u0004%IaJ\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019q\u0007\u0001)A\u0005Q\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0003q\u0001\u0011\u0005Q,A\u000euKN$8+\u001a;B]\u0012<U\r^\"p]N,X.\u001a:PM\u001a\u001cX\r\u001e\u0015\u0003_J\u0004\"\u0001Y:\n\u0005Q\f'\u0001\u0002+fgRDQA\u001e\u0001\u0005\u0002u\u000b1\u0004^3ti\u001e+GoQ8ogVlWM](gMN,GOT8ECR\f\u0007FA;s\u0011\u0015I\b\u0001\"\u0001^\u0003M!Xm\u001d;EK2,G/\u001a*fGV\u00148/\u001b<fQ\tA(\u000fC\u0003}\u0001\u0011\u0005Q,A\nuKN$8I]3bi\u0016\u0014VmY;sg&4X\r\u000b\u0002|e\")q\u0010\u0001C\u0001;\u0006QB/Z:u)>\u0004\u0018nY!tg&<g.\\3oi6+G\u000f[8eg\"\u0012aP\u001d\u0005\u0007\u0003\u000b\u0001A\u0011A/\u0002+Q,7\u000f^$fi\u0012\u000bG/Y!oIZ+'o]5p]\"\u001a\u00111\u0001:\t\r\u0005-\u0001\u0001\"\u0001^\u0003e!Xm\u001d;D_:$\u0017\u000e^5p]\u0006dW\u000b\u001d3bi\u0016\u0004\u0016\r\u001e5)\u0007\u0005%!\u000f\u0003\u0004\u0002\u0012\u0001!\t!X\u0001#i\u0016\u001cHo\u0011:fCR,7+Z9vK:$\u0018.\u00197QKJ\u001c\u0018n\u001d;f]R\u0004\u0016\r\u001e5)\u0007\u0005=!\u000f\u0003\u0004\u0002\u0018\u0001!\t!X\u0001\u0018i\u0016\u001cH\u000f\u0015:pa\u0006<\u0017\r^3JgJ\u001c\u0005.\u00198hKND3!!\u0006s\u0011\u0019\ti\u0002\u0001C\u0001;\u0006\u0001C/Z:u\u0013N\u00148\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u000f\u0016$H/\u001a:tQ\r\tYB\u001d\u0005\u0007\u0003G\u0001A\u0011A/\u0002EQ,7\u000f^%te\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\\:EK2,G/[8oQ\r\t\tC\u001d\u0005\u0007\u0003S\u0001A\u0011A/\u0002'Q,7\u000f\u001e)s_B\fw-\u0019;f\u0019><G)\u001b:)\u0007\u0005\u001d\"\u000f\u0003\u0004\u00020\u0001!\t!X\u0001\u0012i\u0016\u001cH\u000fT8h\t&\u0014x)\u001a;uKJ\u001c\bfAA\u0017e\"1\u0011Q\u0007\u0001\u0005\u0002u\u000bA\u0005^3ti2{w\rR5s\u000bZ,g\u000e\u001e(pi&4\u0017nY1uS>t7\u000fR3mKRLwN\u001c\u0015\u0004\u0003g\u0011\bBBA\u001e\u0001\u0011\u0005Q,\u0001\u0015uKN$8+\u001a;HKR\fe\u000e\u001a#fY\u0016$X\rU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fK\u0002\u0002:IDa!!\u0011\u0001\t\u0003i\u0016A\u0005;fgR<U\r\u001e#bi\u0006\fe\u000eZ*uCRD3!a\u0010s\u0011\u0019\t9\u0005\u0001C\u0001;\u0006yA/Z:u\u000f\u0016$8\t[5mIJ,g\u000eK\u0002\u0002FIDa!!\u0014\u0001\t\u0003i\u0016\u0001\u0007;fgR\f5\r\\'b]\u0006<W-\\3oi6+G\u000f[8eg\"\u001a\u00111\n:\t\r\u0005M\u0003\u0001\"\u0001^\u00039!Xm\u001d;EK2,G/\u001a)bi\"D3!!\u0015s\u0011\u0019\tI\u0006\u0001C\u0001;\u0006!B/Z:u\t\u0016dW\r^3U_BL7M\u0017(pI\u0016D3!a\u0016s\u0011\u0019\ty\u0006\u0001C\u0001;\u0006QB/Z:u\t\u0016dW\r^3U_BL7\rU1uQ6+G\u000f[8eg\"\u001a\u0011Q\f:\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h\u0005Q\u0012m]:feR\u0004\u0016\r\u001e5Fq&\u001cH/\u001a8dK\u0006sG\rR1uCR)1+!\u001b\u0002\u0002\"A\u00111NA2\u0001\u0004\ti'\u0001\u0007fqB,7\r^3e!\u0006$\b\u000e\u0005\u0003\u0002p\u0005ud\u0002BA9\u0003s\u00022!a\u001dE\u001b\t\t)HC\u0002\u0002x\u0019\ta\u0001\u0010:p_Rt\u0014bAA>\t\u00061\u0001K]3eK\u001aL1AGA@\u0015\r\tY\b\u0012\u0005\t\u0003\u0007\u000b\u0019\u00071\u0001\u0002n\u0005!A-\u0019;b\u0011\u0019\t9\t\u0001C\u0001;\u0006\tC/Z:u\u0007J,\u0017\r^3U_.,gn\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\"\u001a\u0011Q\u0011:\t\r\u00055\u0005\u0001\"\u0001^\u0003\u0005\"Xm\u001d;F]RLG/_\"p]\u001aLw-T1oC\u001e,W.\u001a8u\u001b\u0016$\bn\u001c3tQ\r\tYI\u001d\u0005\u0007\u0003'\u0003A\u0011A/\u0002EQ,7\u000f^\"sK\u0006$XmQ8oM&<7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8oQ\r\t\tJ\u001d\u0005\b\u00033\u0003A\u0011BAN\u00039\u0019'/Z1uK2{w\r\u0015:paN$B!!(\u0002*B!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$^\tA!\u001e;jY&!\u0011qUAQ\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\t\u0003W\u000b9\n1\u0001\u0002.\u0006I!-\u001f;fgB\u0013x\u000e\u001d\t\u0004)\u0006=\u0016bAAY\t\n\u0019\u0011J\u001c;\t\u0013\u0005U\u0006A1A\u0005\n\u0005]\u0016\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005u\u0005\u0002CA^\u0001\u0001\u0006I!!(\u0002\u00131|w\r\u0015:paN\u0004\u0003BBA`\u0001\u0011\u0005Q,A\tuKN$x)\u001a;M_\u001e\u001cuN\u001c4jOND3!!0s\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\f\u0001c\u0019:fCR,'I]8lKJLeNZ8\u0015\u0019\u0005%\u0017qZAj\u0003/\fY.a<\u0011\u0007%\tY-C\u0002\u0002N\n\u0011!B\u0011:pW\u0016\u0014\u0018J\u001c4p\u0011!\t\t.a1A\u0002\u00055\u0016AA5e\u0011!\t).a1A\u0002\u00055\u0014\u0001\u00025pgRD\u0001\"!7\u0002D\u0002\u0007\u0011QV\u0001\u0005a>\u0014H\u000f\u0003\u0005\u0002^\u0006\r\u0007\u0019AAp\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003ST\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\t\u00055\u00181\u001d\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2D!\"!=\u0002DB\u0005\t\u0019AAz\u0003\u0011\u0011\u0018mY6\u0011\u000bQ\u000b)0!\u001c\n\u0007\u0005]HI\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003w\u0004A\u0011A/\u0002-Q,7\u000f\u001e*fO&\u001cH/\u001a:Ce>\\WM]%oM>D3!!?s\u0011\u0019\u0011\t\u0001\u0001C\u0001;\u0006!B/Z:u\u000f\u0016$(I]8lKJlU\r\u001e5pIND3!a@s\u0011\u0019\u00119\u0001\u0001C\u0001;\u0006!B/Z:u+B$\u0017\r^3Ce>\\WM]%oM>D3A!\u0002s\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\tqb\u001d;bi^KG\u000f\u001b,feNLwN\u001c\u000b\u0005\u0005#\u0011y\u0002\u0005\u0003\u0003\u0014\tmQB\u0001B\u000b\u0015\u0011\t\u0019Ia\u0006\u000b\u0007\teQ&A\u0005{_>\\W-\u001a9fe&!!Q\u0004B\u000b\u0005\u0011\u0019F/\u0019;\t\u0011\t\u0005\"1\u0002a\u0001\u0003[\u000bqA^3sg&|g\u000eC\u0004\u0003&\u0001!IAa\n\u000291,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2igR1!\u0011\u0006B\u001e\u0005\u007f\u0001r!a\u001c\u0003,!\u0012y#\u0003\u0003\u0003.\u0005}$aA'baB!!\u0011\u0007B\u001c\u001b\t\u0011\u0019DC\u0002\u00036\u0011\t!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011IDa\r\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011!\u0011iDa\tA\u0002\u00055\u0016!B:uCR,\u0007\u0002\u0003B!\u0005G\u0001\r!!,\u0002\u0013i\\g+\u001a:tS>t\u0007\"\u0003B#\u0001\t\u0007I\u0011\u0001B$\u0003\rJg.\u001b;jC2dU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQN,\"A!\u000b\t\u0011\t-\u0003\u0001)A\u0005\u0005S\tA%\u001b8ji&\fG\u000eT3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD7\u000f\t\u0005\n\u0005\u001f\u0002!\u0019!C\u0001\u0005#\n\u0011#\u001b8ji&\fG\u000eT3bI\u0016\u0014\u0018j\u001d:t+\t\u0011\u0019\u0006E\u0004\u0002p\t-\u0002F!\u0016\u0011\t\t]#QL\u0007\u0003\u00053R1Aa\u0017\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005?\u0012IF\u0001\u0007MK\u0006$WM]!oI&\u001b(\u000f\u0003\u0005\u0003d\u0001\u0001\u000b\u0011\u0002B*\u0003IIg.\u001b;jC2dU-\u00193fe&\u001b(o\u001d\u0011\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\u0005QA.Z1eKJL5O]:\u0015\r\tM#1\u000eB7\u0011!\u0011iD!\u001aA\u0002\u00055\u0006\u0002\u0003B!\u0005K\u0002\r!!,\t\u000f\tE\u0004\u0001\"\u0003\u0003t\u0005i2\r[3dWV\u0003H-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fgVdG\u000fF\u0005T\u0005k\u0012IH! \u0003(\"A!q\u000fB8\u0001\u0004\u0011\u0019&\u0001\u000ffqB,7\r^3e'V\u001c7-Z:tMVd\u0007+\u0019:uSRLwN\\:\t\u000f\tm$q\u000ea\u0001\u0001\u0006IR\r\u001f9fGR,G\rU1si&$\u0018n\u001c8t)>\u0014V\r\u001e:z\u0011!\u0011yHa\u001cA\u0002\t\u0005\u0015\u0001G3ya\u0016\u001cG/\u001a3GC&dW\r\u001a)beRLG/[8ogB9\u0011q\u000eB\u0016Q\t\r\u0005c\u0002+\u0003\u0006\n%\u0015QN\u0005\u0004\u0005\u000f#%A\u0002+va2,'\u0007\r\u0003\u0003\f\nU\u0005CBA8\u0005\u001b\u0013\t*\u0003\u0003\u0003\u0010\u0006}$!B\"mCN\u001c\b\u0003\u0002BJ\u0005+c\u0001\u0001\u0002\u0007\u0003\u0018\nu\u0014\u0011!A\u0001\u0006\u0003\u0011IJA\u0002`IE\nBAa'\u0003\"B\u0019AK!(\n\u0007\t}EIA\u0004O_RD\u0017N\\4\u0011\u0007Q\u0013\u0019+C\u0002\u0003&\u0012\u00131!\u00118z\u0011!\u0011IKa\u001cA\u0002\t-\u0016AH1diV\fG.\u00169eCR,G*Z1eKJ\fe\u000eZ%teJ+7/\u001e7u!\u0011\u0011iKa/\u000f\t\t=&q\u0017\b\u0005\u0005c\u0013)L\u0004\u0003\u0002t\tM\u0016\"A\u0003\n\u0005\r!\u0011b\u0001B]\u0005\u0005i1*\u00194lCj[7\t\\5f]RLAA!0\u0003@\nAR\u000b\u001d3bi\u0016dU-\u00193fe\u0006sG-S:s%\u0016\u001cX\u000f\u001c;\u000b\u0007\te&\u0001\u0003\u0004\u0003D\u0002!\t!X\u0001\u0017i\u0016\u001cH/\u00169eCR,G*Z1eKJ\fe\u000eZ%te\"\u001a!\u0011\u0019:\t\u000f\t%\u0007\u0001\"\u0003\u0003L\u0006!2\r[3dW\u001e+G\u000fR1uCJ+7\u000f]8og\u0016$ra\u0015Bg\u0005\u001f\u0014\t\u000e\u0003\u0005\u0003&\t\u001d\u0007\u0019\u0001B\u0015\u0011\u0019a'q\u0019a\u0001Q!A!1\u001bBd\u0001\u0004\u0011).\u0001\u0005sKN\u0004xN\\:f!\u0011\u00119Na7\u000e\u0005\te'b\u0001B\r\t%!!Q\u001cBm\u0005=9U\r\u001e#bi\u0006\u0014Vm\u001d9p]N,\u0007b\u0002Bq\u0001\u0011%!1]\u0001\u000eKJ\f7/Z'fi\u0006$\u0017\r^1\u0015\t\t\u0015(1\u001e\t\u0005\u0005/\u00149/\u0003\u0003\u0003j\ne'AD\"sK\u0006$XMU3ta>t7/\u001a\u0005\t\u0005'\u0014y\u000e1\u0001\u0003f\"1!q\u001e\u0001\u0005\u0002u\u000b!\u0004^3ti\u001e+G\u000fV8qS\u000e\u001c\u0018I\u001c3QCJ$\u0018\u000e^5p]ND3A!<s\u0011\u0019\u0011)\u0010\u0001C\u0001;\u00069C/Z:u\u0007J,\u0017\r^3B]\u0012<U\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\*uCR,7OU1xQ\r\u0011\u0019P\u001d\u0005\u0007\u0005w\u0004A\u0011A/\u0002=Q,7\u000f^*fiR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3t%\u0006<\bf\u0001B}e\"11\u0011\u0001\u0001\u0005\u0002u\u000b\u0001\u0005^3tiJ+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn]%o!J|wM]3tg\"\u001a!q :\t\r\r\u001d\u0001\u0001\"\u0001^\u0003m!Xm\u001d;HKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\"\u001a1Q\u0001:\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010\u0005!RM]1tK6+G/\u00193bi\u0006\fe\u000eZ*uCR$Ba!\u0005\u0004\u0018A!!q[B\n\u0013\u0011\u0019)B!7\u0003\u001fM+G\u000fR1uCJ+7\u000f]8og\u0016D\u0001Ba5\u0004\f\u0001\u00071\u0011\u0003\u0005\u0007\u00077\u0001A\u0011A/\u00025Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195NKRDw\u000eZ:)\u0007\re!\u000f\u0003\u0004\u0004\"\u0001!\t!X\u0001 i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u001b\u0006t\u0017mZ3nK:$X*\u001a;i_\u0012\u001c\bfAB\u0010e\"11q\u0005\u0001\u0005\u0002u\u000b1\u0005^3tijsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0012\u000bG/Y\"iC:<W\rK\u0002\u0004&IDaa!\f\u0001\t\u0003i\u0016\u0001\u0006;fgR\u001cE.^:uKJLE-T3uQ>$7\u000fK\u0002\u0004,IDaaa\r\u0001\t\u0003i\u0016a\u0007;fgR\u0014%o\\6feN+\u0017/^3oG\u0016LE-T3uQ>$7\u000fK\u0002\u00042IDaa!\u000f\u0001\t\u0003i\u0016a\u0006;fgR\u001c%/Z1uKR{\u0007\u000fT3wK2\u0004\u0016\r\u001e5tQ\r\u00199D\u001d\u0005\u0007\u0007\u007f\u0001A\u0011A/\u0002GQ,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u000b2,7\r^5p]6+G\u000f[8eg\"\u001a1Q\b:\t\u000f\r\u0015\u0003\u0001\"\u0003\u0004H\u0005aA-\u0019;b\u0003N\u001cFO]5oOR!\u00111_B%\u0011!\u0019Yea\u0011A\u0002\u00055\u0014\u0001\u00029bi\"Daaa\u0014\u0001\t\u0003i\u0016A\u0007;fgR$U\r\\3hCRLwN\u001c+pW\u0016tW*\u001a;i_\u0012\u001c\bfAB'e\"I1Q\u000b\u0001\u0012\u0002\u0013%1qK\u0001\u001bGJ,\u0017\r^3Ce>\\WM]%oM>$C-\u001a4bk2$H%N\u000b\u0003\u00073RC!a=\u0004\\-\u00121Q\f\t\u0005\u0007?\u001aI'\u0004\u0002\u0004b)!11MB3\u0003%)hn\u00195fG.,GMC\u0002\u0004h\u0011\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yg!\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class KafkaZkClientTest
extends ZooKeeperTestHarness {
    private final String group;
    private final String topic1;
    private final String topic2;
    private final TopicPartition topicPartition10 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition topicPartition11 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition topicPartition20 = new TopicPartition(this.topic2(), 0);
    private final Seq<TopicPartition> topicPartitions10_11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}));
    private KafkaZkClient otherZkClient;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Properties logProps = this.createLogProps(1024);
    private final scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs = this.leaderIsrAndControllerEpochs(0, 0);
    private final scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs = this.initialLeaderIsrAndControllerEpochs().mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.leaderAndIsr());

    private String group() {
        return this.group;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    public TopicPartition topicPartition10() {
        return this.topicPartition10;
    }

    public TopicPartition topicPartition11() {
        return this.topicPartition11;
    }

    public TopicPartition topicPartition20() {
        return this.topicPartition20;
    }

    public Seq<TopicPartition> topicPartitions10_11() {
        return this.topicPartitions10_11;
    }

    public KafkaZkClient otherZkClient() {
        return this.otherZkClient;
    }

    public void otherZkClient_$eq(KafkaZkClient x$1) {
        this.otherZkClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.otherZkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
    }

    @Override
    @After
    public void tearDown() {
        if (this.otherZkClient() != null) {
            this.otherZkClient().close();
        }
        super.tearDown();
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Test
    public void testSetAndGetConsumerOffset() {
        long offset = 123L;
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset);
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset + 2L);
        Assert.assertEquals((long)(offset + 2L), (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
    }

    @Test
    public void testGetConsumerOffsetNoData() {
        KafkaZkClient qual$1 = this.zkClient();
        String x$12 = ConsumerOffset$.MODULE$.path(this.group(), this.topicPartition().topic(), Predef$.MODULE$.int2Integer(this.topicPartition().partition()));
        byte[] x$13 = qual$1.createRecursive$default$2();
        boolean x$14 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$12, x$13, x$14);
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
    }

    @Test
    public void testDeleteRecursive() {
        this.zkClient().deleteRecursive("/delete/does-not-exist");
        KafkaZkClient qual$2 = this.zkClient();
        String x$15 = "/delete/some/random/path";
        byte[] x$16 = qual$2.createRecursive$default$2();
        boolean x$17 = qual$2.createRecursive$default$3();
        qual$2.createRecursive(x$15, x$16, x$17);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        this.zkClient().deleteRecursive("/delete");
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some/random"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete/some"));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteRecursive("delete-invalid-path"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    @Test
    public void testCreateRecursive() {
        KafkaZkClient qual$3 = this.zkClient();
        String x$18 = "/create-newrootpath";
        byte[] x$19 = qual$3.createRecursive$default$2();
        boolean x$20 = qual$3.createRecursive$default$3();
        qual$3.createRecursive(x$18, x$19, x$20);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create-newrootpath"));
        KafkaZkClient qual$4 = this.zkClient();
        String x$21 = "/create/some/random/long/path";
        byte[] x$22 = qual$4.createRecursive$default$2();
        boolean x$23 = qual$4.createRecursive$default$3();
        qual$4.createRecursive(x$21, x$22, x$23);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create/some/random/long/path"));
        KafkaZkClient qual$5 = this.zkClient();
        String x$24 = "/create/some/random/long/path";
        boolean x$25 = false;
        byte[] x$26 = qual$5.createRecursive$default$2();
        qual$5.createRecursive(x$24, x$26, x$25);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KafkaZkClient qual$6 = this.zkClient();
            String x$27 = "create-invalid-path";
            byte[] x$28 = qual$6.createRecursive$default$2();
            boolean x$29 = qual$6.createRecursive$default$3();
            qual$6.createRecursive(x$27, x$28, x$29);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    @Test
    public void testTopicAssignmentMethods() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertFalse((boolean)this.zkClient().topicExists(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionCount(this.topic1()).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).isEmpty());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(this.topic1(), assignment);
        Assert.assertTrue((boolean)this.zkClient().topicExists(this.topic1()));
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)assignment.map((Function1 & Serializable & scala.Serializable)topicAssignment -> {
            int partition = ((TopicPartition)topicAssignment._1()).partition();
            Seq assignment = (Seq)topicAssignment._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment);
        }, Map$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)assignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        Assert.assertEquals((Object)expectedAssignment, (Object)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).toSet());
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment.$minus((Object)new TopicPartition(this.topic1(), 2));
        this.zkClient().setTopicAssignment(this.topic1(), updatedAssignment);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        scala.collection.immutable.Map secondAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        this.zkClient().createTopicAssignment(this.topic2(), secondAssignment);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
    }

    @Test
    public void testGetDataAndVersion() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option data0 = (Option)tuple2._1();
        int version0 = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)data0, (Object)BoxesRunTime.boxToInteger((int)version0));
        Tuple2 tuple23 = tuple22;
        Option data02 = (Option)tuple23._1();
        int version02 = tuple23._2$mcI$sp();
        Assert.assertTrue((boolean)data02.isEmpty());
        Assert.assertEquals((long)-1L, (long)version02);
        KafkaZkClient qual$7 = this.zkClient();
        String x$30 = path;
        byte[] x$31 = qual$7.createRecursive$default$2();
        boolean x$32 = qual$7.createRecursive$default$3();
        qual$7.createRecursive(x$30, x$31, x$32);
        KafkaZkClient qual$8 = this.zkClient();
        String x$33 = path;
        byte[] x$34 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$35 = 0;
        Option x$36 = qual$8.conditionalUpdatePath$default$4();
        qual$8.conditionalUpdatePath(x$33, x$34, x$35, x$36);
        Tuple2 tuple24 = this.zkClient().getDataAndVersion(path);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option data1 = (Option)tuple24._1();
        int version1 = tuple24._2$mcI$sp();
        Tuple2 tuple25 = new Tuple2((Object)data1, (Object)BoxesRunTime.boxToInteger((int)version1));
        Tuple2 tuple26 = tuple25;
        Option data12 = (Option)tuple26._1();
        int version12 = tuple26._2$mcI$sp();
        Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)1L, (long)version12);
        KafkaZkClient qual$9 = this.zkClient();
        String x$37 = path;
        byte[] x$38 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$39 = 1;
        Option x$40 = qual$9.conditionalUpdatePath$default$4();
        qual$9.conditionalUpdatePath(x$37, x$38, x$39, x$40);
        Tuple2 tuple27 = this.zkClient().getDataAndVersion(path);
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        Option data2 = (Option)tuple27._1();
        int version2 = tuple27._2$mcI$sp();
        Tuple2 tuple28 = new Tuple2((Object)data2, (Object)BoxesRunTime.boxToInteger((int)version2));
        Tuple2 tuple29 = tuple28;
        Option data22 = (Option)tuple29._1();
        int version22 = tuple29._2$mcI$sp();
        Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)2L, (long)version22);
    }

    @Test
    public void testConditionalUpdatePath() {
        String path = "/testconditionalpath";
        KafkaZkClient qual$10 = this.zkClient();
        String x$41 = path;
        byte[] x$42 = "version0".getBytes(StandardCharsets.UTF_8);
        int x$43 = 0;
        Option x$44 = qual$10.conditionalUpdatePath$default$4();
        Tuple2 statusAndVersion = qual$10.conditionalUpdatePath(x$41, x$42, x$43, x$44);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)-1L, (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$11 = this.zkClient();
        String x$45 = path;
        byte[] x$46 = qual$11.createRecursive$default$2();
        boolean x$47 = qual$11.createRecursive$default$3();
        qual$11.createRecursive(x$45, x$46, x$47);
        KafkaZkClient qual$12 = this.zkClient();
        String x$48 = path;
        byte[] x$49 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$50 = 0;
        Option x$51 = qual$12.conditionalUpdatePath$default$4();
        statusAndVersion = qual$12.conditionalUpdatePath(x$48, x$49, x$50, x$51);
        Assert.assertTrue((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)1L, (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$13 = this.zkClient();
        String x$52 = path;
        byte[] x$53 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$54 = 2;
        Option x$55 = qual$13.conditionalUpdatePath$default$4();
        statusAndVersion = qual$13.conditionalUpdatePath(x$52, x$53, x$54, x$55);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)-1L, (long)statusAndVersion._2$mcI$sp());
    }

    @Test
    public void testCreateSequentialPersistentPath() {
        String path = "/testpath";
        KafkaZkClient qual$14 = this.zkClient();
        String x$56 = path;
        byte[] x$57 = qual$14.createRecursive$default$2();
        boolean x$58 = qual$14.createRecursive$default$3();
        qual$14.createRecursive(x$56, x$57, x$58);
        String result = this.zkClient().createSequentialPersistentPath(path + "/sequence_", null);
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)None$.MODULE$, this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        result = this.zkClient().createSequentialPersistentPath(path + "/sequence_", "some value".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
        Assert.assertEquals((Object)new Some((Object)"some value"), this.dataAsString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sequence_0000000001"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))));
    }

    @Test
    public void testPropagateIsrChanges() {
        KafkaZkClient qual$15 = this.zkClient();
        String x$59 = "/isr_change_notification";
        byte[] x$60 = qual$15.createRecursive$default$2();
        boolean x$61 = qual$15.createRecursive$default$3();
        qual$15.createRecursive(x$59, x$60, x$61);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-a", 0), new TopicPartition("topic-b", 0)})));
        String expectedPath = "/isr_change_notification/isr_change_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-a\",\"partition\":0},{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-b", 0)})));
        expectedPath = "/isr_change_notification/isr_change_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testIsrChangeNotificationGetters() {
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$16 = this.zkClient();
        String x$62 = "/isr_change_notification";
        byte[] x$63 = qual$16.createRecursive$default$2();
        boolean x$64 = qual$16.createRecursive$default$3();
        qual$16.createRecursive(x$62, x$63, x$64);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11(), this.topicPartition10()})), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"}))));
    }

    @Test
    public void testIsrChangeNotificationsDeletion() {
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"})));
        KafkaZkClient qual$17 = this.zkClient();
        String x$65 = "/isr_change_notification";
        byte[] x$66 = qual$17.createRecursive$default$2();
        boolean x$67 = qual$17.createRecursive$default$3();
        qual$17.createRecursive(x$65, x$66, x$67);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()})));
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})));
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
    }

    @Test
    public void testPropagateLogDir() {
        KafkaZkClient qual$18 = this.zkClient();
        String x$68 = "/log_dir_event_notification";
        byte[] x$69 = qual$18.createRecursive$default$2();
        boolean x$70 = qual$18.createRecursive$default$3();
        qual$18.createRecursive(x$68, x$69, x$70);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        String expectedPath = "/log_dir_event_notification/log_dir_event_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        this.zkClient().propagateLogDirEvent(brokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000002";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":4,\"event\":1}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testLogDirGetters() {
        Assert.assertEquals((String)"getAllLogDirEventNotifications failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
        Assert.assertEquals((String)"getBrokerIdsFromLogDirEvents failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$19 = this.zkClient();
        String x$71 = "/log_dir_event_notification";
        byte[] x$72 = qual$19.createRecursive$default$2();
        boolean x$73 = qual$19.createRecursive$default$3();
        qual$19.createRecursive(x$71, x$72, x$73);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        this.zkClient().propagateLogDirEvent(brokerId);
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        Seq notifications012 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"}));
        Assert.assertEquals((Object)notifications012.toSet(), (Object)this.zkClient().getAllLogDirEventNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3, 4})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents(notifications012));
    }

    @Test
    public void testLogDirEventNotificationsDeletion() {
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})));
        KafkaZkClient qual$20 = this.zkClient();
        String x$74 = "/log_dir_event_notification";
        byte[] x$75 = qual$20.createRecursive$default$2();
        boolean x$76 = qual$20.createRecursive$default$3();
        qual$20.createRecursive(x$74, x$75, x$76);
        int brokerId = 3;
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
    }

    @Test
    public void testSetGetAndDeletePartitionReassignment() {
        KafkaZkClient qual$21 = this.zkClient();
        String x$77 = AdminZNode$.MODULE$.path();
        byte[] x$78 = qual$21.createRecursive$default$2();
        boolean x$79 = qual$21.createRecursive$default$3();
        qual$21.createRecursive(x$77, x$78, x$79);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_b", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_c", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3})))}));
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map updatedReassingment = (scala.collection.immutable.Map)reassignment.$minus((Object)new TopicPartition("topic_b", 0));
        this.zkClient().setOrCreatePartitionReassignment((Map)updatedReassingment);
        Assert.assertEquals((Object)updatedReassingment, (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().deletePartitionReassignment();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().createPartitionReassignment(reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
    }

    @Test
    public void testGetDataAndStat() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option data0 = (Option)tuple2._1();
        Stat version0 = (Stat)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)data0, (Object)version0);
        Tuple2 tuple23 = tuple22;
        Option data02 = (Option)tuple23._1();
        Stat version02 = (Stat)tuple23._2();
        Assert.assertTrue((boolean)data02.isEmpty());
        Assert.assertEquals((long)0L, (long)version02.getVersion());
        KafkaZkClient qual$22 = this.zkClient();
        String x$80 = path;
        byte[] x$81 = qual$22.createRecursive$default$2();
        boolean x$82 = qual$22.createRecursive$default$3();
        qual$22.createRecursive(x$80, x$81, x$82);
        KafkaZkClient qual$23 = this.zkClient();
        String x$83 = path;
        byte[] x$84 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$85 = 0;
        Option x$86 = qual$23.conditionalUpdatePath$default$4();
        qual$23.conditionalUpdatePath(x$83, x$84, x$85, x$86);
        Tuple2 tuple24 = this.zkClient().getDataAndStat(path);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option data1 = (Option)tuple24._1();
        Stat version1 = (Stat)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)data1, (Object)version1);
        Tuple2 tuple26 = tuple25;
        Option data12 = (Option)tuple26._1();
        Stat version12 = (Stat)tuple26._2();
        Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)1L, (long)version12.getVersion());
        KafkaZkClient qual$24 = this.zkClient();
        String x$87 = path;
        byte[] x$88 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$89 = 1;
        Option x$90 = qual$24.conditionalUpdatePath$default$4();
        qual$24.conditionalUpdatePath(x$87, x$88, x$89, x$90);
        Tuple2 tuple27 = this.zkClient().getDataAndStat(path);
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        Option data2 = (Option)tuple27._1();
        Stat version2 = (Stat)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)data2, (Object)version2);
        Tuple2 tuple29 = tuple28;
        Option data22 = (Option)tuple29._1();
        Stat version22 = (Stat)tuple29._2();
        Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)2L, (long)version22.getVersion());
    }

    @Test
    public void testGetChildren() {
        String path = "/testpath";
        Assert.assertTrue((boolean)this.zkClient().getChildren(path).isEmpty());
        KafkaZkClient qual$25 = this.zkClient();
        String x$91 = "/testpath/child1";
        byte[] x$92 = qual$25.createRecursive$default$2();
        boolean x$93 = qual$25.createRecursive$default$3();
        qual$25.createRecursive(x$91, x$92, x$93);
        KafkaZkClient qual$26 = this.zkClient();
        String x$94 = "/testpath/child2";
        byte[] x$95 = qual$26.createRecursive$default$2();
        boolean x$96 = qual$26.createRecursive$default$3();
        qual$26.createRecursive(x$94, x$95, x$96);
        KafkaZkClient qual$27 = this.zkClient();
        String x$97 = "/testpath/child3";
        byte[] x$98 = qual$27.createRecursive$default$2();
        boolean x$99 = qual$27.createRecursive$default$3();
        qual$27.createRecursive(x$97, x$98, x$99);
        Seq children = this.zkClient().getChildren(path);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"child1", "child2", "child3"})), (Object)children.toSet());
    }

    @Test
    public void testAclManagementMethods() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(AclZNode$.MODULE$.path()));
        Assert.assertFalse((boolean)this.zkClient().pathExists(AclChangeNotificationZNode$.MODULE$.path()));
        ResourceType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)resource -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$1(this, resource);
            return BoxedUnit.UNIT;
        });
        this.zkClient().createAclPaths();
        Assert.assertTrue((boolean)this.zkClient().pathExists(AclZNode$.MODULE$.path()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(AclChangeNotificationZNode$.MODULE$.path()));
        ResourceType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)resource -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$2(this, resource);
            return BoxedUnit.UNIT;
        });
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString());
        Resource resource2 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString());
        SimpleAclAuthorizer.VersionedAcls versionedAcls = this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertTrue((boolean)versionedAcls.acls().isEmpty());
        Assert.assertEquals((long)-1L, (long)versionedAcls.zkVersion());
        Assert.assertFalse((boolean)this.zkClient().resourceExists(resource1));
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        this.zkClient().conditionalSetOrCreateAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})), 0);
        this.zkClient().conditionalSetOrCreateAclsForResource(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0);
        versionedAcls = this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})), (Object)versionedAcls.acls());
        Assert.assertEquals((long)0L, (long)versionedAcls.zkVersion());
        Assert.assertTrue((boolean)this.zkClient().resourceExists(resource1));
        this.zkClient().conditionalSetOrCreateAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0);
        versionedAcls = this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), (Object)versionedAcls.acls());
        Assert.assertEquals((long)1L, (long)versionedAcls.zkVersion());
        scala.collection.immutable.Set set = ((TraversableOnce)ResourceType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)rt -> rt.name(), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set set2 = this.zkClient().getResourceTypes().toSet();
        Assert.assertTrue((!(set != null ? !set.equals(set2) : set2 != null) ? 1 : 0) != 0);
        Seq resourceNames = this.zkClient().getResourceNames(Topic$.MODULE$.name());
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resource1.name(), resource2.name()}));
        scala.collection.immutable.Set set3 = resourceNames.toSet();
        Assert.assertTrue((!(genTraversable != null ? !genTraversable.equals(set3) : set3 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.zkClient().deleteResource(resource1));
        Assert.assertFalse((boolean)this.zkClient().resourceExists(resource1));
        Assert.assertFalse((boolean)this.zkClient().conditionalDelete(resource2, 10));
        Assert.assertTrue((boolean)this.zkClient().conditionalDelete(resource2, 0));
        this.zkClient().createAclChangeNotification("resource1");
        this.zkClient().createAclChangeNotification("resource2");
        Assert.assertEquals((long)2L, (long)this.zkClient().getChildren(AclChangeNotificationZNode$.MODULE$.path()).size());
        this.zkClient().deleteAclChangeNotifications();
        Assert.assertTrue((boolean)this.zkClient().getChildren(AclChangeNotificationZNode$.MODULE$.path()).isEmpty());
    }

    @Test
    public void testDeletePath() {
        String path = "/a/b/c";
        KafkaZkClient qual$28 = this.zkClient();
        String x$100 = path;
        byte[] x$101 = qual$28.createRecursive$default$2();
        boolean x$102 = qual$28.createRecursive$default$3();
        qual$28.createRecursive(x$100, x$101, x$102);
        this.zkClient().deletePath(path);
        Assert.assertFalse((boolean)this.zkClient().pathExists(path));
    }

    @Test
    public void testDeleteTopicZNode() {
        this.zkClient().deleteTopicZNode(this.topic1());
        KafkaZkClient qual$29 = this.zkClient();
        String x$103 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$104 = qual$29.createRecursive$default$2();
        boolean x$105 = qual$29.createRecursive$default$3();
        qual$29.createRecursive(x$103, x$104, x$105);
        this.zkClient().deleteTopicZNode(this.topic1());
        Assert.assertFalse((boolean)this.zkClient().pathExists(TopicZNode$.MODULE$.path(this.topic1())));
    }

    @Test
    public void testDeleteTopicPathMethods() {
        Assert.assertFalse((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
        this.zkClient().createDeleteTopicPath(this.topic1());
        this.zkClient().createDeleteTopicPath(this.topic2());
        Assert.assertTrue((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
    }

    private void assertPathExistenceAndData(String expectedPath, String data) {
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)data), this.dataAsString(expectedPath));
    }

    @Test
    public void testCreateTokenChangeNotification() {
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createTokenChangeNotification("delegationToken"), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().createTokenChangeNotification("delegationToken");
        this.assertPathExistenceAndData("/delegation_token/token_changes/token_change_0000000000", "delegationToken");
    }

    @Test
    public void testEntityConfigManagementMethods() {
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.logProps().remove(LogConfig$.MODULE$.CleanupPolicyProp());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), this.logProps());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).toSet());
        this.zkClient().deleteTopicConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})));
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
    }

    @Test
    public void testCreateConfigChangeNotification() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000000", "{\"version\":2,\"entity_path\":\"/config/topics/topic1\"}");
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic2()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000001", "{\"version\":2,\"entity_path\":\"/config/topics/topic2\"}");
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProps(int bytesProp) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        return var2_2;
    }

    private Properties logProps() {
        return this.logProps;
    }

    @Test
    public void testGetLogConfigs() {
        LogConfig emptyConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((String)"Non existent config, no defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), Collections.emptyMap()));
        Properties logProps2 = this.createLogProps(2048);
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((String)"One existing and one non-existent topic", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), logProps2);
        Assert.assertEquals((String)"Two existing topics", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)new LogConfig((java.util.Map)logProps2, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        Properties logProps1WithMoreValues = this.createLogProps(1024);
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentJitterMsProp(), "100");
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentBytesProp(), "1024");
        Assert.assertEquals((String)"Config with defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)logProps1WithMoreValues, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"128")}))).asJava()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    @Test
    public void testRegisterBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo differentBrokerInfoWithSameId = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBrokerInZk(brokerInfo);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        Assert.assertEquals((String)"Other ZK clients can read broker info", (Object)new Some((Object)brokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
        this.zkClient().registerBrokerInZk(differentBrokerInfoWithSameId);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.otherZkClient().registerBrokerInZk(differentBrokerInfoWithSameId), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
    }

    @Test
    public void testGetBrokerMethods() {
        this.zkClient().createTopLevelPaths();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getBroker(0));
        BrokerInfo brokerInfo0 = this.createBrokerInfo(0, "test.host0", 9998, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo brokerInfo1 = this.createBrokerInfo(1, "test.host1", 9999, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBrokerInZk(brokerInfo1);
        this.otherZkClient().registerBrokerInZk(brokerInfo0);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{brokerInfo0.broker(), brokerInfo1.broker()})), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)new Some((Object)brokerInfo0.broker()), (Object)this.zkClient().getBroker(0));
    }

    @Test
    public void testUpdateBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo originalBrokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().updateBrokerInfoInZk(originalBrokerInfo), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
        this.zkClient().registerBrokerInZk(originalBrokerInfo);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().updateBrokerInfoInZk(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.otherZkClient().updateBrokerInfoInZk(originalBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)originalBrokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
    }

    /*
     * WARNING - void declaration
     */
    private Stat statWithVersion(int version) {
        void var2_2;
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        stat.setVersion(version);
        return var2_2;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs(int state, int zkVersion) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, state, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2 + state, 3 + state})), zkVersion), 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, state + 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1 + state, 2 + state})), zkVersion), 4))}));
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs() {
        return this.initialLeaderIsrAndControllerEpochs;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs() {
        return this.initialLeaderIsrs;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> leaderIsrs(int state, int zkVersion) {
        return this.leaderIsrAndControllerEpochs(state, zkVersion).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> x$8.leaderAndIsr());
    }

    private void checkUpdateLeaderAndIsrResult(scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> expectedSuccessfulPartitions, Seq<TopicPartition> expectedPartitionsToRetry, scala.collection.immutable.Map<TopicPartition, Tuple2<Class<?>, String>> expectedFailedPartitions, KafkaZkClient.UpdateLeaderAndIsrResult actualUpdateLeaderAndIsrResult) {
        scala.collection.immutable.Map failedPartitionsExcerpt = actualUpdateLeaderAndIsrResult.failedPartitions().mapValues((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e.getClass(), (Object)e.getMessage()));
        Assert.assertEquals((String)"Permanently failed updates do not match expected", expectedFailedPartitions, (Object)failedPartitionsExcerpt);
        Assert.assertEquals((String)"Retriable updates (due to BADVERSION) do not match expected", expectedPartitionsToRetry, (Object)actualUpdateLeaderAndIsrResult.partitionsToRetry());
        Assert.assertEquals((String)"Successful updates do not match expected", expectedSuccessfulPartitions, (Object)actualUpdateLeaderAndIsrResult.successfulPartitions());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        KafkaZkClient qual$30 = this.zkClient();
        String x$106 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$107 = qual$30.createRecursive$default$2();
        boolean x$108 = qual$30.createRecursive$default$3();
        qual$30.createRecursive(x$106, x$107, x$108);
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/0/state")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/1/state"))})), this.zkClient().updateLeaderAndIsr(this.initialLeaderIsrs(), 4));
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        this.checkUpdateLeaderAndIsrResult(this.leaderIsrs(1, 1), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4));
        scala.collection.immutable.Map mixedState = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderAndIsr(1, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0))}));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)this.leaderIsrs(2, 2).filterKeys((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaZkClientTest.$anonfun$testUpdateLeaderAndIsr$1(this, x$9))), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()}))), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic2/partitions/0/state"))})), this.zkClient().updateLeaderAndIsr(mixedState, 4));
    }

    private void checkGetDataResponse(scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs, TopicPartition topicPartition, GetDataResponse response) {
        int zkVersion = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)topicPartition)).leaderAndIsr().zkVersion();
        Assert.assertEquals((Object)KeeperException.Code.OK, (Object)response.resultCode());
        Assert.assertEquals((Object)TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Object)response.path());
        Assert.assertEquals((Object)new Some((Object)topicPartition), (Object)response.ctx());
        Assert.assertEquals((Object)new Some(leaderIsrAndControllerEpochs.apply((Object)topicPartition)), (Object)TopicPartitionStateZNode$.MODULE$.decode(response.data(), this.statWithVersion(zkVersion)));
    }

    private CreateResponse eraseMetadata(CreateResponse response) {
        ResponseMetadata x$109 = new ResponseMetadata(0L, 0L);
        KeeperException.Code x$110 = response.copy$default$1();
        String x$111 = response.copy$default$2();
        Option x$112 = response.copy$default$3();
        String x$113 = response.copy$default$4();
        return response.copy(x$110, x$111, x$112, x$113, x$109);
    }

    @Test
    public void testGetTopicsAndPartitions() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        KafkaZkClient qual$31 = this.zkClient();
        String x$114 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$115 = qual$31.createRecursive$default$2();
        boolean x$116 = qual$31.createRecursive$default$3();
        qual$31.createRecursive(x$114, x$115, x$116);
        KafkaZkClient qual$32 = this.zkClient();
        String x$117 = TopicZNode$.MODULE$.path(this.topic2());
        byte[] x$118 = qual$32.createRecursive$default$2();
        boolean x$119 = qual$32.createRecursive$default$3();
        qual$32.createRecursive(x$117, x$118, x$119);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})), (Object)this.zkClient().getAllPartitions());
    }

    @Test
    public void testCreateAndGetTopicPartitionStatesRaw() {
        KafkaZkClient qual$33 = this.zkClient();
        String x$120 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$121 = qual$33.createRecursive$default$2();
        boolean x$122 = qual$33.createRecursive$default$3();
        qual$33.createRecursive(x$120, x$121, x$122);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), new ResponseMetadata(0L, 0L)), new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), new ResponseMetadata(0L, 0L))})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseMetadata((CreateResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaZkClientTest.$anonfun$testCreateAndGetTopicPartitionStatesRaw$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), null, new ResponseMetadata(0L, 0L)), new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), null, new ResponseMetadata(0L, 0L))})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseMetadata((CreateResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSetTopicPartitionStatesRaw() {
        KafkaZkClient qual$34 = this.zkClient();
        String x$123 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$124 = qual$34.createRecursive$default$2();
        boolean x$125 = qual$34.createRecursive$default$3();
        qual$34.createRecursive(x$123, x$124, x$125);
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.NONODE, null), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs()).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            ResponseMetadata x$126 = new ResponseMetadata(0L, 0L);
            KeeperException.Code x$127 = x$10.copy$default$1();
            String x$128 = x$10.copy$default$2();
            Option x$129 = x$10.copy$default$3();
            Stat x$130 = x$10.copy$default$4();
            return x$10.copy(x$127, x$128, x$129, x$130, x$126);
        }, Seq$.MODULE$.canBuildFrom())).toList());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(1)), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.leaderIsrAndControllerEpochs(1, 0)).map((Function1 & Serializable & scala.Serializable)response -> this.eraseMetadataAndStat((SetDataResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KafkaZkClientTest.$anonfun$testSetTopicPartitionStatesRaw$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(2)), (Object)((TraversableOnce)this.otherZkClient().setTopicPartitionStatesRaw(this.leaderIsrAndControllerEpochs(2, 1)).map((Function1 & Serializable & scala.Serializable)response -> this.eraseMetadataAndStat((SetDataResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testReassignPartitionsInProgress() {
        Assert.assertFalse((boolean)this.zkClient().reassignPartitionsInProgress());
        KafkaZkClient qual$35 = this.zkClient();
        String x$131 = ReassignPartitionsZNode$.MODULE$.path();
        byte[] x$132 = qual$35.createRecursive$default$2();
        boolean x$133 = qual$35.createRecursive$default$3();
        qual$35.createRecursive(x$131, x$132, x$133);
        Assert.assertTrue((boolean)this.zkClient().reassignPartitionsInProgress());
    }

    @Test
    public void testGetTopicPartitionStates() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        KafkaZkClient qual$36 = this.zkClient();
        String x$134 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$135 = qual$36.createRecursive$default$2();
        boolean x$136 = qual$36.createRecursive$default$3();
        qual$36.createRecursive(x$134, x$135, x$136);
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs());
        Assert.assertEquals(this.initialLeaderIsrAndControllerEpochs(), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))));
        Assert.assertEquals((Object)new Some(this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10())), (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        TopicPartition notExistingPartition = new TopicPartition(this.topic1(), 2);
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{notExistingPartition}))).isEmpty());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10()))})), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), notExistingPartition}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(notExistingPartition));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(notExistingPartition));
    }

    private SetDataResponse eraseMetadataAndStat(SetDataResponse response) {
        Stat stat = response.stat() != null ? this.statWithVersion(response.stat().getVersion()) : null;
        ResponseMetadata x$137 = new ResponseMetadata(0L, 0L);
        Stat x$138 = stat;
        KeeperException.Code x$139 = response.copy$default$1();
        String x$140 = response.copy$default$2();
        Option x$141 = response.copy$default$3();
        return response.copy(x$139, x$140, x$141, x$138, x$137);
    }

    @Test
    public void testControllerEpochMethods() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerEpoch());
        Assert.assertEquals((String)"Setting non existing nodes should return NONODE results", (Object)new SetDataResponse(KeeperException.Code.NONODE, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((String)"Creating non existing nodes is OK", (Object)new CreateResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, ControllerEpochZNode$.MODULE$.path(), new ResponseMetadata(0L, 0L)), (Object)this.eraseMetadata(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((long)0L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Attemt to create existing nodes should return NODEEXISTS", (Object)new CreateResponse(KeeperException.Code.NODEEXISTS, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.eraseMetadata(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((String)"Updating existing nodes is OK", (Object)new SetDataResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, this.statWithVersion(1), new ResponseMetadata(0L, 0L)), (Object)this.eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((long)1L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Updating with wrong ZK version returns BADVERSION", (Object)new SetDataResponse(KeeperException.Code.BADVERSION, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L)), (Object)this.eraseMetadataAndStat(this.zkClient().setControllerEpochRaw(1, 0)));
    }

    @Test
    public void testControllerManagementMethods() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
        this.zkClient().checkedEphemeralCreate(ControllerZNode$.MODULE$.path(), ControllerZNode$.MODULE$.encode(1, 123456L));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getControllerId());
        this.zkClient().deleteController();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        String mockPath = "/foo";
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(null, mockPath, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = mockPath$1;
            }
        };
        this.zkClient().registerZNodeChangeHandlerAndCheckExistence(zNodeChangeHandler);
        KafkaZkClient qual$37 = this.zkClient();
        String x$142 = mockPath;
        byte[] x$143 = qual$37.createRecursive$default$2();
        boolean x$144 = qual$37.createRecursive$default$3();
        qual$37.createRecursive(x$142, x$143, x$144);
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testClusterIdMethods() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assert.assertEquals((Object)clusterId, (Object)this.zkClient().getClusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("No cluster id found", new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967))));
    }

    @Test
    public void testBrokerSequenceIdMethods() {
        int sequenceId = this.zkClient().generateBrokerSequenceId();
        Assert.assertEquals((long)(sequenceId + 1), (long)this.zkClient().generateBrokerSequenceId());
    }

    @Test
    public void testCreateTopLevelPaths() {
        this.zkClient().createTopLevelPaths();
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1 & Serializable & scala.Serializable)path -> {
            KafkaZkClientTest.$anonfun$testCreateTopLevelPaths$1(this, path);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPreferredReplicaElectionMethods() {
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
        scala.collection.immutable.Set electionPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0), new TopicPartition(this.topic1(), 1)}));
        this.zkClient().createPreferredReplicaElection(electionPartitions);
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPreferredReplicaElection(electionPartitions), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
        this.zkClient().deletePreferredReplicaElection();
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
    }

    private Option<String> dataAsString(String path) {
        Option data;
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = data = (Option)tuple2._1();
        Option data2 = option;
        return data2.map((Function1 & Serializable & scala.Serializable)x$11 -> new String((byte[])x$11, StandardCharsets.UTF_8));
    }

    @Test
    public void testDelegationTokenMethods() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createDelegationTokenPaths();
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        String tokenId = "token1";
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        List renewers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)renewers).asJava(), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        byte[] bytes = new byte[20];
        Random$.MODULE$.nextBytes(bytes);
        DelegationToken token = new DelegationToken(tokenInfo, bytes);
        Assert.assertTrue((boolean)this.zkClient().getDelegationTokenInfo(tokenId).isEmpty());
        Assert.assertFalse((boolean)this.zkClient().deleteDelegationToken(tokenId));
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        tokenInfo.setExpiryTimestamp(System.currentTimeMillis());
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        Assert.assertTrue((boolean)this.zkClient().deleteDelegationToken(tokenId));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getDelegationTokenInfo(tokenId));
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$1(KafkaZkClientTest $this, ResourceType resource) {
        Assert.assertFalse((boolean)$this.zkClient().pathExists(ResourceTypeZNode$.MODULE$.path(resource.name())));
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$2(KafkaZkClientTest $this, ResourceType resource) {
        Assert.assertTrue((boolean)$this.zkClient().pathExists(ResourceTypeZNode$.MODULE$.path(resource.name())));
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateLeaderAndIsr$1(KafkaZkClientTest $this, TopicPartition x$9) {
        TopicPartition topicPartition = x$9;
        TopicPartition topicPartition2 = $this.topicPartition10();
        return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreateAndGetTopicPartitionStatesRaw$2(KafkaZkClientTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        GetDataResponse r = (GetDataResponse)tuple2._2();
        $this.checkGetDataResponse($this.initialLeaderIsrAndControllerEpochs(), tp, r);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq expectedSetDataResponses$1(Seq topicPartitions, KeeperException.Code resultCode, Stat stat) {
        return (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)topicPartition -> new SetDataResponse(resultCode, TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Option)new Some(topicPartition), stat, new ResponseMetadata(0L, 0L)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testSetTopicPartitionStatesRaw$4(KafkaZkClientTest $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        GetDataResponse r = (GetDataResponse)tuple2._2();
        $this.checkGetDataResponse($this.leaderIsrAndControllerEpochs(1, 0), tp, r);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testCreateTopLevelPaths$1(KafkaZkClientTest $this, String path) {
        Assert.assertTrue((boolean)$this.zkClient().pathExists(path));
    }

    public KafkaZkClientTest() {
        this.group = "my-group";
        this.topic1 = "topic1";
        this.topic2 = "topic2";
    }
}

