/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class FileXML {
    protected Document doc = null;
    protected DocumentBuilder docBuilder = null;
    protected DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    public FileXML(String string) {
        String string2 = "<" + string + "></" + string + ">";
        try {
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
            this.doc = this.docBuilder.parse(new InputSource(new StringReader(string2)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    protected Element getElement(Element element, String string) {
        Element[] elementArray = this.getElements(element, string);
        if (elementArray == null) {
            return null;
        }
        return elementArray[0];
    }

    protected Element getElement(String string) {
        Element element = this.doc.getDocumentElement();
        return this.getElement(element, string);
    }

    protected Element getElement(String[] stringArray) {
        Element[] elementArray = this.getElements(stringArray);
        if (elementArray == null) {
            return null;
        }
        return elementArray[0];
    }

    protected Element[] getElements(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elementArray[i] = (Element)nodeList.item(i);
        }
        return elementArray;
    }

    protected Element[] getElements(String string) {
        Element element = this.doc.getDocumentElement();
        return this.getElements(element, string);
    }

    protected Element[] getElements(String[] stringArray) {
        NodeList nodeList = null;
        Element element = this.doc.getDocumentElement();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            nodeList = element.getElementsByTagName(stringArray[i]);
            if (nodeList.getLength() <= 0) {
                return null;
            }
            element = (Element)nodeList.item(i);
        }
        nodeList = element.getElementsByTagName(stringArray[stringArray.length - 1]);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elementArray[i] = (Element)nodeList.item(0);
        }
        return elementArray;
    }

    private String getText(Element element) {
        try {
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 3) continue;
                return node.getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected String getValue(Element element, String string) {
        Element element2 = null;
        String string2 = "";
        try {
            element2 = this.getElement(element, string);
            string2 = this.getText(element2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    protected String getValue(String string) {
        Element element = this.doc.getDocumentElement();
        return this.getValue(element, string);
    }

    protected List getValues(String string) {
        NodeList nodeList = this.doc.getElementsByTagName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            arrayList.add(this.getText(element));
        }
        return arrayList;
    }

    protected abstract void parse() throws Exception;

    public void readAndParseFile(String string) throws SAXException, IOException, Exception {
        this.readFile(string);
        this.parse();
    }

    protected void readFile(String string) throws SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        this.doc = documentBuilder.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveFile(String string) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        file = new File(string);
        fileOutputStream = new FileOutputStream(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(this.doc);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.transform(dOMSource, streamResult);
        Object var9_17 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (TransformerConfigurationException transformerConfigurationException) {
                void var5_11;
                System.out.println("\n** Transformer Factory error");
                System.out.println("   " + transformerConfigurationException.getMessage());
                TransformerConfigurationException transformerConfigurationException2 = transformerConfigurationException;
                if (transformerConfigurationException.getException() != null) {
                    Throwable throwable = transformerConfigurationException.getException();
                }
                var5_11.printStackTrace();
                Object var9_18 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (TransformerException transformerException) {
                void var5_14;
                System.out.println("\n** Transformation error");
                System.out.println("   " + transformerException.getMessage());
                TransformerException transformerException2 = transformerException;
                if (transformerException.getException() != null) {
                    Throwable throwable = transformerException.getException();
                }
                var5_14.printStackTrace();
                Object var9_19 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var9_20 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_21 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public void setDocument(Document document) throws Exception {
        this.doc = document;
        this.parse();
    }

    protected void setValue(String string, String string2) {
        Element element = null;
        try {
            element = this.getElement(string);
            if (element == null) {
                element = this.doc.createElement(string);
                this.doc.getDocumentElement().appendChild(element);
            }
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getNodeType() != 3) continue;
                node.setNodeValue(string2);
                return;
            }
            Text text = this.doc.createTextNode(string2);
            element.appendChild(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setValue(String[] stringArray, String string) {
        int n;
        Element element = this.doc.getDocumentElement();
        NodeList nodeList = null;
        Element element2 = null;
        Text text = null;
        for (n = 0; n < stringArray.length; ++n) {
            nodeList = this.doc.getElementsByTagName(stringArray[n]);
            if (nodeList.getLength() == 0) {
                element2 = this.doc.createElement(stringArray[n]);
                element.appendChild(element2);
                element = element2;
                continue;
            }
            element = (Element)nodeList.item(0);
        }
        try {
            for (n = 0; n < element.getChildNodes().getLength(); ++n) {
                Node node = element.getChildNodes().item(n);
                if (node.getNodeType() != 3) continue;
                node.setNodeValue(string);
                return;
            }
            text = this.doc.createTextNode(string);
            element.appendChild(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void removeElement(Element element, String string) {
        Element[] elementArray = this.getElements(element, string);
        if (elementArray == null) {
            return;
        }
        for (int i = 0; i < elementArray.length; ++i) {
            try {
                element.removeChild(elementArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void removeElement(String string) {
        Element element = this.doc.getDocumentElement();
        this.removeElement(element, string);
    }

    protected Element addElement(Element element, String string, String string2) {
        Element element2 = this.doc.createElement(string);
        element.appendChild(element2);
        for (int i = 0; i < element2.getChildNodes().getLength(); ++i) {
            Node node = element2.getChildNodes().item(i);
            if (node.getNodeType() != 3) continue;
            node.setNodeValue(string2);
            return element2;
        }
        Text text = this.doc.createTextNode(string2);
        element2.appendChild(text);
        return element2;
    }

    protected Element addElement(Element element, String string) {
        Element element2 = this.doc.createElement(string);
        element.appendChild(element2);
        return element2;
    }

    protected Element addElement(String string) {
        Element element = this.doc.createElement(string);
        this.doc.getDocumentElement().appendChild(element);
        return element;
    }
}

