/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.plugins.markdown.ui.preview.InlineLinkGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.LinkGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.ReferenceLinksGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J,\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/IntelliJImageGeneratingProvider;", "Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;Lcom/intellij/openapi/project/Project;)V", "inlineLinkProvider", "Lorg/intellij/plugins/markdown/ui/preview/InlineLinkGeneratingProvider;", "referenceLinkProvider", "Lorg/intellij/plugins/markdown/ui/preview/ReferenceLinksGeneratingProvider;", "getRenderInfo", "Lorg/intellij/plugins/markdown/ui/preview/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "makeAbsoluteUrl", "", "destination", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "Companion", "intellij.markdown"})
public final class IntelliJImageGeneratingProvider
extends LinkGeneratingProvider {
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    private final Project project;
    private static final Regex REGEX;
    public static final Companion Companion;

    @Override
    @NotNull
    protected CharSequence makeAbsoluteUrl(@NotNull CharSequence destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        String string = SystemInfo.isWindows ? StringUtil.replace((String)((Object)destination).toString(), (String)"%5C", (String)"/") : ((Object)destination).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (SystemInfo.isWindows\u2026se destination.toString()");
        String destinationEx = string;
        if (StringsKt.startsWith$default((CharSequence)destinationEx, (char)'#', (boolean)false, (int)2, null)) {
            return destinationEx;
        }
        return super.makeAbsoluteUrl(destinationEx);
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text, @NotNull ASTNode node) {
        LinkGeneratingProvider.RenderInfo renderInfo;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        ASTNode aSTNode = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.INLINE_LINK);
        if (aSTNode != null) {
            ASTNode aSTNode2;
            ASTNode it = aSTNode2 = aSTNode;
            return this.inlineLinkProvider.getRenderInfo(text, it);
        }
        ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.FULL_REFERENCE_LINK);
        if (aSTNode3 == null) {
            aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.SHORT_REFERENCE_LINK);
        }
        if (aSTNode3 != null) {
            ASTNode aSTNode4;
            ASTNode it = aSTNode4 = aSTNode3;
            renderInfo = this.referenceLinkProvider.getRenderInfo(text, it);
        } else {
            renderInfo = null;
        }
        return renderInfo;
    }

    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        CharSequence[] charSequenceArray;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        boolean bl = true;
        CharSequence[] charSequenceArray2 = new CharSequence[3];
        charSequenceArray2[0] = "src=\"" + this.makeAbsoluteUrl(info.getDestination()) + '\"';
        charSequenceArray2[1] = "alt=\"" + IntelliJImageGeneratingProvider.Companion.getPlainTextFrom(info.getLabel(), text) + '\"';
        CharSequence[] charSequenceArray3 = charSequenceArray2;
        CharSequence[] charSequenceArray4 = charSequenceArray2;
        int n = 2;
        CharSequence[] charSequenceArray5 = info.getTitle();
        if (charSequenceArray5 != null) {
            charSequenceArray = charSequenceArray5;
            int n2 = n;
            CharSequence[] charSequenceArray6 = charSequenceArray3;
            CharSequence[] charSequenceArray7 = charSequenceArray4;
            boolean bl2 = bl;
            CharSequence charSequence2 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            CharSequence[] it = charSequenceArray;
            String string2 = "title=\"" + (CharSequence)it + '\"';
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence2;
            bl = bl2;
            charSequenceArray4 = charSequenceArray7;
            charSequenceArray3 = charSequenceArray6;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray3[n] = string;
        charSequenceArray = charSequenceArray4;
        boolean bl3 = bl;
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl3);
    }

    public IntelliJImageGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(baseURI);
        this.project = project;
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap, baseURI);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider(baseURI);
    }

    static {
        Companion = new Companion(null);
        REGEX = new Regex("[^a-zA-Z0-9 ]");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/IntelliJImageGeneratingProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getPlainTextFrom", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "intellij.markdown"})
    public static final class Companion {
        private final CharSequence getPlainTextFrom(ASTNode node, String text) {
            return REGEX.replace(ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text), "");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

