/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Query;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.xslt.XsltSupport;

public final class XsltImplicitUsagesProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (!(element instanceof XmlAttribute)) {
            return false;
        }
        XmlAttribute attr = (XmlAttribute)element;
        if (!attr.isNamespaceDeclaration()) {
            return false;
        }
        PsiFile file = attr.getContainingFile();
        if (!(file instanceof XmlFile)) {
            return false;
        }
        if (!ContextProvider.hasXPathInjections((XmlFile)file) && !XsltSupport.isXsltFile(file)) {
            return false;
        }
        String prefix = attr.getLocalName();
        SchemaPrefix target = new SchemaPrefix(attr, TextRange.from((int)"xmlns:".length(), (int)prefix.length()), prefix);
        Query q = ReferencesSearch.search((PsiElement)target, (SearchScope)new LocalSearchScope((PsiElement)attr.getParent()));
        return !q.forEach(psiReference -> psiReference.getElement() == attr);
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

