/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntfilePsiStructure {
    private static final Key<CachedValue<GruntfilePsiStructure>> KEY = Key.create((String)GruntfilePsiStructure.class.getName());
    private final Map<String, JSProperty> myConfigByKeyMap;
    private final Map<String, JSCallExpression> myTaskBodyByNameMap;

    public GruntfilePsiStructure(@NotNull Map<String, JSProperty> configurationByKeyMap, @NotNull Map<String, JSCallExpression> taskBodyByNameMap) {
        if (configurationByKeyMap == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(0);
        }
        if (taskBodyByNameMap == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(1);
        }
        this.myConfigByKeyMap = ImmutableMap.copyOf(configurationByKeyMap);
        this.myTaskBodyByNameMap = ImmutableMap.copyOf(taskBodyByNameMap);
    }

    @Nullable
    public PsiElement getPsiElementToNavigateTo(@NotNull String taskName, @Nullable String targetName) {
        if (taskName == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(2);
        }
        if (targetName != null) {
            JSProperty config2 = this.myConfigByKeyMap.get(taskName);
            if (config2 != null) {
                JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)config2.getValue(), JSObjectLiteralExpression.class);
                return JSPsiUtil.findPropertyByName(objectLiteral, targetName);
            }
            return null;
        }
        JSCallExpression callExpression = this.myTaskBodyByNameMap.get(taskName);
        if (callExpression != null) {
            JSLiteralExpression nameExpr = JSPsiUtil.getFirstArgumentAsStringLiteral(callExpression.getArgumentList());
            if (nameExpr != null && taskName.equals(JSPsiUtil.getStringLiteralValue(nameExpr))) {
                return nameExpr;
            }
            return callExpression;
        }
        return (PsiElement)this.myConfigByKeyMap.get(taskName);
    }

    @NotNull
    public Set<String> getConfigKeys() {
        Set<String> set = this.myConfigByKeyMap.keySet();
        if (set == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static GruntfilePsiStructure get(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(4);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        GruntfilePsiStructure gruntfilePsiStructure = (GruntfilePsiStructure)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, KEY, () -> {
            if (jsFile == null) {
                GruntfilePsiStructure.$$$reportNull$$$0(13);
            }
            GruntfilePsiStructure structure = GruntfilePsiStructure.build(jsFile);
            return CachedValueProvider.Result.create((Object)structure, (Object[])new Object[]{jsFile});
        }, false);
        if (gruntfilePsiStructure == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(5);
        }
        return gruntfilePsiStructure;
    }

    @NotNull
    private static GruntfilePsiStructure build(@NotNull JSFile file2) {
        if (file2 == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(6);
        }
        PsiElement[] topLevelElements = file2.getChildren();
        HashMap optionsMap = ContainerUtil.newHashMap();
        HashMap taskBodyByNameMap = ContainerUtil.newHashMap();
        for (PsiElement topLevelElement : topLevelElements) {
            JSFunctionExpression body;
            JSExpressionStatement expressionStatement;
            JSAssignmentExpression assignmentExpression;
            if (!(topLevelElement instanceof JSExpressionStatement) || (assignmentExpression = (JSAssignmentExpression)ObjectUtils.tryCast((Object)(expressionStatement = (JSExpressionStatement)topLevelElement).getExpression(), JSAssignmentExpression.class)) == null || !GruntfilePsiStructure.isModuleExports(assignmentExpression.getLOperand()) || (body = (JSFunctionExpression)ObjectUtils.tryCast((Object)assignmentExpression.getROperand(), JSFunctionExpression.class)) == null) continue;
            List statements = JsPsiUtils.listStatementsInExecutionOrder((JSFunctionExpression)body);
            GruntfilePsiStructure.fillOptionsMap(optionsMap, statements);
            GruntfilePsiStructure.fillTasks(taskBodyByNameMap, statements);
        }
        GruntfilePsiStructure gruntfilePsiStructure = new GruntfilePsiStructure(optionsMap, taskBodyByNameMap);
        if (gruntfilePsiStructure == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(7);
        }
        return gruntfilePsiStructure;
    }

    private static void fillOptionsMap(@NotNull Map<String, JSProperty> optionsMap, @NotNull List<JSStatement> statements) {
        if (optionsMap == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(8);
        }
        if (statements == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(9);
        }
        for (JSStatement statement : statements) {
            JSProperty[] properties;
            JSObjectLiteralExpression optionsObj;
            JSReferenceExpression refExpr;
            JSExpressionStatement exprStatement;
            JSCallExpression callExpression;
            if (!(statement instanceof JSExpressionStatement) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(exprStatement = (JSExpressionStatement)statement).getExpression(), JSCallExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) == null || !"initConfig".equals(refExpr.getReferenceName()) || (optionsObj = JSPsiUtil.getFirstArgumentAsObjectLiteral(callExpression.getArgumentList())) == null) continue;
            for (JSProperty property : properties = optionsObj.getProperties()) {
                optionsMap.put(property.getName(), property);
            }
        }
    }

    private static void fillTasks(@NotNull Map<String, JSCallExpression> taskBodyByNameMap, @NotNull List<JSStatement> statements) {
        if (taskBodyByNameMap == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(10);
        }
        if (statements == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(11);
        }
        for (JSStatement statement : statements) {
            String name;
            JSReferenceExpression refExpr;
            JSExpressionStatement exprStatement;
            JSCallExpression callExpression;
            if (!(statement instanceof JSExpressionStatement) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(exprStatement = (JSExpressionStatement)statement).getExpression(), JSCallExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) == null || !GruntfilePsiStructure.isRegisterTaskName(refExpr) || (name = JSPsiUtil.getFirstArgumentAsString(callExpression.getArgumentList())) == null) continue;
            taskBodyByNameMap.put(name, callExpression);
        }
    }

    private static boolean isRegisterTaskName(@NotNull JSReferenceExpression refExpr) {
        String name;
        if (refExpr == null) {
            GruntfilePsiStructure.$$$reportNull$$$0(12);
        }
        return "registerTask".equals(name = refExpr.getReferenceName()) || "registerMultiTask".equals(name);
    }

    private static boolean isModuleExports(@Nullable JSExpression expression) {
        JSDefinitionExpression defExpr;
        JSReferenceExpression refExpr;
        if (expression instanceof JSDefinitionExpression && (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)(defExpr = (JSDefinitionExpression)expression).getExpression(), JSReferenceExpression.class)) != null && "exports".equals(refExpr.getReferenceName())) {
            JSReferenceExpression refExpr2 = (JSReferenceExpression)ObjectUtils.tryCast((Object)refExpr.getQualifier(), JSReferenceExpression.class);
            return refExpr2 != null && "module".equals(refExpr2.getReferenceName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationByKeyMap";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskBodyByNameMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsMap";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/codeInsight/GruntfilePsiStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementToNavigateTo";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillOptionsMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillTasks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRegisterTaskName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$get$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

