/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.StandardJSCodeStyle;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSCodeStyleNotifierProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final EditorNotifications myEditorNotifications;
    private final boolean isUnitTest;
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"standardjs.codestyle.notification.panel");
    private static final String CLOSED = "standardjs.codestyle.accepted";

    public StandardJSCodeStyleNotifierProvider(PropertiesComponent propertiesComponent, EditorNotifications editorNotifications, Application application) {
        this.isUnitTest = application.isUnitTestMode();
        this.myPropertiesComponent = propertiesComponent;
        this.myEditorNotifications = editorNotifications;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(2);
        }
        if (this.isUnitTest || !(fileEditor instanceof TextEditor)) {
            return null;
        }
        Project project = ((TextEditor)fileEditor).getEditor().getProject();
        if (project == null) {
            return null;
        }
        if (this.myPropertiesComponent.getBoolean(CLOSED) || StandardJSCodeStyle.isInstalled(project)) {
            return null;
        }
        if (!file2.isWritable() || JSProjectUtil.isInLibrary(file2, project) || JSLibraryUtil.isProbableLibraryFile(file2)) {
            return null;
        }
        if (StandardJSCodeStyleNotifierProvider.isPackageJsonWithDependency(file2)) {
            EditorNotificationPanel panel = new EditorNotificationPanel(LightColors.YELLOW).text(JSBundle.message((String)"standardjs.editor.notification.can.be.enabled.text", (Object[])new Object[0]));
            panel.createActionLabel(JSBundle.message((String)"standardjs.editor.notification.action", (Object[])new Object[0]), () -> {
                StandardJSCodeStyle.install(project);
                this.myPropertiesComponent.setValue(CLOSED, true);
                this.myEditorNotifications.updateAllNotifications();
            });
            panel.createActionLabel(JSBundle.message((String)"standardjs.editor.notification.do.not.show.text", (Object[])new Object[0]), () -> {
                this.myPropertiesComponent.setValue(CLOSED, true);
                this.myEditorNotifications.updateAllNotifications();
            });
            return panel;
        }
        return null;
    }

    private static boolean isPackageJsonWithDependency(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StandardJSCodeStyleNotifierProvider.$$$reportNull$$$0(3);
        }
        return PackageJsonUtil.isPackageJsonFile(file2) && PackageJsonUtil.getOrCreateData(file2).isDependencyOfAnyType("standard");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSCodeStyleNotifierProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonWithDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

