/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicInheritorFilter
implements Condition<JSClass> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySuperClassName;
    private final boolean myStrict;
    private final boolean myCaching;
    @Nullable
    private GlobalSearchScope myScope;
    private Condition<JSClass> myCondition;

    public PublicInheritorFilter(@NotNull Project project, @NotNull String superClassName, @Nullable GlobalSearchScope scope, boolean strict) {
        if (project == null) {
            PublicInheritorFilter.$$$reportNull$$$0(0);
        }
        if (superClassName == null) {
            PublicInheritorFilter.$$$reportNull$$$0(1);
        }
        this(project, superClassName, scope, strict, true);
    }

    public PublicInheritorFilter(@NotNull Project project, @NotNull String superClassName, @Nullable GlobalSearchScope scope, boolean strict, boolean caching) {
        if (project == null) {
            PublicInheritorFilter.$$$reportNull$$$0(2);
        }
        if (superClassName == null) {
            PublicInheritorFilter.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.mySuperClassName = superClassName;
        this.myStrict = strict;
        this.myCaching = caching;
        this.setScope(scope);
    }

    private synchronized Condition<JSClass> getCondition() {
        if (DumbService.getInstance((Project)this.myProject).isDumb() || this.myScope == null) {
            return Conditions.alwaysFalse();
        }
        if (this.myCondition == null) {
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement superClass = resolver.findClassByQName(this.mySuperClassName, this.myScope);
            if (superClass instanceof JSClass) {
                Condition condition = jsClass -> {
                    JSAttributeList attributeList = jsClass.getAttributeList();
                    return attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC && JSInheritanceUtil.isParentClass(jsClass, (JSClass)superClass, this.myStrict, this.myScope);
                };
                this.myCondition = this.myCaching ? Conditions.cached((Condition)condition) : condition;
            } else {
                this.myCondition = Conditions.alwaysFalse();
            }
        }
        return this.myCondition;
    }

    public synchronized void setScope(@Nullable GlobalSearchScope scope) {
        this.myScope = scope;
        this.myCondition = null;
    }

    public boolean value(JSClass jsClass) {
        return this.getCondition().value((Object)jsClass);
    }

    @NotNull
    public String getSuperClassName() {
        String string = this.mySuperClassName;
        if (string == null) {
            PublicInheritorFilter.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

