/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.react.ReactClassToFunctionalComponentHandler;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFunctionalToClassComponentHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_TITLE = JSBundle.message((String)"refactoring.react.function.to.class.refactoring.title", (Object[])new Object[0]);

    public boolean isAvailable(@NotNull JSNamedElement element, boolean allowAnonymous) {
        JSVarStatement varStatement;
        JSFunction function;
        if (element == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(0);
        }
        if ((function = JSPsiImplUtils.getPossibleFunction((PsiElement)element)) == null) {
            return false;
        }
        if (element instanceof JSVariable && (varStatement = ((JSVariable)element).getStatement()) != null && varStatement.getDeclarations().length > 1) {
            return false;
        }
        return (ReactXmlExtension.isComponentName(function.getName()) || allowAnonymous && function.getName() == null) && ReactXmlExtension.isFunctionComponentBySignature(function) && !ReactFunctionalToClassComponentHandler.hasInstanceProperties(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(2);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(3);
        }
        this.invoke(project, editor, file2);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(6);
        }
        JSNamedElement namedElement = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), JSNamedElement.class, (boolean)false);
        JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)namedElement);
        if (namedElement == null || function == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"react.function.to.class.caret.at.function", (Object[])new Object[0]));
            ReactFunctionalToClassComponentHandler.showErrorHint(project, editor, message);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)namedElement, editor, REFACTORING_TITLE)) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)namedElement, (boolean)false));
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            SearchScope useScope = (SearchScope)ReadAction.compute(() -> namedElement.getUseScope());
            ReferencesSearch.search((PsiElement)namedElement, (SearchScope)useScope).forEach(psiReference -> {
                PsiElement refElement = psiReference.getElement();
                PsiElement parentElement = refElement.getParent();
                if (refElement instanceof JSReferenceExpression && parentElement instanceof JSCallExpression) {
                    String message = parentElement instanceof JSNewExpression ? JSBundle.message((String)"refactoring.react.function.to.class.used.in.new.conflict", (Object[])new Object[]{elementDescription}) : JSBundle.message((String)"refactoring.react.function.to.class.used.in.call.conflict", (Object[])new Object[]{elementDescription});
                    conflicts.putValue((Object)refElement, (Object)message);
                }
                return true;
            });
        }, JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!JSRefactoringUtil.showConflictsDialog(project, (MultiMap<PsiElement, String>)conflicts)) {
            return;
        }
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function);
        boolean isTypedDialect = languageDialect != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        List<ReactExtractComponentHandler.Prop> inferredProps = ReactFunctionalToClassComponentHandler.inferPropsFromDestructuring((JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters()));
        String introducedName = namedElement.getName();
        if (!isTypedDialect && !inferredProps.isEmpty() && StringUtil.isEmpty((String)introducedName) && StringUtil.isEmpty((String)(introducedName = ReactClassToFunctionalComponentHandler.showNameDialog(function.getProject(), (JSNamedElement)function)))) {
            return;
        }
        String finalIntroducedName = introducedName;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)REFACTORING_TITLE, null, () -> {
            if (editor == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(35);
            }
            ReactFunctionalToClassComponentHandler.doRefactoringInWriteAction(finalIntroducedName, namedElement, function, editor, inferredProps);
        }, (PsiFile[])new PsiFile[0]);
    }

    private static void doRefactoringInWriteAction(@Nullable String introducedName, @NotNull JSNamedElement namedElement, @NotNull JSFunction function, @NotNull Editor editor, @NotNull List<ReactExtractComponentHandler.Prop> inferredProps) {
        JSStatement[] templateStatements;
        JSClass createdClass;
        String defaultValuesText;
        JSLanguageDialect languageDialect;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(7);
        }
        if (function == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(9);
        }
        if (inferredProps == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(10);
        }
        boolean isTypedDialect = (languageDialect = DialectDetector.languageDialectOfElement((PsiElement)function)) != null && languageDialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES);
        JSParameterListElement propsParameter = (JSParameterListElement)ArrayUtil.getFirstElement((Object[])function.getParameters());
        JSBlockStatement convertedRenderFunctionBody = ReactFunctionalToClassComponentHandler.getConvertedRenderFunctionBody(function);
        if (convertedRenderFunctionBody == null) {
            return;
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)function.getProject());
        String codeTemplateName = ReactExtractComponentHandler.getCodeTemplateName(ReactExtractComponentHandler.ComponentType.Class, isTypedDialect);
        JSExpression defaultPropsProperty = ReactFunctionalToClassComponentHandler.findPropertyInitializerInCurrentFile(namedElement, "defaultProps");
        JSExpression propTypesProperty = ReactFunctionalToClassComponentHandler.findPropertyInitializerInCurrentFile(namedElement, "propTypes");
        Properties properties = fileTemplateManager.getDefaultProperties();
        if (!StringUtil.isEmpty((String)introducedName)) {
            properties.setProperty("NAME", introducedName);
        }
        properties.setProperty("HAS_PROPS", Boolean.valueOf(propsParameter != null).toString());
        String propTypesText = ReactFunctionalToClassComponentHandler.getPropsText(namedElement, propsParameter, propTypesProperty, inferredProps, isTypedDialect);
        if (!StringUtil.isEmpty((String)propTypesText)) {
            properties.setProperty("PROP_TYPES", propTypesText);
        }
        if (!StringUtil.isEmpty((String)(defaultValuesText = ReactFunctionalToClassComponentHandler.getDefaultPropsText(defaultPropsProperty, inferredProps)))) {
            properties.setProperty("DEFAULT_PROPS", defaultValuesText);
        }
        PsiFile createdFile = (createdClass = ReactExtractComponentHandler.expandTemplate((PsiElement)namedElement, properties, codeTemplateName, JSClass.class)) != null ? createdClass.getContainingFile() : null;
        JSFunction renderMethod = createdClass != null ? createdClass.findFunctionByNameAndKind("render", JSFunction.FunctionKind.SIMPLE) : null;
        JSBlockStatement templateBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(renderMethod);
        JSStatement[] jSStatementArray = templateStatements = templateBody != null ? templateBody.getStatements() : JSStatement.EMPTY;
        if (createdClass == null || templateBody == null || templateStatements.length == 0) {
            String message = JSBundle.message((String)"refactoring.react.could.not.find.in.template", (Object[])new Object[]{introducedName, codeTemplateName});
            ReactFunctionalToClassComponentHandler.showErrorHint(namedElement.getProject(), editor, message);
            return;
        }
        ReactFunctionalToClassComponentHandler.copyExportStatus(namedElement, (JSAttributeListOwner)createdClass);
        ReactExtractComponentHandler.addRequiredImportsForClassComponent(createdClass, (PsiElement)namedElement);
        ReactFunctionalToClassComponentHandler.copyReturnType((JSNamedElement)function, (JSNamedElement)renderMethod);
        JSChangeUtil.replaceStatement((JSStatement)templateBody, (JSStatement)convertedRenderFunctionBody);
        ReactFunctionalToClassComponentHandler.deletePropertyIfNeeded(propTypesProperty, createdClass, "propTypes");
        ReactFunctionalToClassComponentHandler.deletePropertyIfNeeded(defaultPropsProperty, createdClass, "defaultProps");
        PsiElement result2 = ReactClassToFunctionalComponentHandler.expressionAwareReplace(namedElement, createdFile, (JSNamedElement)createdClass);
        ReactClassToFunctionalComponentHandler.moveCaretToElement(editor, result2);
        FormatFixer.create(result2, FormatFixer.Mode.Reformat).fixFormat();
    }

    private static void deletePropertyIfNeeded(@Nullable JSExpression existingProperty, @NotNull JSClass createdClass, @NotNull String propName) {
        if (createdClass == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(11);
        }
        if (propName == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(12);
        }
        if (existingProperty == null) {
            return;
        }
        JSExpression createdProperty = ReactFunctionalToClassComponentHandler.findPropertyInitializerInCurrentFile((JSNamedElement)createdClass, propName);
        if (createdProperty != null) {
            ReactFunctionalToClassComponentHandler.deleteContainingStatement((JSElement)createdProperty);
        }
        if (createdClass.findFieldByName(propName) != null) {
            ReactFunctionalToClassComponentHandler.deleteContainingStatement((JSElement)existingProperty);
        }
    }

    @NotNull
    private static List<ReactExtractComponentHandler.Prop> inferPropsFromDestructuring(@Nullable JSParameterListElement propsParameter) {
        JSDestructuringContainer target;
        JSDestructuringContainer jSDestructuringContainer = target = propsParameter instanceof JSDestructuringParameter ? ((JSDestructuringParameter)propsParameter).getTarget() : null;
        if (!(target instanceof JSDestructuringObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Object[])((JSDestructuringObject)target).getProperties(), property -> {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name) || property.isRest()) {
                return null;
            }
            JSInitializerOwner initializerOwner = property.getDestructuringElement();
            JSExpression initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
            return new ReactExtractComponentHandler.Prop(name, ReactExtractComponentHandler.getUsableExpressionType(initializer, (PsiElement)property), initializer != null ? initializer.getText() : null);
        });
        if (list == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    public static TypeScriptSingleType getSFCTypeDeclaration(@NotNull JSNamedElement namedElement) {
        JSReferenceExpression typeReferenceExpression;
        PsiElement typeElement;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(15);
        }
        if (namedElement instanceof JSTypeDeclarationOwner && (typeElement = ((JSTypeDeclarationOwner)namedElement).getTypeElement()) instanceof TypeScriptSingleType && (typeReferenceExpression = ((TypeScriptSingleType)typeElement).getReferenceExpression()) != null && TypeScriptReactComponentUtil.REACT_SFC_TYPE_NAMES.contains(typeReferenceExpression.getReferenceName())) {
            return (TypeScriptSingleType)typeElement;
        }
        return null;
    }

    @Nullable
    private static String getPropsText(@NotNull JSNamedElement namedElement, @Nullable JSParameterListElement propsParameter, @Nullable JSExpression propTypesProperty, @NotNull List<ReactExtractComponentHandler.Prop> inferredProps, boolean isTypedDialect) {
        PsiElement propsTypeElement;
        TypeScriptSingleType sfcTypeDeclaration;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(16);
        }
        if (inferredProps == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(17);
        }
        if ((sfcTypeDeclaration = ReactFunctionalToClassComponentHandler.getSFCTypeDeclaration(namedElement)) != null) {
            JSTypeDeclaration typeArg = (JSTypeDeclaration)ArrayUtil.getFirstElement((Object[])sfcTypeDeclaration.getTypeArguments());
            return typeArg != null ? typeArg.getText() : null;
        }
        PsiElement psiElement = propsTypeElement = propsParameter != null ? propsParameter.getTypeElement() : null;
        if (propsTypeElement != null) {
            return propsTypeElement.getText();
        }
        boolean isPropsTypeParameterRequired = DialectDetector.isFlow((PsiElement)namedElement);
        if (propTypesProperty != null) {
            return propTypesProperty.getText();
        }
        if (!inferredProps.isEmpty()) {
            if (isTypedDialect) {
                return ReactExtractComponentHandler.buildTypedPropTypesText(inferredProps, !isPropsTypeParameterRequired);
            }
            return ReactExtractComponentHandler.buildJSPropTypesText(inferredProps, (PsiElement)namedElement);
        }
        return isPropsTypeParameterRequired ? "{}" : null;
    }

    @Nullable
    private static String getDefaultPropsText(@Nullable JSExpression defaultPropsProp, @NotNull List<ReactExtractComponentHandler.Prop> inferredProps) {
        if (inferredProps == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(18);
        }
        if (defaultPropsProp != null) {
            return defaultPropsProp.getText();
        }
        if ((inferredProps = ContainerUtil.filter(inferredProps, t -> t.value != null)).isEmpty()) {
            return null;
        }
        return "{" + StringUtil.join((Collection)inferredProps, t -> t.name + ": " + t.value, (String)", ") + "}";
    }

    @Nullable
    private static JSExpression findPropertyInitializerInCurrentFile(@NotNull JSNamedElement namedElement, @NotNull String propName) {
        String namespace;
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(19);
        }
        if (propName == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(20);
        }
        if ((namespace = namedElement.getName()) == null) {
            return null;
        }
        PsiFile file2 = namedElement.getContainingFile();
        for (PsiElement child : file2.getChildren()) {
            JSExpression initializer = ReactFunctionalToClassComponentHandler.getInitializerIfProperty(child, namespace, propName);
            if (initializer == null) continue;
            return initializer;
        }
        return null;
    }

    @Nullable
    private static JSExpression getInitializerIfProperty(@Nullable PsiElement candidate, @NotNull String namespace, @NotNull String propertyName) {
        if (namespace == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(21);
        }
        if (propertyName == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(22);
        }
        if (!(candidate instanceof JSExpressionStatement)) {
            return null;
        }
        JSExpression expression = ((JSExpressionStatement)candidate).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return null;
        }
        JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)expression).getDefinitionExpression();
        if (definitionExpression == null) {
            return null;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(definitionExpression.getExpression(), namespace, propertyName)) {
            return definitionExpression.getInitializer();
        }
        return null;
    }

    private static boolean hasInstanceProperties(@NotNull JSNamedElement namedElement) {
        if (namedElement == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(23);
        }
        if (namedElement.getName() == null) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)namedElement.getContainingFile());
        return !JSClassResolver.getInstance().processNamespaceMembers(namedElement.getName(), scope, (Processor<JSPsiElementBase>)((Processor)element -> element.getJSContext() != JSContext.INSTANCE));
    }

    @Nullable
    private static JSBlockStatement getConvertedRenderFunctionBody(@NotNull JSFunction function) {
        JSParameterListElement[] parameters;
        if (function == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(24);
        }
        JSParameterListElement propsParameter = (parameters = function.getParameters()).length > 0 ? parameters[0] : null;
        JSParameterListElement contextParameter = parameters.length > 1 ? parameters[1] : null;
        JSBlockStatement functionBody = ReactFunctionalToClassComponentHandler.findFunctionBlockBody(function);
        JSExpression arrowFunctionReturned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        JSElement toProcess = (JSElement)ObjectUtils.coalesce((Object)functionBody, (Object)arrowFunctionReturned);
        if (toProcess == null) {
            return null;
        }
        String replacementText = ReactFunctionalToClassComponentHandler.replaceParameterReferences(toProcess, propsParameter, contextParameter);
        if (arrowFunctionReturned != null) {
            replacementText = String.format("{\nreturn %s%s\n}", replacementText, semicolon);
        }
        JSBlockStatement replacementStatement = JSChangeUtil.createStatementPsiFromTextWithContext(replacementText, (PsiElement)function, JSBlockStatement.class);
        assert (replacementStatement != null);
        if (propsParameter instanceof JSDestructuringParameter) {
            JSDestructuringParameter parameterCopy = (JSDestructuringParameter)propsParameter.copy();
            JSDestructuringObject destructuringObject = (JSDestructuringObject)ObjectUtils.tryCast((Object)parameterCopy.getTarget(), JSDestructuringObject.class);
            if (destructuringObject != null) {
                for (JSDestructuringProperty property : destructuringObject.getProperties()) {
                    JSInitializerOwner element = property.getDestructuringElement();
                    if (element == null) continue;
                    JSRefactoringUtil.removeInitializer(element);
                }
            }
            JSRefactoringUtil.setType((JSElement)parameterCopy, null);
            String text = String.format("let %s = this.props%s", parameterCopy.getText(), semicolon);
            JSStatement propsInitialization = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)propsParameter, JSStatement.class);
            assert (propsInitialization != null);
            ReactFunctionalToClassComponentHandler.addStatementAtStart(replacementStatement, propsInitialization);
        }
        if (contextParameter instanceof JSDestructuringParameter) {
            String text = String.format("let %s = this.context%s", contextParameter.getText(), semicolon);
            JSStatement contextInitialization = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)propsParameter, JSStatement.class);
            assert (contextInitialization != null);
            ReactFunctionalToClassComponentHandler.addStatementAtStart(replacementStatement, contextInitialization);
        }
        return replacementStatement;
    }

    private static void addStatementAtStart(@NotNull JSBlockStatement block, @NotNull JSStatement toAdd) {
        ASTNode lbraceNode;
        if (block == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(25);
        }
        if (toAdd == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(26);
        }
        block.addAfter((PsiElement)toAdd, (lbraceNode = block.getNode().findChildByType(JSTokenTypes.LBRACE)) != null ? lbraceNode.getPsi() : null);
    }

    private static void deleteContainingStatement(@NotNull JSElement element) {
        JSSourceElement statement;
        if (element == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(27);
        }
        if ((statement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class, (boolean)false)) != null) {
            statement.delete();
        }
    }

    @NotNull
    private static String replaceParameterReferences(@NotNull JSElement toProcess, @Nullable JSParameterListElement propsParameter, @Nullable JSParameterListElement contextParameter) {
        if (toProcess == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(28);
        }
        HashMap paramReferencesToReplace = new HashMap();
        PsiTreeUtil.processElements((PsiElement)toProcess, element -> {
            if (element instanceof JSReferenceExpression) {
                PsiElement resolved = ((JSReferenceExpression)element).resolve();
                if (propsParameter instanceof JSParameter && propsParameter.isEquivalentTo(resolved)) {
                    paramReferencesToReplace.put((JSReferenceExpression)element, "this.props");
                } else if (contextParameter instanceof JSParameter && contextParameter.isEquivalentTo(resolved)) {
                    paramReferencesToReplace.put((JSReferenceExpression)element, "this.context");
                }
            }
            return true;
        });
        String string = ReactExtractComponentHandler.replaceOccurrences(toProcess, toProcess.getTextRange(), paramReferencesToReplace.keySet(), expression -> (String)paramReferencesToReplace.get(expression));
        if (string == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public static JSBlockStatement findFunctionBlockBody(@Nullable JSFunction function) {
        return JSPsiImplUtils.getFunctionBlockBody(function);
    }

    public static void copyReturnType(@Nullable JSNamedElement owner, @Nullable JSNamedElement target) {
        PsiElement typeElement;
        if (owner instanceof JSFunction && target instanceof JSFunction && (typeElement = ((JSFunction)owner).getReturnTypeElement()) != null) {
            JSRefactoringUtil.setFunctionReturnType((JSFunction)target, typeElement.getText());
        }
    }

    public static void copyExportStatus(@NotNull JSNamedElement source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(30);
        }
        if (target == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(31);
        }
        boolean isExported = source instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)source, JSAttributeList.ModifierType.EXPORT);
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper(target);
        attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, isExported);
        attributeListWrapper.applyTo(target);
    }

    private static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message) {
        if (project == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(32);
        }
        if (editor == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(33);
        }
        if (message == null) {
            ReactFunctionalToClassComponentHandler.$$$reportNull$$$0(34);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_TITLE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 9: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredProps";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdClass";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propName";
                break;
            }
            case 13: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/ReactFunctionalToClassComponentHandler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/ReactFunctionalToClassComponentHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferPropsFromDestructuring";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceParameterReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoringInWriteAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deletePropertyIfNeeded";
                break;
            }
            case 13: 
            case 14: 
            case 29: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSFCTypeDeclaration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPropsText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropsText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyInitializerInCurrentFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerIfProperty";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasInstanceProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConvertedRenderFunctionBody";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addStatementAtStart";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deleteContainingStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replaceParameterReferences";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "copyExportStatus";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

