/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.Icon;

public class FileColor {
    private static final Color[] ALL_COLORS = new Color[]{new JBColor(DarculaColors.BLUE, DarculaColors.BLUE), new JBColor(new Color(68, 137, 206), new Color(68, 137, 206)), new JBColor(new Color(159, 107, 0), new Color(159, 107, 0)), new JBColor(new Color(159, 137, 0), new Color(159, 137, 0)), new JBColor(new Color(0, 137, 137), new Color(0, 137, 137)), new JBColor(new Color(0, 107, 117), new Color(0, 107, 117)), JBColor.GRAY, new JBColor(new Color(98, 150, 85), new Color(98, 150, 85)), new JBColor(new Color(120, 170, 115), new Color(120, 170, 115)), new JBColor(new Color(151, 118, 169), new Color(151, 118, 169)), new JBColor(new Color(121, 98, 119), new Color(121, 98, 119)), new JBColor(DarculaColors.RED, DarculaColors.RED), new JBColor(new Color(200, 80, 80), new Color(200, 80, 80)), new JBColor(new Color(138, 138, 0), new Color(138, 138, 0))};
    private final List<Color> myAvailableColors = new ArrayList<Color>();
    private final Map<String, MyColorAndIcon> myIconCache = new HashMap<String, MyColorAndIcon>();
    private static final FileColor INSTANCE = new FileColor();

    public static Icon getIcon(String fileName) {
        return INSTANCE.getOrAddCachedItem(fileName).getIcon();
    }

    public static Color getColor(String fileName) {
        return INSTANCE.getOrAddCachedItem(fileName).getColor();
    }

    public Icon getFileIcon(String fileName) {
        return this.getOrAddCachedItem(fileName).getIcon();
    }

    private MyColorAndIcon getOrAddCachedItem(String fileName) {
        MyColorAndIcon item;
        String module = NodeModuleNamesUtil.getModule(fileName);
        if (!StringUtil.isEmpty((String)module)) {
            fileName = module;
        }
        if ((item = this.myIconCache.get(fileName)) == null) {
            if (this.myAvailableColors.isEmpty()) {
                this.myAvailableColors.addAll(Arrays.asList(ALL_COLORS));
            }
            item = new MyColorAndIcon(this.myAvailableColors.remove(new Random().nextInt(this.myAvailableColors.size())));
            this.myIconCache.put(fileName, item);
        }
        return item;
    }

    public static Icon createIcon(Color color) {
        return JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 10, color, false));
    }

    private static class MyColorAndIcon {
        private final ColorIcon myIcon;
        private final Color myColor;

        private MyColorAndIcon(Color color) {
            this.myColor = color;
            this.myIcon = (ColorIcon)JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 10, color, false));
        }

        public ColorIcon getIcon() {
            return this.myIcon;
        }

        public Color getColor() {
            return this.myColor;
        }
    }
}

