/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.typescript.intentions.TypeScriptAddAugmentationImportFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class TypeScriptMissingAugmentationImportInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptMissingAugmentationImportInspection.calcShortNameFromClass(TypeScriptMissingAugmentationImportInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                DialectOptionHolder optionHolder;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((optionHolder = DialectDetector.dialectOfElement((PsiElement)node)) == null || !optionHolder.isTypeScript) {
                    return;
                }
                JSExpression qualifier = node.getQualifier();
                if (qualifier == null) {
                    return;
                }
                TypeScriptMissingAugmentationImportInspection.processReferenceExpression(holder, node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection$1", "visitJSReferenceExpression"));
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static void processReferenceExpression(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        PsiElement module;
        if (holder == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(1);
        }
        if (node == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(2);
        }
        if ((module = ES6PsiUtil.findExternalModule((PsiElement)node)) == null) {
            return;
        }
        String name = TypeScriptAddAugmentationImportFix.getImportedModuleName((PsiElement)node);
        if (name == null) {
            return;
        }
        TypeScriptMissingAugmentationImportInspection.registerProblem(name, holder, node);
    }

    private static void registerProblem(@NotNull String name, @NotNull ProblemsHolder holder, @NotNull JSReferenceExpression context) {
        if (name == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypeScriptMissingAugmentationImportInspection.$$$reportNull$$$0(5);
        }
        PsiElement element = context.getReferenceNameElement();
        assert (element != null);
        holder.registerProblem(element, JSBundle.message((String)"typescript.missing.augmentation.import", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new TypeScriptAddAugmentationImportFix((PsiElement)context, name)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptMissingAugmentationImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

