/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.NoRowsException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.exceptions.OracleTimezoneRegionNotFoundException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;

public class OracleExceptionRecognizer
extends BaseExceptionRecognizer {
    public static final OracleExceptionRecognizer INSTANCE = new OracleExceptionRecognizer();
    private static final Map<Integer, Class<? extends DBException>> simpleExceptionMap = new HashMap<Integer, Class<? extends DBException>>();
    private static final Pattern ORA_ERROR_PATTERN;

    @Override
    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        Class<? extends DBException> simpleExceptionClass;
        int errCode = sqle.getErrorCode();
        String errMsg = sqle.getMessage();
        if (errCode == 604 && errMsg != null) {
            errCode = this.parseRealErrCode(errMsg);
        }
        if ((simpleExceptionClass = simpleExceptionMap.get(errCode)) != null) {
            return this.instantiateDBException(simpleExceptionClass, sqle, statementText);
        }
        return null;
    }

    private int parseRealErrCode(@NotNull String errMsg) {
        Matcher m = ORA_ERROR_PATTERN.matcher(errMsg);
        boolean found = m.find();
        while (found) {
            int code = Integer.parseInt(m.group(1), 10);
            if (code > 0 && code != 604) {
                return code;
            }
            found = m.find(m.end());
        }
        return 604;
    }

    static {
        simpleExceptionMap.put(942, NoTableOrViewException.class);
        simpleExceptionMap.put(1403, NoRowsException.class);
        simpleExceptionMap.put(1882, OracleTimezoneRegionNotFoundException.class);
        ORA_ERROR_PATTERN = Pattern.compile("ORA-(\\d{5}):");
    }
}

