/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.sql.TextFileFragment;
import org.jetbrains.dekaf.sql.TextFragment;
import org.jetbrains.dekaf.util.StringOperator;

public abstract class SqlStatement {
    final int myRow;
    @NotNull
    final String mySourceText;
    @Nullable
    final String myName;
    @NotNull
    final String myDescription;

    protected SqlStatement(@NotNull TextFragment sourceFragment) {
        String mainDescriptionPart;
        this.mySourceText = sourceFragment.text;
        this.myRow = sourceFragment.row;
        if (sourceFragment instanceof TextFileFragment) {
            String name;
            TextFileFragment f = (TextFileFragment)sourceFragment;
            this.myName = name = f.getFragmentName();
            if (name == null) {
                name = "SQL fragment";
            }
            mainDescriptionPart = name + " from " + f.getTextName() + ':' + f.row + ':' + f.pos;
        } else {
            TextFragment f = sourceFragment;
            mainDescriptionPart = "SQL statement from " + f.getTextName() + ':' + f.row + ':' + f.pos;
            this.myName = null;
        }
        this.myDescription = mainDescriptionPart;
    }

    protected SqlStatement(@NotNull String sourceText) {
        this(sourceText, 1, null);
    }

    protected SqlStatement(@NotNull String sourceText, int row, @Nullable String statementName) {
        this(row, sourceText, statementName != null ? statementName : '@' + Integer.toString(row), statementName != null ? statementName : "SQL statement at row " + row);
    }

    protected SqlStatement(int row, @NotNull String sourceText, @Nullable String name, @NotNull String description) {
        this.myRow = row;
        this.mySourceText = sourceText;
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public abstract SqlStatement rewrite(@NotNull StringOperator var1);

    public int getRow() {
        return this.myRow;
    }

    @NotNull
    public String getSourceText() {
        return this.mySourceText;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.myName != null) {
            b.append(this.myName).append(": ");
        }
        b.append(this.myDescription).append(":\n");
        b.append(this.mySourceText);
        return b.toString();
    }
}

