/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportClassIntention
extends PsiElementBaseIntentionAction {
    public static final String NAME = PhpBundle.message("intention.import.class", new Object[0]);
    private static final Function<String, String> NAME_UNIFIER = s -> StringUtil.toLowerCase((String)s);

    public static boolean canBeImported(@NotNull PhpReference classReference) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(0);
        }
        return PhpCodeInsightUtil.isImportSupported(classReference) && PhpCodeInsightUtil.hasQualifier(classReference);
    }

    @NotNull
    public String getFamilyName() {
        String string = NAME;
        if (string == null) {
            PhpImportClassIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpImportClassIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpReference classReference = PhpPsiUtil.getClassReferenceAt(element);
        if (!(classReference instanceof ClassReference) && !(classReference instanceof PhpDocType)) {
            return false;
        }
        PhpDocTag docTag = (PhpDocTag)PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        if (docTag != null && StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass")) {
            return false;
        }
        if (PhpImportClassIntention.canBeImported(classReference)) {
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
            if (scopeForUseOperator == null) {
                return false;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(classReference);
            if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                return false;
            }
            if (PhpLangUtil.isClassNameSpecial(PhpLangUtil.toName(fqn))) {
                return false;
            }
            this.setText(NAME);
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PhpReference classReference;
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpImportClassIntention.$$$reportNull$$$0(5);
        }
        if ((classReference = PhpPsiUtil.getClassReferenceAt(element)) == null) {
            return;
        }
        String fqn = PhpCodeInsightUtil.getImmediateFQN(classReference);
        if (fqn == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scopeForUseOperator == null) {
            return;
        }
        Set<String> usedAliases = PhpImportClassIntention.collectUsedAliases(scopeForUseOperator, PhpGroupUseElement.PhpUseKeyword.CLASS);
        String name = PhpLangUtil.toShortName(fqn);
        if (PhpImportClassIntention.isAliasModeEnable() || usedAliases.contains(StringUtil.toLowerCase((String)name))) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.apply(project, scopeForUseOperator, fqn, name + "Alias");
            } else {
                PhpImportClassDialog dialog = new PhpImportClassDialog(project, fqn, usedAliases);
                if (dialog.showAndGet()) {
                    String alias = dialog.getAlias();
                    this.apply(project, scopeForUseOperator, fqn, PhpLangUtil.equalsClassNames(alias, name) ? null : alias);
                }
            }
        } else {
            this.apply(project, scopeForUseOperator, fqn, null);
        }
    }

    public static Set<String> collectUsedAliases(@NotNull PhpPsiElement scopeHolder, PhpGroupUseElement.PhpUseKeyword ... keywords) {
        if (scopeHolder == null) {
            PhpImportClassIntention.$$$reportNull$$$0(6);
        }
        Set<String> aliases = PhpCodeInsightUtil.getAliasesInScope(scopeHolder, keywords).keySet();
        return ContainerUtil.map2Set((Object[])ArrayUtil.toStringArray(aliases), NAME_UNIFIER);
    }

    private void apply(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn, @Nullable String alias) {
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(7);
        }
        if (scopeForUseOperator == null) {
            PhpImportClassIntention.$$$reportNull$$$0(8);
        }
        if (originalFqn == null) {
            PhpImportClassIntention.$$$reportNull$$$0(9);
        }
        final HashSet references = new HashSet();
        final HashSet phpDocTypes = new HashSet();
        scopeForUseOperator.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                if (!PhpCodeInsightUtil.isScopeForUseOperator(element)) {
                    super.visitPhpElement(element);
                }
            }

            public void visitPhpDocType(PhpDocType phpDocType) {
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)phpDocType))) {
                    phpDocTypes.add(phpDocType);
                }
            }

            public void visitPhpClassReference(ClassReference classReference) {
                if (PhpImportClassIntention.canBeImported((PhpReference)classReference) && PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN((PhpReference)classReference))) {
                    references.add(classReference);
                }
            }
        });
        PsiFile file = scopeForUseOperator.getContainingFile();
        if (file == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (originalFqn == null) {
                PhpImportClassIntention.$$$reportNull$$$0(11);
            }
            if (scopeForUseOperator == null) {
                PhpImportClassIntention.$$$reportNull$$$0(12);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (originalFqn == null) {
                    PhpImportClassIntention.$$$reportNull$$$0(13);
                }
                if (scopeForUseOperator == null) {
                    PhpImportClassIntention.$$$reportNull$$$0(14);
                }
                PhpAliasImporter.insertUseStatement(originalFqn, alias, scopeForUseOperator);
                for (ClassReference reference : references) {
                    PhpImportClassIntention.replaceClassReference((PhpPsiElement)reference, alias);
                }
                PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                if (!settings.PHPDOC_USE_FQCN) {
                    for (PhpDocType phpDocType : phpDocTypes) {
                        PhpImportClassIntention.replaceClassReference((PhpPsiElement)phpDocType, alias);
                    }
                }
            });
        }, this.getText(), null);
    }

    public static void replaceClassReference(@NotNull PhpPsiElement classReference, @Nullable String newFqn) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(10);
        }
        if (newFqn == null) {
            PhpCodeEditUtil.replaceNamespaceReference(classReference, null);
        } else {
            Project project = classReference.getProject();
            if (classReference instanceof PhpDocType) {
                if (PhpType.isPluralType((String)classReference.getText())) {
                    PhpDocType type = PhpPsiElementFactory.createPhpDocType(project, newFqn + "[]");
                    classReference.replace((PsiElement)type);
                } else {
                    PhpDocType type = PhpPsiElementFactory.createPhpDocType(project, newFqn);
                    classReference.replace((PsiElement)type);
                }
            } else {
                ClassReference newReference = PhpPsiElementFactory.createClassReference(project, newFqn);
                classReference.replace((PsiElement)newReference);
            }
        }
    }

    private static boolean isAliasModeEnable() {
        return PhpRefactoringSettings.getInstance().IMPORT_CLASS_ALWAYS_CREATE_ALIAS;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeImported";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectUsedAliases";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceClassReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$apply$2";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpImportClassDialog
    extends DialogWrapper {
        private static final String DIMENSION_SERVICE_KEY = "#com.jetbrains.php.lang.intentions.PhpImportClassDialog#";
        private final JTextField myAliasTextField;
        private NonFocusableCheckBox myAlwaysCreateAlias;
        private final String myFqn;
        private Set<String> myUsedAliases;

        protected PhpImportClassDialog(@Nullable Project project, @NotNull String fqn, @NotNull Set<String> aliases) {
            if (fqn == null) {
                PhpImportClassDialog.$$$reportNull$$$0(0);
            }
            if (aliases == null) {
                PhpImportClassDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFqn = fqn;
            this.myUsedAliases = aliases;
            this.myAliasTextField = new JTextField(PhpLangUtil.toShortName(this.myFqn));
            this.myAliasTextField.setPreferredSize(new Dimension(400, this.myAliasTextField.getPreferredSize().height));
            this.myUsedAliases = aliases;
            this.setTitle(PhpBundle.message("intention.import.class", new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return null;
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = new Insets(0, 0, 4, 0);
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 0;
            gbConstraints.fill = 1;
            JLabel aliasLabel = new JLabel(PhpBundle.message("intention.import.class.alias.name", new Object[0]));
            panel.add((Component)aliasLabel, gbConstraints);
            gbConstraints.insets = new Insets(0, 0, 8, 0);
            gbConstraints.gridwidth = 2;
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 1.0;
            panel.add((Component)this.myAliasTextField, gbConstraints);
            gbConstraints.insets = new Insets(0, 0, 4, 0);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            this.myAlwaysCreateAlias = new NonFocusableCheckBox();
            this.myAlwaysCreateAlias.setText(PhpBundle.message("intention.import.class.always.create.alias", new Object[0]));
            this.myAlwaysCreateAlias.setSelected(PhpImportClassIntention.isAliasModeEnable());
            panel.add((Component)this.myAlwaysCreateAlias, gbConstraints);
            return panel;
        }

        private String getAlias() {
            return this.myAliasTextField.getText().trim();
        }

        protected boolean postponeValidation() {
            return false;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String alias = this.getAlias();
            if (!PhpNameUtil.isValidClassName(alias)) {
                return new ValidationInfo(PhpBundle.message("validation.invalid.alias", alias), (JComponent)this.myAliasTextField);
            }
            if (this.myUsedAliases.contains(StringUtil.toLowerCase((String)alias))) {
                return new ValidationInfo(PhpBundle.message("intention.import.class.alias.already.exists", new Object[0]), (JComponent)this.myAliasTextField);
            }
            return null;
        }

        protected void doOKAction() {
            PhpRefactoringSettings.getInstance().IMPORT_CLASS_ALWAYS_CREATE_ALIAS = this.myAlwaysCreateAlias.isSelected();
            super.doOKAction();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myAliasTextField;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return DIMENSION_SERVICE_KEY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aliases";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention$PhpImportClassDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

