/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.pathmapper;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLocalPathMapper
extends PhpPathMapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.util.pathmapper.PhpLocalPathMapper");
    private static final int MAX_RESOLVE_ATTEMPTS = 100;
    private final Project myProject;
    private final Map<String, String> myCache;

    public PhpLocalPathMapper(@NotNull Project project) {
        if (project == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(0);
        }
        this.myCache = new HashMap<String, String>();
        this.myProject = project;
    }

    @Override
    @NotNull
    public synchronized String getRemoteFilePath(@NotNull String localFileUrl) {
        String string;
        String localFilePath;
        String remoteFilePath;
        if (localFileUrl == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(1);
        }
        if ((remoteFilePath = this.myCache.get(localFilePath = VirtualFileManager.extractPath((String)localFileUrl))) != null) {
            String string2 = remoteFilePath;
            if (string2 == null) {
                PhpLocalPathMapper.$$$reportNull$$$0(2);
            }
            return string2;
        }
        try {
            String canonicalPath = new File(localFilePath).getCanonicalPath();
            this.myCache.put(localFilePath, canonicalPath);
            string = canonicalPath;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.myCache.put(localFilePath, localFilePath);
            String string3 = localFilePath;
            if (string3 == null) {
                PhpLocalPathMapper.$$$reportNull$$$0(4);
            }
            return string3;
        }
        if (string == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public synchronized String getLocalPath(@NotNull String remoteFileUrlOrPath) {
        if (remoteFileUrlOrPath == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(5);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache size: " + this.myCache.size());
        }
        String remoteFilePath = VirtualFileManager.extractPath((String)remoteFileUrlOrPath);
        String remoteCanonicalFilePath = PathUtil.getCanonicalPath((String)remoteFilePath);
        for (Map.Entry<String, String> entry : this.myCache.entrySet()) {
            if (!remoteCanonicalFilePath.equalsIgnoreCase(entry.getValue())) continue;
            String string = entry.getKey();
            if (string == null) {
                PhpLocalPathMapper.$$$reportNull$$$0(6);
            }
            return string;
        }
        String fileName = PathUtil.getFileName((String)remoteFilePath);
        if (fileName.length() > 0) {
            Collection candidates = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)fileName, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)));
            int i = 0;
            for (VirtualFile candidate : candidates) {
                String string;
                if (i++ > 100) break;
                try {
                    String candidateFilePath = candidate.getPath();
                    String resolvedFilePath = new File(candidateFilePath).getCanonicalPath();
                    if (!remoteCanonicalFilePath.equalsIgnoreCase(PathUtil.getCanonicalPath((String)resolvedFilePath))) continue;
                    String candidateCanonicalFilePath = PathUtil.getCanonicalPath((String)candidateFilePath);
                    this.myCache.put(candidateCanonicalFilePath, remoteCanonicalFilePath);
                    string = candidateCanonicalFilePath;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    continue;
                }
                if (string == null) {
                    PhpLocalPathMapper.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        this.myCache.put(remoteFilePath, remoteFilePath);
        String string = remoteFilePath;
        if (string == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getLocalFile(@NotNull String remoteFileUrlOrPath) {
        if (remoteFileUrlOrPath == null) {
            PhpLocalPathMapper.$$$reportNull$$$0(9);
        }
        String localPath = this.getLocalPath(remoteFileUrlOrPath);
        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (localFile == null) {
            return PharFileSystem.getInstance().findFileByPath(localPath);
        }
        return localFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileUrl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/pathmapper/PhpLocalPathMapper";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileUrlOrPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/pathmapper/PhpLocalPathMapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteFilePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

