/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.ui.TextFieldAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.AdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.ConnectionSelector;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.EditChangelistJobsDialog;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.JobViewSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsMasterDetails;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsTablePresentation;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;
import org.jetbrains.idea.perforce.perforce.jobs.SelfLoadingJobDetailsPanel;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;
import org.jetbrains.idea.perforce.perforce.jobs.WiseAdderRemover;

public class PerforceCheckinComponent
implements CheckinChangeListSpecificComponent,
JobsTablePresentation {
    private final Project myProject;
    private final PairConsumer<Object, Object> myAdditionalDataConsumer;
    private JPanel myPanel;
    private LocalChangeList myCurrent;
    private final Map<LocalChangeList, Map<ConnectionKey, List<PerforceJob>>> myCache;
    private final PerforceVcs myVcs;
    private final Map<ConnectionKey, P4JobsLogicConn> myConnMap;
    private final AdderRemover myAdderRemover;
    private final JobsMasterDetails myDetails;
    private static final ColumnInfo<PerforceJob, String> JOB = new ColumnInfo<PerforceJob, String>("Job"){

        public String valueOf(PerforceJob perforceJob) {
            return perforceJob.getName();
        }
    };
    private static final ColumnInfo<PerforceJob, String> STATUS = new ColumnInfo<PerforceJob, String>("Status"){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.status);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> USER = new ColumnInfo<PerforceJob, String>("User"){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.user);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> DATE = new ColumnInfo<PerforceJob, String>("Date"){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.date);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo<PerforceJob, String> DESCRIPTION = new ColumnInfo<PerforceJob, String>("Description"){

        public String valueOf(PerforceJob perforceJob) {
            PerforceJobFieldValue field = perforceJob.getValueForStandardField(StandardJobFields.description);
            return field == null ? null : field.getValue();
        }
    };
    private static final ColumnInfo[] columns = new ColumnInfo[]{JOB, STATUS, USER, DATE, DESCRIPTION};

    public PerforceCheckinComponent(Project project, PairConsumer<Object, Object> additionalDataConsumer) {
        this.myProject = project;
        this.myAdditionalDataConsumer = additionalDataConsumer;
        this.myVcs = PerforceVcs.getInstance(this.myProject);
        this.myConnMap = new HashMap<ConnectionKey, P4JobsLogicConn>();
        this.myCache = new HashMap<LocalChangeList, Map<ConnectionKey, List<PerforceJob>>>();
        this.myDetails = new JobsMasterDetails(this.myProject){

            @Override
            protected Dimension getPanelPreferredSize() {
                return JBUI.size((int)200, (int)70);
            }
        };
        this.myDetails.onlyMain();
        this.initUI();
        this.myAdderRemover = new WiseAdderRemover(this.myProject, this);
    }

    @Override
    public void refreshJobs(PerforceJob job) throws VcsException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (!this.myCurrent.hasDefaultName()) {
            Map<ConnectionKey, List<PerforceJob>> data = this.loadOnSelect(this.myCurrent);
            this.myCache.put(this.myCurrent, data);
            ApplicationManager.getApplication().invokeLater(() -> this.setItems(ContainerUtil.flatten(data.values())));
        }
    }

    @Override
    public void addJob(PerforceJob job) {
        Map<ConnectionKey, List<PerforceJob>> data = this.getCurrentListJobs();
        if (data != null) {
            List<PerforceJob> jobs = data.get(job.getConnectionKey());
            if (jobs == null) {
                jobs = new ArrayList<PerforceJob>();
                data.put(job.getConnectionKey(), jobs);
            }
            jobs.add(job);
            this.saveJobsInCache(data);
            this.setItems(ContainerUtil.flatten(data.values()));
        }
    }

    private Map<ConnectionKey, List<PerforceJob>> getCurrentListJobs() {
        Map<ConnectionKey, List<PerforceJob>> data = this.myCurrent.hasDefaultName() ? this.myVcs.getDefaultAssociated() : this.myCache.get(this.myCurrent);
        return data;
    }

    @Override
    public void removeSelectedJobs() {
        List<PerforceJob> jobs = this.myDetails.getSelectedJobs();
        if (jobs.isEmpty()) {
            return;
        }
        this.myDetails.removeSelectedJobs();
        Map<ConnectionKey, List<PerforceJob>> data = this.getCurrentListJobs();
        if (data != null) {
            for (PerforceJob job : jobs) {
                data.get(job.getConnectionKey()).remove(job);
            }
            this.setItems(ContainerUtil.flatten(data.values()));
        }
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction("Unlink selected job", "Unlink selected job", PlatformIcons.DELETE_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (PerforceJob job : PerforceCheckinComponent.this.myDetails.getSelectedJobs()) {
                    VcsException vcsException = PerforceCheckinComponent.this.myAdderRemover.remove(job, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myProject);
                    if (vcsException == null) continue;
                    new ErrorReporter("removing job from changelist").report(PerforceCheckinComponent.this.myProject, vcsException);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(!PerforceCheckinComponent.this.myDetails.getSelectedJobs().isEmpty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        group.add(new AnAction("Edit Associated Jobs", "Edit Associated Jobs", AllIcons.Actions.EditSource){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Map data;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((data = PerforceCheckinComponent.this.getCurrentListJobs()) == null) {
                    return;
                }
                PerforceCheckinComponent.this.ensureDefaultConnections();
                EditChangelistJobsDialog dialog = new EditChangelistJobsDialog(PerforceCheckinComponent.this.myProject, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myCurrent.hasDefaultName(), PerforceCheckinComponent.this.myConnMap, data);
                dialog.show();
                Map<ConnectionKey, List<PerforceJob>> jobs = dialog.getJobs();
                PerforceCheckinComponent.this.saveJobsInCache(jobs);
                PerforceCheckinComponent.this.setItems(ContainerUtil.flatten(jobs.values()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/perforce/perforce/jobs/PerforceCheckinComponent$3", "actionPerformed"));
            }
        });
        group.add((AnAction)new MyTextFieldAction("Search in Job View", "Search in Job View", IconUtil.getAddIcon()));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PerforceCheckIn", (ActionGroup)group, true);
        return actionToolbar.getComponent();
    }

    @Nullable(value="if canceled")
    public static List<PerforceJob> getJobsUnderProgress(JobsWorker worker, JobsSearchSpecificator searchSpecificator, P4Connection connection, ConnectionKey key, PerforceJobSpecification spec) {
        try {
            return (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> worker.getJobs(spec, searchSpecificator, connection, key), "Searching for jobs", true, worker.getProject());
        }
        catch (VcsException e1) {
            new ErrorReporter("searching for jobs to add").report(worker.getProject(), e1);
            return null;
        }
    }

    private void initUI() {
        this.myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.insets = new Insets(0, 0, 0, 0);
        gb.anchor = 17;
        JLabel jobsPrompt = new JLabel("Jobs:");
        gb.gridwidth = 3;
        this.myPanel.add((Component)jobsPrompt, gb);
        ++gb.gridy;
        gb.fill = 2;
        this.myPanel.add((Component)this.createToolbar(), gb);
        ++gb.gridy;
        gb.fill = 1;
        JComponent comp = this.myDetails.createComponent();
        this.myPanel.add((Component)comp, gb);
    }

    private void saveJobsInCache(Map<ConnectionKey, List<PerforceJob>> jobs) {
        if (this.myCurrent.hasDefaultName()) {
            this.myVcs.setDefaultAssociated(jobs);
        } else {
            this.myCache.put(this.myCurrent, jobs);
        }
    }

    private JPanel createSouthPanel(final TableView<PerforceJob> table, String warningText) {
        final JPanel southPanel = new JPanel(new BorderLayout());
        final JPanel stuffPanel = new JPanel(new BorderLayout());
        if (warningText != null) {
            stuffPanel.setPreferredSize((Dimension)JBUI.size((int)300, (int)120));
            southPanel.add((Component)stuffPanel, "North");
            JLabel warningLabel = new JLabel(warningText);
            warningLabel.setFont(warningLabel.getFont().deriveFont(1));
            southPanel.add((Component)warningLabel, "South");
        } else {
            southPanel.add(stuffPanel);
        }
        southPanel.setPreferredSize((Dimension)JBUI.size((int)300, (int)140));
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PerforceJob job = (PerforceJob)table.getSelectedObject();
                if (job == null) {
                    stuffPanel.removeAll();
                } else {
                    SelfLoadingJobDetailsPanel panel = new SelfLoadingJobDetailsPanel(PerforceCheckinComponent.this.myProject, job);
                    stuffPanel.removeAll();
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel.getPanel());
                    stuffPanel.add(scrollPane);
                }
                southPanel.revalidate();
                southPanel.repaint();
            }
        });
        return southPanel;
    }

    private void showListPopup(List<PerforceJob> jobs, Component component, Consumer<PerforceJob> consumer, int maxCount) {
        List<PerforceJob> jobsNarrowed = jobs.size() > maxCount ? jobs.subList(0, maxCount) : jobs;
        TableView table = new TableView(new ListTableModel(columns, jobsNarrowed, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable = () -> {
            PerforceJob job = (PerforceJob)table.getSelectedObject();
            if (job != null) {
                consumer.consume((Object)job);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        table.setMinimumSize((Dimension)JBUI.size((int)300, (int)50));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)table);
        builder.setSouthComponent((JComponent)this.createSouthPanel((TableView<PerforceJob>)table, jobs.size() > maxCount ? PerforceBundle.message((String)"perforce.jobs.search.limit.exceeded.warning", (Object[])new Object[]{maxCount}) : null));
        builder.setTitle(PerforceBundle.message((String)"perforce.jobs.select.one", (Object[])new Object[0])).setItemChoosenCallback(runnable).setResizable(true).setDimensionServiceKey("org.jetbrains.idea.perforce.perforce.jobs.PerforceCheckinComponent.SelectOneJob").setMinSize((Dimension)JBUI.size((int)300, (int)300));
        JBPopup popup2 = builder.createPopup();
        popup2.showUnderneathOf(component);
    }

    private void ensureDefaultConnections() {
        if (this.myCurrent.hasDefaultName()) {
            JobDetailsLoader loader = new JobDetailsLoader(this.myProject);
            loader.fillConnections(this.myCurrent, this.myConnMap);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void refresh() {
    }

    public void saveState() {
        if (this.myCurrent != null && this.myCurrent.hasDefaultName()) {
            this.keepDefaultListJobs();
        }
        this.refreshAdditionalDataForConsumer();
    }

    public void restoreState() {
    }

    public void onChangeListSelected(LocalChangeList list) {
        if (!Comparing.equal((Object)list, (Object)this.myCurrent)) {
            if (list != null && !list.hasDefaultName() && this.myCurrent != null && this.myCurrent.hasDefaultName()) {
                this.keepDefaultListJobs();
            }
            this.myCurrent = list;
            if (this.myCurrent == null) {
                this.setItems(Collections.emptyList());
            } else {
                Map<ConnectionKey, List<PerforceJob>> data;
                if (this.myCurrent.hasDefaultName()) {
                    this.correctDefaultAssociated(list);
                    data = this.myVcs.getDefaultAssociated();
                    ArrayList<PerforceJob> filtered = new ArrayList<PerforceJob>();
                    for (Map.Entry<ConnectionKey, List<PerforceJob>> entry : data.entrySet()) {
                        filtered.addAll((Collection<PerforceJob>)entry.getValue());
                    }
                    this.setItems(filtered);
                } else {
                    data = this.myCache.get(this.myCurrent);
                    if (data == null) {
                        data = this.loadOnSelect(this.myCurrent);
                        this.myCache.put(list, data);
                    }
                    this.setItems(ContainerUtil.flatten(data.values()));
                }
                this.refreshAdditionalDataForConsumerImpl(data);
            }
        }
    }

    private void refreshAdditionalDataForConsumerImpl(Map<ConnectionKey, List<PerforceJob>> data) {
        this.myAdditionalDataConsumer.consume((Object)"perforce_linked_jobs", data == null ? null : ContainerUtil.flatten(data.values()));
    }

    public void refreshAdditionalDataForConsumer() {
        Map<ConnectionKey, List<PerforceJob>> data = this.getCurrentListJobs();
        this.refreshAdditionalDataForConsumerImpl(data);
    }

    private void correctDefaultAssociated(LocalChangeList defaultList) {
        Map<ConnectionKey, List<PerforceJob>> data = this.myVcs.getDefaultAssociated();
        Map<ConnectionKey, P4Connection> map = ConnectionSelector.getConnections(this.myProject, defaultList);
        HashMap<ConnectionKey, List<PerforceJob>> filtered = new HashMap<ConnectionKey, List<PerforceJob>>();
        for (Map.Entry<ConnectionKey, List<PerforceJob>> entry : data.entrySet()) {
            if (!map.containsKey(entry.getKey())) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        this.myVcs.setDefaultAssociated(filtered);
    }

    private void keepDefaultListJobs() {
        List<PerforceJob> perforceJobs = this.myDetails.getJobs();
        HashMap<ConnectionKey, List<PerforceJob>> jobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        for (PerforceJob job : perforceJobs) {
            ArrayList<PerforceJob> oldList = (ArrayList<PerforceJob>)jobs.get(job.getConnectionKey());
            if (oldList == null) {
                oldList = new ArrayList<PerforceJob>();
                jobs.put(job.getConnectionKey(), oldList);
            }
            oldList.add(job);
        }
        this.myVcs.setDefaultAssociated(jobs);
    }

    private Map<ConnectionKey, List<PerforceJob>> loadOnSelect(LocalChangeList list) {
        JobDetailsLoader loader = new JobDetailsLoader(this.myProject);
        HashMap<ConnectionKey, List<PerforceJob>> perforceJobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        loader.loadJobsForList(list, this.myConnMap, perforceJobs);
        return perforceJobs;
    }

    private void setItems(List<PerforceJob> items) {
        this.myDetails.fillTree(items, items.isEmpty() ? null : items.get(0));
    }

    private class MyTextFieldAction
    extends TextFieldAction {
        private MyTextFieldAction(String text, String description, Icon icon) {
            super(text, description, icon, 20);
        }

        public void perform() {
            this.searchByJobviewAndFilter();
        }

        private void searchByJobviewAndFilter() {
            String text = this.myField.getText().trim();
            if (text.length() > 0) {
                PerforceCheckinComponent.this.ensureDefaultConnections();
                if (PerforceCheckinComponent.this.myCurrent != null) {
                    Map<ConnectionKey, P4Connection> p4ConnectionMap = ConnectionSelector.getConnections(PerforceCheckinComponent.this.myProject, PerforceCheckinComponent.this.myCurrent);
                    if (p4ConnectionMap.isEmpty()) {
                        return;
                    }
                    if (p4ConnectionMap.size() == 1) {
                        ConnectionKey key = p4ConnectionMap.keySet().iterator().next();
                        Pair pair = Pair.create((Object)key, (Object)p4ConnectionMap.get(key));
                        this.addImpl(text, (Pair<ConnectionKey, P4Connection>)pair);
                    } else {
                        ConnectionSelector.selectConnection(p4ConnectionMap, (Consumer<ConnectionKey>)((Consumer)connectionKey -> {
                            if (connectionKey != null) {
                                this.addImpl(text, (Pair<ConnectionKey, P4Connection>)Pair.create((Object)connectionKey, p4ConnectionMap.get(connectionKey)));
                            }
                        }));
                    }
                }
            }
        }

        private void addImpl(String text, Pair<ConnectionKey, P4Connection> pair) {
            P4JobsLogicConn connMap;
            if (pair != null && (connMap = (P4JobsLogicConn)PerforceCheckinComponent.this.myConnMap.get(pair.getFirst())) != null) {
                PerforceJobSpecification spec;
                ConnectionKey key;
                P4Connection connection;
                JobViewSearchSpecificator searchSpecificator;
                JobsWorker worker = new JobsWorker(PerforceCheckinComponent.this.myProject);
                List<PerforceJob> jobs = PerforceCheckinComponent.getJobsUnderProgress(worker, searchSpecificator = new JobViewSearchSpecificator(connMap.getJobView(), text), connection = (P4Connection)pair.getSecond(), key = (ConnectionKey)pair.getFirst(), spec = connMap.getSpec());
                if (jobs == null) {
                    return;
                }
                if (jobs.isEmpty()) {
                    Messages.showMessageDialog((Project)PerforceCheckinComponent.this.myProject, (String)"There are no jobs matching pattern", (String)"Add Perforce Job", (Icon)Messages.getInformationIcon());
                    return;
                }
                Consumer consumer = perforceJob -> {
                    PerforceCheckinComponent.this.myAdderRemover.add((PerforceJob)perforceJob, PerforceCheckinComponent.this.myCurrent, PerforceCheckinComponent.this.myProject);
                    this.myField.setText("");
                };
                if (jobs.size() > 1) {
                    PerforceCheckinComponent.this.showListPopup(jobs, this.myField, (Consumer<PerforceJob>)consumer, searchSpecificator.getMaxCount());
                } else {
                    consumer.consume((Object)jobs.get(0));
                }
            }
        }
    }
}

