/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.BaselinePanel;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.LineFunction;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPluginComponent
extends CellPluginComponent {
    private final MyPluginModel myPluginModel;
    private boolean myUninstalled;
    private JLabel myVersion;
    private JLabel myLastUpdated;
    public JButton myUpdateButton;
    private final JCheckBox myEnableDisableButton;
    private RestartButton myRestartButton;
    private final BaselinePanel myBaselinePanel;
    private ProgressIndicatorEx myIndicator;

    public ListPluginComponent(@NotNull MyPluginModel pluginModel, @NotNull IdeaPluginDescriptor plugin, boolean pluginForUpdate) {
        if (pluginModel == null) {
            ListPluginComponent.$$$reportNull$$$0(0);
        }
        if (plugin == null) {
            ListPluginComponent.$$$reportNull$$$0(1);
        }
        super(plugin);
        this.myEnableDisableButton = new JCheckBox();
        this.myBaselinePanel = new BaselinePanel();
        this.myPluginModel = pluginModel;
        pluginModel.addComponent(this);
        this.setFocusable(true);
        this.myEnableDisableButton.setFocusable(false);
        this.setOpaque(true);
        this.setLayout(new BorderLayout(JBUI.scale((int)8), 0));
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
        this.createButtons(pluginForUpdate);
        if (pluginForUpdate) {
            this.addIconComponent(this, "West");
        } else {
            NonOpaquePanel westPanel = new NonOpaquePanel((LayoutManager)ListPluginComponent.createCheckboxIconLayout());
            westPanel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            westPanel.add(this.myEnableDisableButton);
            this.addIconComponent((JPanel)westPanel, null);
            this.add((Component)westPanel, "West");
        }
        NonOpaquePanel centerPanel = new NonOpaquePanel((LayoutManager)((Object)new VerticalLayout(0)));
        this.add((Component)centerPanel);
        centerPanel.add((Component)((Object)this.myBaselinePanel), "fill_h");
        this.addNameComponent((JPanel)((Object)this.myBaselinePanel));
        this.myName.setVerticalAlignment(1);
        if (pluginForUpdate) {
            this.createVersion();
        }
        this.updateErrors();
        if (!pluginForUpdate) {
            this.addDescriptionComponent((JPanel)centerPanel, PluginManagerConfigurableNew.getShortDescription(plugin, false), new LineFunction(1, true));
        }
        if (MyPluginModel.isInstallingOrUpdate(plugin)) {
            this.showProgress(false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    private void createButtons(boolean update) {
        this.myEnableDisableButton.setOpaque(false);
        if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted()) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myRestartButton.setFocusable(false);
            this.myBaselinePanel.addButtonComponent(this.myRestartButton);
            this.myEnableDisableButton.setSelected(false);
            this.myEnableDisableButton.setEnabled(false);
            this.myEnableDisableButton.setVisible(false);
            this.myUninstalled = true;
        } else {
            PluginId id;
            InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
            if (pluginsState.wasInstalled(id = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id)) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myRestartButton.setFocusable(false);
                this.myBaselinePanel.addButtonComponent(this.myRestartButton);
            } else if (update) {
                this.myUpdateButton = new UpdateButton();
                this.myUpdateButton.setFocusable(false);
                this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, false));
                this.myBaselinePanel.addButtonComponent(this.myUpdateButton);
            }
            this.myEnableDisableButton.setSelected(this.isEnabledState());
            this.myEnableDisableButton.addActionListener(e -> this.myPluginModel.changeEnableDisable(this.myPlugin));
        }
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        this.myEnableDisableButton.setSelected(false);
        this.myEnableDisableButton.setEnabled(false);
        OneLineProgressIndicator indicator = new OneLineProgressIndicator();
        indicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false, false));
        this.myBaselinePanel.setProgressComponent(this, indicator.createBaselineWrapper());
        this.myPluginModel.addProgress(this.myPlugin, indicator);
        this.myIndicator = indicator;
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress(boolean success2) {
        this.myIndicator = null;
        this.myEnableDisableButton.setEnabled(true);
        this.myBaselinePanel.removeProgressComponent();
        if (success2) {
            this.changeUpdateToRestart();
        }
        this.fullRepaint();
    }

    public void clearProgress() {
        this.myIndicator = null;
    }

    @NotNull
    private static AbstractLayoutManager createCheckboxIconLayout() {
        AbstractLayoutManager abstractLayoutManager = new AbstractLayoutManager(){
            JBValue offset = new JBValue.Float(12.0f);

            public Dimension preferredLayoutSize(Container parent) {
                Dimension size = new Dimension();
                if (parent.getComponentCount() == 2) {
                    Dimension iconSize = parent.getComponent(1).getPreferredSize();
                    size.width = parent.getComponent((int)0).getPreferredSize().width + this.offset.get() + iconSize.width;
                    size.height = iconSize.height;
                }
                JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
                return size;
            }

            public void layoutContainer(Container parent) {
                if (parent.getComponentCount() == 2) {
                    Component checkBox2 = parent.getComponent(0);
                    Component icon = parent.getComponent(1);
                    Dimension checkBoxSize = checkBox2.getPreferredSize();
                    Dimension iconSize = icon.getPreferredSize();
                    Insets insets = parent.getInsets();
                    int x = insets.left;
                    int y = insets.top;
                    checkBox2.setBounds(x, y + (iconSize.height - checkBoxSize.height) / 2, checkBoxSize.width, checkBoxSize.height);
                    icon.setBounds(x + checkBoxSize.width + this.offset.get(), y, iconSize.width, iconSize.height);
                }
            }
        };
        if (abstractLayoutManager == null) {
            ListPluginComponent.$$$reportNull$$$0(2);
        }
        return abstractLayoutManager;
    }

    private void createVersion() {
        String date;
        String version = StringUtil.defaultIfEmpty((String)this.myPlugin.getVersion(), null);
        if (version != null) {
            this.myVersion = new JLabel("Version " + version);
            this.myVersion.setOpaque(false);
            this.myBaselinePanel.addVersionComponent(PluginManagerConfigurableNew.installTiny(this.myVersion));
        }
        if (this.myPlugin instanceof PluginNode && (date = PluginManagerConfigurableNew.getLastUpdatedDate(this.myPlugin)) != null) {
            this.myLastUpdated = new JLabel(date, AllIcons.Plugins.Updated, 0);
            this.myLastUpdated.setOpaque(false);
            this.myBaselinePanel.addVersionComponent(PluginManagerConfigurableNew.installTiny(this.myLastUpdated));
        }
    }

    public void updateErrors() {
        boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
        this.updateIcon(errors, this.myUninstalled || !this.myPluginModel.isEnabled(this.myPlugin));
        if (errors) {
            Ref enableAction = new Ref();
            String message = PluginManagerConfigurableNew.getErrorMessage(this.myPluginModel, (PluginDescriptor)this.myPlugin, (Ref<? super Boolean>)enableAction);
            this.myBaselinePanel.addErrorComponents(message, !enableAction.isNull(), () -> this.myPluginModel.enableRequiredPlugins(this.myPlugin));
        } else {
            this.myBaselinePanel.removeErrorComponents();
        }
    }

    @Override
    public void setListeners(@NotNull LinkListener<IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
        if (listener2 == null) {
            ListPluginComponent.$$$reportNull$$$0(3);
        }
        if (searchListener == null) {
            ListPluginComponent.$$$reportNull$$$0(4);
        }
        if (eventHandler == null) {
            ListPluginComponent.$$$reportNull$$$0(5);
        }
        super.setListeners(listener2, searchListener, eventHandler);
        eventHandler.addAll(this);
        this.myBaselinePanel.setListeners(eventHandler);
    }

    @Override
    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        if (grayedFg == null) {
            ListPluginComponent.$$$reportNull$$$0(6);
        }
        if (background == null) {
            ListPluginComponent.$$$reportNull$$$0(7);
        }
        super.updateColors(grayedFg, background);
        if (this.myVersion != null) {
            this.myVersion.setForeground(grayedFg);
        }
        if (this.myLastUpdated != null) {
            this.myLastUpdated.setForeground(grayedFg);
        }
        boolean enabled = !this.myUninstalled && (MyPluginModel.isInstallingOrUpdate(this.myPlugin) || this.myPluginModel.isEnabled(this.myPlugin));
        this.myName.setForeground(enabled ? null : PluginManagerConfigurableNew.DisabledColor);
        if (this.myDescription != null) {
            this.myDescription.setForeground(enabled ? grayedFg : PluginManagerConfigurableNew.DisabledColor);
        }
    }

    public boolean isEnabledState() {
        return this.myPluginModel.isEnabled(this.myPlugin);
    }

    public void updateAfterUninstall() {
        this.myUninstalled = true;
        this.updateColors(this.mySelection);
        this.myEnableDisableButton.setSelected(false);
        this.myEnableDisableButton.setEnabled(false);
        this.myEnableDisableButton.setVisible(false);
        this.changeUpdateToRestart();
    }

    public void changeUpdateToRestart() {
        boolean layout = false;
        if (this.myUpdateButton != null) {
            this.myBaselinePanel.removeButtonComponent(this.myUpdateButton);
            this.myUpdateButton = null;
            layout = true;
        }
        if (this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myRestartButton.setFocusable(false);
            this.myBaselinePanel.addButtonComponent(this.myRestartButton);
            layout = true;
        }
        if (layout) {
            this.myBaselinePanel.doLayout();
        }
    }

    public void updateEnabledState() {
        if (!this.myUninstalled) {
            this.myEnableDisableButton.setSelected(this.isEnabledState());
        }
        this.updateErrors();
        this.setSelection(this.mySelection, false);
    }

    public void updatePlugin() {
        if (this.myUpdateButton != null) {
            this.myUpdateButton.doClick();
        }
    }

    @Override
    public void createPopupMenu(@NotNull DefaultActionGroup group, final @NotNull List<CellPluginComponent> selection) {
        if (group == null) {
            ListPluginComponent.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(9);
        }
        for (CellPluginComponent cellPluginComponent : selection) {
            if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
            return;
        }
        boolean restart = true;
        for (CellPluginComponent component : selection) {
            if (((ListPluginComponent)component).myRestartButton != null) continue;
            restart = false;
            break;
        }
        if (restart) {
            group.add((AnAction)new ButtonAnAction(((ListPluginComponent)selection.get((int)0)).myRestartButton));
            return;
        }
        int n = selection.size();
        JButton[] updateButtons = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JButton button = ((ListPluginComponent)selection.get((int)i)).myUpdateButton;
            if (button == null) {
                updateButtons = null;
                break;
            }
            updateButtons[i] = button;
        }
        if (updateButtons != null) {
            group.add((AnAction)new ButtonAnAction(updateButtons));
            return;
        }
        final Pair<Boolean, IdeaPluginDescriptor[]> result2 = ListPluginComponent.getSelectionNewState(selection);
        group.add((AnAction)new MyAnAction((Boolean)result2.first != false ? "Enable" : "Disable", null, 32){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ListPluginComponent.this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])result2.second, (Boolean)result2.first);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ListPluginComponent$2", "actionPerformed"));
            }
        });
        for (CellPluginComponent component : selection) {
            if (!((ListPluginComponent)component).myUninstalled && !component.myPlugin.isBundled()) continue;
            return;
        }
        group.addSeparator();
        group.add((AnAction)new MyAnAction("Uninstall", "EditorDelete", EventHandler.DELETE_CODE){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!ListPluginComponent.this.myPluginModel.showUninstallDialog(selection)) {
                    return;
                }
                for (CellPluginComponent component : selection) {
                    ListPluginComponent.this.myPluginModel.doUninstall(component, component.myPlugin, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ListPluginComponent$3", "actionPerformed"));
            }
        });
    }

    @Override
    public void handleKeyAction(int keyCode, @NotNull List<CellPluginComponent> selection) {
        block16: {
            boolean bl;
            boolean restart;
            block14: {
                block15: {
                    if (selection == null) {
                        ListPluginComponent.$$$reportNull$$$0(10);
                    }
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
                        return;
                    }
                    restart = true;
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (((ListPluginComponent)cellPluginComponent).myRestartButton != null) continue;
                        restart = false;
                        break;
                    }
                    boolean bl2 = true;
                    for (CellPluginComponent component : selection) {
                        if (((ListPluginComponent)component).myUpdateButton != null) continue;
                        bl = false;
                        break;
                    }
                    if (keyCode != 10) break block14;
                    if (!restart) break block15;
                    ((ListPluginComponent)selection.get((int)0)).myRestartButton.doClick();
                    break block16;
                }
                if (!bl) break block16;
                for (CellPluginComponent component : selection) {
                    ((ListPluginComponent)component).myUpdateButton.doClick();
                }
                break block16;
            }
            if (!restart && !bl) {
                if (keyCode == 32) {
                    if (selection.size() == 1) {
                        this.myPluginModel.changeEnableDisable(selection.get((int)0).myPlugin);
                    } else {
                        Pair<Boolean, IdeaPluginDescriptor[]> pair = ListPluginComponent.getSelectionNewState(selection);
                        this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])pair.second, (Boolean)pair.first);
                    }
                } else if (keyCode == EventHandler.DELETE_CODE) {
                    for (CellPluginComponent component : selection) {
                        if (!((ListPluginComponent)component).myUninstalled && !component.myPlugin.isBundled()) continue;
                        return;
                    }
                    if (!this.myPluginModel.showUninstallDialog(selection)) {
                        return;
                    }
                    for (CellPluginComponent component : selection) {
                        this.myPluginModel.doUninstall(this, component.myPlugin, null);
                    }
                }
            }
        }
    }

    @NotNull
    private static Pair<Boolean, IdeaPluginDescriptor[]> getSelectionNewState(@NotNull List<CellPluginComponent> selection) {
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(11);
        }
        boolean state = ((ListPluginComponent)selection.get(0)).isEnabledState();
        boolean setTrue = false;
        ListIterator<CellPluginComponent> I = selection.listIterator(1);
        while (I.hasNext()) {
            if (state == ((ListPluginComponent)I.next()).isEnabledState()) continue;
            setTrue = true;
            break;
        }
        int size = selection.size();
        IdeaPluginDescriptor[] plugins2 = new IdeaPluginDescriptor[size];
        for (int i = 0; i < size; ++i) {
            plugins2[i] = selection.get((int)i).myPlugin;
        }
        Pair pair = Pair.create((Object)(setTrue || !state ? 1 : 0), (Object)plugins2);
        if (pair == null) {
            ListPluginComponent.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @Override
    public void close() {
        if (this.myIndicator != null) {
            this.myPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckboxIconLayout";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNewState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionNewState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyAnAction
    extends DumbAwareAction {
        MyAnAction(@Nullable String text, @Nullable String actionId, int keyCode) {
            super(text);
            ShortcutSet shortcutSet = null;
            if (actionId != null) {
                shortcutSet = EventHandler.getShortcuts(actionId);
            }
            if (shortcutSet == null) {
                shortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, 0));
            }
            this.setShortcutSet(shortcutSet);
        }
    }

    private static class ButtonAnAction
    extends DumbAwareAction {
        private final JButton[] myButtons;

        ButtonAnAction(JButton ... buttons) {
            if (buttons == null) {
                ButtonAnAction.$$$reportNull$$$0(0);
            }
            super(buttons[0].getText());
            this.myButtons = buttons;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAnAction.$$$reportNull$$$0(1);
            }
            for (JButton button : this.myButtons) {
                button.doClick();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttons";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$ButtonAnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

