/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.PressureEvent;
import com.apple.eawt.event.PressureListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MacGestureSupportForEditor {
    private final ArrayList<AnAction> myActions = new ArrayList(1);
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public MacGestureSupportForEditor(final JComponent component) {
        GestureUtilities.addGestureListenerTo((JComponent)component, (GestureListener)new PressureListener(){

            public void pressure(PressureEvent e) {
                if (IdeMouseEventDispatcher.isForceTouchAllowed() && e.getStage() == 2.0) {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MacGestureSupportForEditor.this.handleMouseShortcut(e, (MouseShortcut)new PressureShortcut(e.getStage()), component));
                }
            }
        });
    }

    private void handleMouseShortcut(PressureEvent e, MouseShortcut shortcut, JComponent component) {
        this.fillActionsList(shortcut, IdeKeyEventDispatcher.isModalContext(component));
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (actionManager != null) {
            AnAction[] actions;
            for (AnAction action : actions = this.myActions.toArray(AnAction.EMPTY_ARRAY)) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
                Presentation presentation = this.myPresentationFactory.getPresentation(action);
                AnActionEvent actionEvent = new AnActionEvent(null, dataContext, "MainMenu", presentation, ActionManager.getInstance(), 0);
                action.beforeActionPerformedUpdate(actionEvent);
                if (!presentation.isEnabled()) continue;
                actionManager.fireBeforeActionPerformed(action, dataContext, actionEvent);
                Component context = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (context != null && !context.isShowing()) continue;
                action.actionPerformed(actionEvent);
            }
        }
        e.consume();
        IdeMouseEventDispatcher.forbidForceTouch();
    }

    private void fillActionsList(MouseShortcut mouseShortcut, boolean isModalContext) {
        KeymapManager keymapManager2;
        this.myActions.clear();
        if (KeymapManagerImpl.ourKeymapManagerInitialized && (keymapManager2 = KeymapManager.getInstance()) != null) {
            Keymap keymap = keymapManager2.getActiveKeymap();
            String[] actionIds = keymap.getActionIds(mouseShortcut);
            ActionManager actionManager = ActionManager.getInstance();
            for (String actionId : actionIds) {
                AnAction action = actionManager.getAction(actionId);
                if (action == null || isModalContext && !action.isEnabledInModalContext() || this.myActions.contains(action)) continue;
                this.myActions.add(action);
            }
        }
    }
}

