/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsStatisticsCollectorKt;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager {
    private static final Logger LOG = Logger.getInstance(XBreakpointManagerImpl.class);
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTER = new SkipDefaultValuesSerializationFilters();
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, XBreakpointBase<?, ?, ?>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new HashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private final EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;
    private RemovedBreakpointData myLastRemovedBreakpoint = null;

    public XBreakpointManagerImpl(Project project, XDebuggerManagerImpl debuggerManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project, this.myDependentBreakpointManager);
        if (!project.isDefault()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HttpFileSystem.getInstance().addFileListener(this::updateBreakpointInFile, (Disposable)project);
            }
            XBreakpointUtil.breakpointTypes().forEach(this::addDefaultBreakpoint);
        }
        this.myProject.getMessageBus().connect().subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener(){

            public void breakpointAdded(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointAdded(breakpoint);
            }

            public void breakpointRemoved(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointRemoved(breakpoint);
            }

            public void breakpointChanged(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(2);
                }
                ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointChanged(breakpoint);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "breakpoint";
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateBreakpointInFile(VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (XBreakpointBase<?, ?, ?> breakpoint : this.getAllBreakpoints()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                this.fireBreakpointChanged(breakpoint);
            }
        });
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type, properties, true, false);
        this.addBreakpoint(breakpoint, false, true);
        XBreakpointBase<?, T, ?> xBreakpointBase = breakpoint;
        if (xBreakpointBase == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(0);
        }
        return xBreakpointBase;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        BreakpointState state = new BreakpointState(enabled, type.getId(), defaultBreakpoint ? 0L : (this.myTime = this.myTime + 1L), type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults(type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type, this, properties, state);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type = breakpoint.getType();
        if (defaultBreakpoint) {
            LOG.assertTrue(!this.myDefaultBreakpoints.containsKey(type), (Object)("Cannot have more than one default breakpoint (type " + type.getId() + ")"));
            this.myDefaultBreakpoints.put(type, breakpoint);
        } else {
            this.myBreakpoints.put(type, breakpoint);
            if (initUI) {
                BreakpointsUsageCollector.reportUsage(breakpoint, "new.breakpoint");
                BreakpointsUsageCollector.reportUsage(breakpoint, "new." + BreakpointsStatisticsCollectorKt.getReportableTypeId(type));
                if (this.myDebuggerManager.getCurrentSession() != null) {
                    BreakpointsUsageCollector.reportUsage(breakpoint, "new.within.session");
                }
            }
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    @NotNull
    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        XBreakpointListener xBreakpointListener = (XBreakpointListener)this.myProject.getMessageBus().syncPublisher(XBreakpointListener.TOPIC);
        if (xBreakpointListener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(1);
        }
        return xBreakpointListener;
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            XBreakpointType type = breakpoint.getType();
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
            this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
            this.myAllBreakpoints.remove(breakpointBase);
            if (breakpointBase instanceof XLineBreakpointImpl) {
                this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
            }
            breakpointBase.dispose();
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
            if (dispatcher != null) {
                ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
            }
            this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(3);
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line, properties, false);
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(4);
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state = new LineBreakpointState(true, type.getId(), fileUrl, line, temporary, ++this.myTime, type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, properties, state);
        this.addBreakpoint(breakpoint, false, true);
        XLineBreakpointImpl<T> xLineBreakpointImpl = breakpoint;
        if (xLineBreakpointImpl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(6);
        }
        return xLineBreakpointImpl;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XBreakpointBase[] xBreakpointBaseArray = this.myAllBreakpoints.toArray(new XBreakpointBase[0]);
        if (xBreakpointBaseArray == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(7);
        }
        return xBreakpointBaseArray;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        Collection breakpoints;
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<B> result2 = new ArrayList<B>();
        B defaultBreakpoint = this.getDefaultBreakpoint(type);
        if (defaultBreakpoint != null) {
            result2.add(defaultBreakpoint);
        }
        if ((breakpoints = this.myBreakpoints.get(type)) != null) {
            result2.addAll(breakpoints);
        }
        List list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type;
        if (typeClass == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue((type = XDebuggerUtil.getInstance().findBreakpointType(typeClass)) != null, (Object)("Unregistered breakpoint type " + typeClass + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        Collection<B> collection = this.getBreakpoints(type);
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(12);
        }
        return (B)this.myDefaultBreakpoints.get(type);
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file2.getUrl()) || lineBreakpoint.getLine() != line) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(15);
        }
        return this.myDefaultBreakpoints.values().contains(breakpoint);
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        return this.myDispatchers.computeIfAbsent(type, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(16);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(17);
        }
        this.getOrCreateDispatcher(type).addListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(18);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(19);
        }
        this.getOrCreateDispatcher(type).removeListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2, Disposable parentDisposable) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(20);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(21);
        }
        this.getOrCreateDispatcher(type).addListener(listener2, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(22);
        }
        if (parentDisposable == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(23);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(XBreakpointListener.TOPIC, listener2);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(24);
        }
        this.myAllBreakpointsDispatcher.addListener(listener2);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(25);
        }
        this.myAllBreakpointsDispatcher.removeListener(listener2);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint;
        CustomizedBreakpointPresentation presentation;
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(26);
        }
        if ((presentation = (lineBreakpoint = (XLineBreakpointImpl)breakpoint).getCustomizedPresentation()) == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    @NotNull
    public BreakpointManagerState saveState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(27);
        }
        this.myDependentBreakpointManager.saveState();
        SmartList defaultBreakpoints = new SmartList();
        for (XBreakpointBase<?, ?, ?> xBreakpointBase : this.myDefaultBreakpoints.values()) {
            Object breakpointState = xBreakpointBase.getState();
            if (!this.differsFromDefault((XBreakpointType)xBreakpointBase.getType(), (BreakpointState)breakpointState)) continue;
            defaultBreakpoints.add(breakpointState);
        }
        SmartList breakpoints = new SmartList();
        for (XBreakpointBase breakpoint : this.myBreakpoints.values()) {
            breakpoints.add(breakpoint.getState());
        }
        SmartList smartList = new SmartList();
        for (Map.Entry<XBreakpointType, BreakpointState<?, ?, ?>> entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent(entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults(entry.getKey()), false)) continue;
            smartList.add(entry.getValue());
        }
        state.setDefaultBreakpoints((List<BreakpointState<?, ?, ?>>)defaultBreakpoints);
        state.setBreakpoints((List<BreakpointState<?, ?, ?>>)breakpoints);
        state.setBreakpointsDefaults((List<BreakpointState<?, ?, ?>>)smartList);
        state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state.setDefaultGroup(this.myDefaultGroup);
        BreakpointManagerState breakpointManagerState = state;
        if (breakpointManagerState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(28);
        }
        return breakpointManagerState;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type, BreakpointState state) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultState, false);
    }

    public static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2, boolean ignoreTimestamp) {
        Element elem2;
        Element elem1;
        boolean res2;
        long timeStamp1 = state1.getTimeStamp();
        long timeStamp2 = state2.getTimeStamp();
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp2);
        }
        boolean bl = res2 = !JDOMUtil.areElementsEqual((Element)(elem1 = XmlSerializer.serialize((Object)state1, (SerializationFilter)SERIALIZATION_FILTER)), (Element)(elem2 = XmlSerializer.serialize((Object)state2, (SerializationFilter)SERIALIZATION_FILTER)));
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp1);
        }
        return res2;
    }

    public void loadState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(29);
        }
        this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (state == null) {
                XBreakpointManagerImpl.$$$reportNull$$$0(38);
            }
            ContainerUtil.notNullize(state.getDefaultBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)XBreakpointUtil.breakpointTypes().remove(this.myDefaultBreakpoints::containsKey)).forEach(this::addDefaultBreakpoint);
            this.myBreakpoints.values().forEach(this::doRemoveBreakpoint);
            ContainerUtil.notNullize(state.getBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState defaults : ContainerUtil.notNullize(state.getBreakpointsDefaults())) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        });
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myDefaultGroup = state.getDefaultGroup();
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(XBreakpointType<?, P> type) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type) {
        return type.createDefaultBreakpoint(properties -> this.createBreakpoint(type, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
        this.myTime = Math.max(this.myTime, breakpointState.getTimeStamp());
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        return StreamEx.of(this.myAllBreakpoints).map(XBreakpointBase::getGroup).nonNull().toSet();
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(30);
        }
        BreakpointState breakpointState = this.myBreakpointsDefaults.computeIfAbsent(type, k -> {
            if (type == null) {
                XBreakpointManagerImpl.$$$reportNull$$$0(37);
            }
            return XBreakpointManagerImpl.createBreakpointDefaults(type);
        });
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(31);
        }
        return breakpointState;
    }

    @Nullable
    <T extends XBreakpointProperties> XLineBreakpoint<T> copyLineBreakpoint(@NotNull XLineBreakpoint<T> source, @NotNull String fileUrl, int line) {
        if (source == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(32);
        }
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!(source instanceof XLineBreakpointImpl)) {
            return null;
        }
        this.myDependentBreakpointManager.saveState();
        LineBreakpointState sourceState = (LineBreakpointState)((XLineBreakpointImpl)source).getState();
        LineBreakpointState newState = (LineBreakpointState)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)sourceState, (SerializationFilter)SERIALIZATION_FILTER), LineBreakpointState.class);
        newState.setLine(line);
        newState.setFileUrl(fileUrl);
        XLineBreakpointImpl breakpoint = (XLineBreakpointImpl)this.createBreakpoint(newState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, false, true);
            XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)source);
            if (masterBreakpoint != null) {
                this.myDependentBreakpointManager.setMasterBreakpoint(breakpoint, masterBreakpoint, sourceState.getDependencyState().isLeaveEnabled());
            }
        }
        return breakpoint;
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(34);
        }
        BreakpointState state = new BreakpointState();
        state.setTypeId(type.getId());
        state.setSuspendPolicy(type.getDefaultSuspendPolicy());
        BreakpointState breakpointState = state;
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(35);
        }
        return breakpointState;
    }

    public void rememberRemovedBreakpoint(@NotNull XBreakpointBase breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(36);
        }
        this.myLastRemovedBreakpoint = new RemovedBreakpointData(breakpoint);
    }

    @Nullable
    public XBreakpointBase getLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null ? this.myLastRemovedBreakpoint.myBreakpoint : null;
    }

    @Nullable
    public XBreakpoint restoreLastRemovedBreakpoint() {
        if (this.myLastRemovedBreakpoint != null) {
            XBreakpoint breakpoint = this.myLastRemovedBreakpoint.restore();
            this.myLastRemovedBreakpoint = null;
            return breakpoint;
        }
        return null;
    }

    public boolean canRestoreLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null && this.myLastRemovedBreakpoint.isRestorable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 2: 
            case 15: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 27: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDispatcherMulticaster";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBreakpoints";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDefaults";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpoints";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreakpoint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointAtLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultBreakpoint";
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointListener";
                break;
            }
            case 18: 
            case 19: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointDefaults";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyLineBreakpoint";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointDefaults";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "rememberRemovedBreakpoint";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getBreakpointDefaults$6";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadState$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemovedBreakpointData {
        private final XBreakpointBase myBreakpoint;
        private final XDependentBreakpointManager.DependenciesData myDependenciesData;

        private RemovedBreakpointData(XBreakpointBase breakpoint) {
            if (breakpoint == null) {
                RemovedBreakpointData.$$$reportNull$$$0(0);
            }
            this.myBreakpoint = breakpoint;
            XDependentBreakpointManager xDependentBreakpointManager = XBreakpointManagerImpl.this.myDependentBreakpointManager;
            xDependentBreakpointManager.getClass();
            this.myDependenciesData = new XDependentBreakpointManager.DependenciesData(xDependentBreakpointManager, breakpoint);
        }

        boolean isRestorable() {
            return !(this.myBreakpoint instanceof XLineBreakpointImpl) || ((XLineBreakpointImpl)this.myBreakpoint).getFile() != null;
        }

        @Nullable
        XBreakpoint restore() {
            XBreakpointBase breakpoint;
            if (this.myBreakpoint instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)this.myBreakpoint;
                VirtualFile file2 = lineBreakpoint.getFile();
                if (file2 == null) {
                    return null;
                }
                XLineBreakpoint existingBreakpoint = XBreakpointManagerImpl.this.findBreakpointAtLine(lineBreakpoint.getType(), file2, lineBreakpoint.getLine());
                if (existingBreakpoint != null) {
                    XBreakpointManagerImpl.this.removeBreakpoint((XBreakpoint<?>)existingBreakpoint);
                }
            }
            if ((breakpoint = XBreakpointManagerImpl.this.createBreakpoint(this.myBreakpoint.getState())) != null) {
                XBreakpointManagerImpl.this.addBreakpoint(breakpoint, false, true);
                this.myDependenciesData.restore(breakpoint);
                return breakpoint;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$RemovedBreakpointData", "<init>"));
        }
    }
}

