/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJsStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(0);
        }
        NodeJsStartupActivity.reconfigureCodeLibraryIfNeeded(project);
    }

    private static void reconfigureCodeLibraryIfNeeded(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                NodeJsStartupActivity.$$$reportNull$$$0(21);
            }
            if (project.isDisposed()) {
                return;
            }
            List libraries = NodeCoreLibraryUtil.listOldLibraries((Project)project);
            if (!libraries.isEmpty()) {
                List<VirtualFile> roots = NodeJsStartupActivity.uniteScopes(project, libraries);
                NodeJsStartupActivity.doReconfigure(project, roots);
            } else {
                NodeJsStartupActivity.removeOldLibraryOrderEntries(project);
                NodeJsStartupActivity.reconfigureNodeCoreLibraryIfFilesMissing(project);
            }
        });
    }

    private static void reconfigureNodeCoreLibraryIfFilesMissing(@NotNull Project project) {
        NodeCoreLibraryConfigurator configurator;
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(2);
        }
        if (NodeJsStartupActivity.isNodeCoreReconfigurationNeeded(configurator = NodeCoreLibraryConfigurator.getInstance((Project)project))) {
            List roots = NodeCoreLibraryManager.getInstance((Project)project).getAssociatedRoots();
            NodeJsStartupActivity.doReconfigure(project, roots);
        }
    }

    private static boolean isNodeCoreReconfigurationNeeded(@NotNull NodeCoreLibraryConfigurator configurator) {
        String nodeVersionStr;
        if (configurator == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(nodeVersionStr = configurator.getConfiguredCoreLibraryVersionStr()))) {
            File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir((String)nodeVersionStr);
            File typingsDir = NodeCoreLibraryConfigurator.getTypingsDir((String)nodeVersionStr);
            return !coreModulesSrcDir.isDirectory() || !typingsDir.isDirectory();
        }
        return false;
    }

    private static void removeOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(4);
        }
        if (NodeJsStartupActivity.hasOldLibraryOrderEntries(project)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    NodeJsStartupActivity.$$$reportNull$$$0(19);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        NodeJsStartupActivity.$$$reportNull$$$0(20);
                    }
                    NodeJsStartupActivity.doRemoveOldLibraryOrderEntries(project);
                });
            }, ModalityState.NON_MODAL, project.getDisposed());
        }
    }

    private static boolean hasOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(5);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!NodeCoreLibraryUtil.isOldLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private static void doRemoveOldLibraryOrderEntries(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(6);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (!NodeCoreLibraryUtil.isOldLibraryOrderEntry((OrderEntry)orderEntry)) continue;
                    model.removeOrderEntry(orderEntry);
                }
            });
        }
    }

    private static void doReconfigure(@NotNull Project project, @NotNull List<VirtualFile> rootsToAssociateWith) {
        NodeJsInterpreter interpreter;
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(7);
        }
        if (rootsToAssociateWith == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(8);
        }
        if ((interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()) instanceof NodeJsLocalInterpreter) {
            interpreter.provideCachedVersionOrFetch(version -> {
                if (project == null) {
                    NodeJsStartupActivity.$$$reportNull$$$0(15);
                }
                if (rootsToAssociateWith == null) {
                    NodeJsStartupActivity.$$$reportNull$$$0(16);
                }
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            NodeJsStartupActivity.$$$reportNull$$$0(17);
                        }
                        if (rootsToAssociateWith == null) {
                            NodeJsStartupActivity.$$$reportNull$$$0(18);
                        }
                        NodeCoreLibraryConfigurator configurator = NodeCoreLibraryConfigurator.getInstance((Project)project);
                        configurator.configureAndAssociateWith(interpreter, version, rootsToAssociateWith, null);
                    }, ModalityState.NON_MODAL, project.getDisposed());
                }
            });
        }
    }

    @NotNull
    private static List<VirtualFile> uniteScopes(@NotNull Project project, @NotNull List<ScriptingLibraryModel> libraries) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(9);
        }
        if (libraries == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(10);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance((Project)project);
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (ScriptingLibraryModel library : libraries) {
            List files = mappings.getMappingsByLibraryName(library.getName());
            for (VirtualFile file : files) {
                if (file != null && !file.isValid()) continue;
                roots.add(file);
            }
        }
        for (VirtualFile root : roots) {
            if (root != null) continue;
            List<Object> list = Collections.singletonList(null);
            if (list == null) {
                NodeJsStartupActivity.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile root : roots) {
            if (NodeJsStartupActivity.isInScope(roots, root)) continue;
            result.add(root);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static boolean isInScope(@NotNull Set<VirtualFile> roots, @NotNull VirtualFile f) {
        if (roots == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(13);
        }
        if (f == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(14);
        }
        for (VirtualFile root : roots) {
            if (f.equals(root) || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)f, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 8: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/library/NodeJsStartupActivity";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/library/NodeJsStartupActivity";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reconfigureCodeLibraryIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reconfigureNodeCoreLibraryIfFilesMissing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNodeCoreReconfigurationNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeOldLibraryOrderEntries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasOldLibraryOrderEntries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveOldLibraryOrderEntries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doReconfigure";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doReconfigure$5";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeOldLibraryOrderEntries$2";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reconfigureCodeLibraryIfNeeded$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

