/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.console.ConsoleErrorProviderFactory;
import com.intellij.database.console.DialogVisibilityController;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionView;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.audit.JdbcConsoleAuditor;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlImportForeignSchemaStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsole
extends AbstractQueryLanguageConsole<LocalDataSource>
implements DatabaseScriptingSessionClient {
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private static final Key<Boolean> SCHEDULE_REFRESH = Key.create((String)"SCHEDULE_REFRESH");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private final ScriptModel<?> myScriptModel;
    private final VisibleDatabaseSession mySession;
    private final VirtualFile myVirtualFile;
    private final ScriptingClientDataConsumer myConsumer;
    private final EventDispatcher<SearchPathReceiver> myPathDispatcher;
    private final TraceableDisposable myTraceableDisposable;
    private final ParametersHolder myParametersHolder;
    private final ContentManagerAdapter myContentManagerAdapter;
    private final DGDepartment.Console myDepartment;
    private Content myPlanContent;

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(0);
        }
        Builder builder = new Builder(project);
        if (builder == null) {
            JdbcConsole.$$$reportNull$$$0(1);
        }
        return builder;
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(2);
        }
        ToggleToolbarAction action = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> {
            if (project == null) {
                JdbcConsole.$$$reportNull$$$0(55);
            }
            return DatabaseEditorHelper.getAllOpenedEditors(project).filter(editorEx -> {
                if (project == null) {
                    JdbcConsole.$$$reportNull$$$0(56);
                }
                VirtualFile vFile = editorEx.getVirtualFile();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                return editorEx.getPermanentHeaderComponent() != null && (JdbcConsole.findConsole(project, vFile) != null || psiFile != null && DbSqlUtil.isSqlFile(psiFile) && !DbImplUtil.isDatabaseVirtualFile(vFile));
            }).map(o -> o.getComponent());
        });
        action.getTemplatePresentation().setText("Show Console Toolbar");
        ToggleToolbarAction toggleToolbarAction = action;
        if (toggleToolbarAction == null) {
            JdbcConsole.$$$reportNull$$$0(3);
        }
        return toggleToolbarAction;
    }

    @Deprecated
    public static boolean beforeExecuteRange(@NotNull JdbcConsole console, TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(4);
        }
        if (range.isEmpty()) {
            return false;
        }
        ScriptModel subModel = console.getScriptModel().subModel(range);
        return console.beforeExecuteQueries(subModel);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(5);
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange(console, DatabaseSettings.getDefaultExecOption());
        return JdbcConsole.getQueryText(console, range);
    }

    @Deprecated
    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JdbcConsole.$$$reportNull$$$0(7);
        }
        if (range.isEmpty()) {
            return null;
        }
        String selected = range.subSequence((CharSequence)console.getDocument().getText()).toString();
        JBIterable parameters = console.getScriptModel().subModel(range).parameters();
        return ScriptModelUtil.statementText(console.getParametersHolder().getPStorage(), parameters, selected, 0);
    }

    public static DataAuditor createAdvancedErrorsObtainer(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataAuditor sink) {
        ConsoleErrorProviderFactory factory;
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(9);
        }
        if (sink == null) {
            JdbcConsole.$$$reportNull$$$0(10);
        }
        return (factory = (ConsoleErrorProviderFactory)ConsoleErrorProviderFactory.EP.forDbms(dataSource.getDbms())) == null ? null : factory.createErrorProvider(project, dataSource, sink);
    }

    private JdbcConsole(@NotNull Project project, @NotNull VirtualFile file, @NotNull VisibleDatabaseSession session2, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JdbcConsole.$$$reportNull$$$0(12);
        }
        if (session2 == null) {
            JdbcConsole.$$$reportNull$$$0(13);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(14);
        }
        super(project, dataSource, session2.getMessageBus());
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.myPathDispatcher = EventDispatcher.create(SearchPathReceiver.class);
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.myVirtualFile = file;
        this.mySession = session2;
        this.myScriptModel = SqlPsiFacade.getInstance((Project)project).createScriptModel(this.getFile());
        this.myDepartment = new DGDepartment.Console(JdbcConsole.getTitle(this.getProject(), this.getVirtualFile()));
        Disposer.register((Disposable)this, this.myScriptModel);
        this.myParametersHolder = new ParametersHolder(project, this.myScriptModel, this.getView().getConsoleView(), new DialogVisibilityController());
        Disposer.register((Disposable)this, (Disposable)this.myParametersHolder);
        this.myParametersHolder.initParameterView();
        JdbcDriverManager.getDriverManager(this.getProject()).addModificationTrackerListener(new FilePresentationUpdater(), this);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console");
        this.getMessageBus().addAuditor(new JdbcConsoleAuditor(this));
        session2.attach(this);
        this.myConsumer = ScriptingClientDataConsumer.install(project, this);
        DatabaseSessionView view = this.getView();
        view.addListener(() -> this.myConsumer.resetOutputTabCounter(), this);
        ContentManager contentManager = view.getUi().getContentManager();
        this.myContentManagerAdapter = new MyContentManagerAdapter();
        contentManager.addContentManagerListener((ContentManagerListener)this.myContentManagerAdapter);
        Disposer.register((Disposable)this, () -> contentManager.removeContentManagerListener((ContentManagerListener)this.myContentManagerAdapter));
    }

    @Override
    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getView().getConsoleView().getCurrentEditor();
        if (editorEx == null) {
            JdbcConsole.$$$reportNull$$$0(15);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Document getDocument() {
        DocumentEx documentEx = this.getCurrentEditor().getDocument();
        if (documentEx == null) {
            JdbcConsole.$$$reportNull$$$0(16);
        }
        return documentEx;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.getView().getConsoleView().getFile();
        if (psiFile == null) {
            JdbcConsole.$$$reportNull$$$0(17);
        }
        return psiFile;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        if (language == null) {
            JdbcConsole.$$$reportNull$$$0(18);
        }
        return language;
    }

    @Override
    public boolean isActive() {
        return DatabaseEditorHelper.getDeadConsole(this.getVirtualFile(), FileEditorManager.getInstance((Project)this.getProject())) == null;
    }

    @Override
    public boolean showOnAttention(@NotNull DataRequest.Context context) {
        ConsoleDataRequest request;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(19);
        }
        return (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) != null && (request.queryIndex == 0 || !request.hasNext);
    }

    @Override
    public boolean focusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(20);
        }
        return !(context.request instanceof ConsoleDataRequest) && !(context.request.owner instanceof ConsoleGridDataHookUp);
    }

    @Override
    public boolean getShowOnActivity() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DGDepartment.Console console = this.myDepartment;
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(21);
        }
        return console;
    }

    @Override
    @NotNull
    public VisibleDatabaseSession getSession() {
        VisibleDatabaseSession visibleDatabaseSession = this.mySession;
        if (visibleDatabaseSession == null) {
            JdbcConsole.$$$reportNull$$$0(22);
        }
        return visibleDatabaseSession;
    }

    @Override
    @NotNull
    public ParametersHolder getParametersHolder() {
        ParametersHolder parametersHolder = this.myParametersHolder;
        if (parametersHolder == null) {
            JdbcConsole.$$$reportNull$$$0(23);
        }
        return parametersHolder;
    }

    @Override
    @NotNull
    public PlaceInGrid getResultsPlaceInView() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            JdbcConsole.$$$reportNull$$$0(24);
        }
        return placeInGrid;
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent2) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(25);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = GridDataHookUpManager.getInstance(this.getProject()).createDatabaseHookUp(parent2, this.getSession(), new Sender(this), this.getDepartment());
        if (databaseGridDataHookUp == null) {
            JdbcConsole.$$$reportNull$$$0(26);
        }
        return databaseGridDataHookUp;
    }

    @Override
    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(27);
        }
        return scriptModel;
    }

    public void addReceiver(@NotNull Disposable parent2, @NotNull SearchPathReceiver receiver) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(28);
        }
        if (receiver == null) {
            JdbcConsole.$$$reportNull$$$0(29);
        }
        this.myPathDispatcher.addListener((EventListener)receiver, parent2);
    }

    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(30);
        }
        if (this.mySearchPath.get() == null) {
            this.updateSearchPath(context.getSearchPath());
        }
    }

    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(31);
        }
        ConsoleDataRequest consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
        boolean updateSearchPath = this.mySearchPath.get() == null || consoleRequest == null || consoleRequest.isExecutionStopper();
        boolean requestAutoSync = consoleRequest != null && consoleRequest.isExecutionStopper() && Boolean.TRUE.equals(consoleRequest.getSharedDataHolder().getUserData(SCHEDULE_REFRESH));
        boolean inTransaction2 = context.txMarker.isTransactionInProgress();
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid() && updateSearchPath) {
            this.updateSearchPath(context.getSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            LoaderContext loaderContext = this.prepareContext();
            if (scopeUpdater != null) {
                loaderContext.getScopeUpdater().merge(scopeUpdater);
            }
            DataSourceUiUtil.performAutoSyncTask(loaderContext);
            if (inTransaction2) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    public void updateConsoleOnTxCompleted(boolean commit) {
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUiUtil.performAutoSyncTask(this.prepareContext());
        }
    }

    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    @NotNull
    public ScriptModel.PStorage getPStorage() {
        ScriptModel.PStorage pStorage = this.myParametersHolder.getPStorage();
        if (pStorage == null) {
            JdbcConsole.$$$reportNull$$$0(32);
        }
        return pStorage;
    }

    @NotNull
    private LoaderContext prepareContext() {
        LoaderContext loaderContext = DataSourceUiUtil.getConnectionContext(this.getProject(), (LocalDataSource)this.getTarget(), SearchPath.getCurrent((SearchPath)this.mySearchPath.get()));
        if (loaderContext == null) {
            JdbcConsole.$$$reportNull$$$0(33);
        }
        return loaderContext;
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get())) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            VirtualFile virtualFile = this.getVirtualFile();
            DatabaseEditorHelper.initSearchPath(this.getFile());
            ChooseSchemaAction.setSelectedSearchPath(virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @NotNull
    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List<JdbcConsole> list = ScriptingDatabaseSessionClientHolder.INSTANCE.getActiveClients(project);
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(35);
        }
        return ScriptingDatabaseSessionClientHolder.INSTANCE.getMaybeAttachedClient(e);
    }

    @Nullable
    public static JdbcConsole findConsole(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return ScriptingDatabaseSessionClientHolder.INSTANCE.getMaybeAttachedClient(project, virtualFile);
    }

    @Nullable
    public static JdbcConsole getConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(36);
        }
        return (JdbcConsole)ScriptingDatabaseSessionClientHolder.INSTANCE.getClient(e);
    }

    @Nullable
    public static JdbcConsole getConsole(@Nullable Project project, @Nullable VirtualFile file) {
        return (JdbcConsole)ScriptingDatabaseSessionClientHolder.INSTANCE.getClient(project, file);
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    public static void buildHeaderComponent(@NotNull Editor editor, @Nullable JdbcConsole console) {
        JComponent header;
        if (editor == null) {
            JdbcConsole.$$$reportNull$$$0(37);
        }
        if ((header = (JComponent)ObjectUtils.doIfCast((Object)editor, EditorEx.class, e -> e.getPermanentHeaderComponent())) == null) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup leftGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Left");
            ActionGroup rightGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Right");
            EditorHeaderComponent headerComponent = new EditorHeaderComponent();
            ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", leftGroup, true);
            ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", rightGroup, true);
            rightToolbar.setReservePlaceAutoPopupIcon(false);
            leftToolbar.setTargetComponent(editor.getContentComponent());
            rightToolbar.setTargetComponent(editor.getContentComponent());
            headerComponent.add((Component)leftToolbar.getComponent(), "Center");
            headerComponent.add((Component)rightToolbar.getComponent(), "East");
            ObjectUtils.consumeIfCast((Object)editor, EditorEx.class, arg_0 -> JdbcConsole.lambda$buildHeaderComponent$7((JPanel)headerComponent, arg_0));
            editor.setHeaderComponent((JComponent)headerComponent);
            ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)editor.getProject()), (Iterable)JBIterable.of((Object)headerComponent), null);
            header = headerComponent;
        }
        DatabaseEditorHelper.configureEditorHeader(console == null ? editor.getProject() : console.getProject(), console == null ? null : console.getVirtualFile(), header);
    }

    @Override
    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        boolean result2;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(38);
        }
        if (result2 = this.myParametersHolder.beforeExecuteQueries(scriptModel)) {
            this.getView().beforeExecution();
        }
        return result2;
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model, @NotNull DatabaseSettings.ExecOption execOption) {
        boolean scheduleRefresh;
        if (sourceEditor == null) {
            JdbcConsole.$$$reportNull$$$0(39);
        }
        if (model == null) {
            JdbcConsole.$$$reportNull$$$0(40);
        }
        if (execOption == null) {
            JdbcConsole.$$$reportNull$$$0(41);
        }
        IntrospectionScopeUpdater scopeUpdater = null;
        if (((LocalDataSource)this.getTarget()).isAutoSynchronize()) {
            SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)model.statements().transform(ScriptModelUtil.TO_OBJECT).filter(PsiElement.class).toList());
            boolean bl = scheduleRefresh = !((SyntaxTraverser)s.filter(e -> JdbcConsole.triggersIntrospection(e))).traverse().isEmpty();
            if (scheduleRefresh) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser<PsiElement>)s, this.getCurrentNamespace(), ((LocalDataSource)this.getTarget()).getModel());
            }
        } else {
            scheduleRefresh = false;
        }
        ConsoleDataRequest request = ConsoleDataRequest.newConsoleRequest(this, sourceEditor, model, execOption.newTab);
        request.getSharedDataHolder().putUserData(SCHEDULE_REFRESH, (Object)scheduleRefresh);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest(request);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.run.intention");
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)this.getTarget();
        if (localDataSource == null) {
            JdbcConsole.$$$reportNull$$$0(42);
        }
        return localDataSource;
    }

    @Override
    public void beforeTreeDispose() {
        this.myTraceableDisposable.kill(null);
        super.beforeTreeDispose();
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(43);
        }
        if (force && this.getCurrentTx().isTransactionInProgress() && JdbcUrlParserUtil.outOfBounds(this.getDataSource(), SearchPath.getCurrent((SearchPath)this.getSearchPath()), to.getCurrent())) {
            int res2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)"Current connection will be closed.\nCommit current transaction?", (String)"Current Transaction", (Icon)Messages.getWarningIcon());
            if (res2 == 0) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxCommit(this));
            } else if (res2 == 1) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxRollback(this));
            } else {
                return;
            }
        }
        ((SearchPathReceiver)this.myPathDispatcher.getMulticaster()).receive(to);
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this, to, force));
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            JdbcConsole.$$$reportNull$$$0(44);
        }
        return txMarker;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.mySession.setAutoCommit(autoCommit);
    }

    @NotNull
    public Content createPlanContent() {
        PlanView view = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view.getComponent(), "Plan", DatabaseIcons.Table, view.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                JdbcConsole.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            JdbcConsole.$$$reportNull$$$0(45);
        }
        return content2;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = ((DatabaseSessionView)this.mySession.getView()).getUi();
        if (runnerLayoutUi == null) {
            JdbcConsole.$$$reportNull$$$0(46);
        }
        return runnerLayoutUi;
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            this.getView().ensureContentInitialized(true);
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            JdbcConsole.$$$reportNull$$$0(47);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DatabaseSessionView getView() {
        DatabaseSessionView databaseSessionView = (DatabaseSessionView)this.mySession.getView();
        if (databaseSessionView == null) {
            JdbcConsole.$$$reportNull$$$0(48);
        }
        return databaseSessionView;
    }

    @Override
    public boolean isIdle() {
        return this.mySession.isIdle();
    }

    @Override
    public boolean isTargetValid() {
        return JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), this.getDataSource());
    }

    @Override
    public void dispose() {
        try {
            JdbcConsole.getActiveConsoles(this.getProject()).remove(this);
        }
        finally {
            super.dispose();
        }
    }

    private void updateTitle() {
        String title = this.getTitle();
        this.getLanguageConsole().setTitle(title);
        this.getContent().setDisplayName(title);
    }

    public static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DasDataSource dataSource) {
        if (dbFacade == null) {
            JdbcConsole.$$$reportNull$$$0(49);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(50);
        }
        return dbFacade.findDataSource(dataSource.getUniqueId()) != null;
    }

    @NotNull
    private static String getTitle(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(51);
        }
        if (file == null) {
            JdbcConsole.$$$reportNull$$$0(52);
        }
        String string = VfsPresentationUtil.getPresentableNameForUI((Project)project, (VirtualFile)file);
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static boolean triggersIntrospection(@NotNull PsiElement e) {
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(54);
        }
        if (e instanceof SqlTableDefinition || e instanceof SqlImportForeignSchemaStatement) {
            return true;
        }
        if (e instanceof SqlAlterStatement) {
            ObjectKind kind;
            SqlReferenceExpression ref = ((SqlAlterStatement)e).getAlterTargetReference();
            ObjectKind objectKind = kind = ref == null ? null : ref.getReferenceElementType().getTargetKind();
            if (kind == null) {
                return false;
            }
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                return true;
            }
            return PsiTreeUtil.getChildOfType((PsiElement)e, SqlRenameToClause.class) != null;
        }
        return e instanceof SqlDdlStatement;
    }

    private static /* synthetic */ void lambda$buildHeaderComponent$7(JPanel headerComponent, EditorEx e) {
        e.setPermanentHeaderComponent((JComponent)headerComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 14: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 12: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 19: 
            case 20: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 35: 
            case 36: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleConsoleToolbarAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersHolder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceInView";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridDataHookUp";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPStorage";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareContext";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveConsoles";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToggleConsoleToolbarAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAdvancedErrorsObtainer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showOnAttention";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "focusOnError";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addReceiver";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestStarted";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestFinished";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildHeaderComponent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "switchSchema";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createToggleConsoleToolbarAction$2";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sender
    implements SearchPathSender {
        private final JdbcConsole myConsole;

        Sender(@NotNull JdbcConsole console) {
            if (console == null) {
                Sender.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        @Override
        public void subscribe(@NotNull SearchPathReceiver receiver) {
            if (receiver == null) {
                Sender.$$$reportNull$$$0(1);
            }
            this.myConsole.addReceiver(receiver, receiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcConsole$Sender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "subscribe";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyContentManagerAdapter
    extends ContentManagerAdapter {
        private MyContentManagerAdapter() {
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                MyContentManagerAdapter.$$$reportNull$$$0(0);
            }
            if (!JdbcConsole.this.getSession().isValid()) {
                return;
            }
            if (JdbcConsole.this.getTitle().equals(event.getContent().getDisplayName())) {
                FileEditorManager.getInstance((Project)JdbcConsole.this.getProject()).openFile(JdbcConsole.this.getVirtualFile(), true, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/JdbcConsole$MyContentManagerAdapter", "contentAdded"));
        }
    }

    private class FilePresentationUpdater
    implements ModificationTrackerListener<JdbcDriverManager> {
        private FilePresentationUpdater() {
        }

        public void modificationCountChanged(@NotNull JdbcDriverManager source) {
            if (source == null) {
                FilePresentationUpdater.$$$reportNull$$$0(0);
            }
            FileEditorManagerEx.getInstanceEx((Project)JdbcConsole.this.getProject()).updateFilePresentation(JdbcConsole.this.myVirtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/JdbcConsole$FilePresentationUpdater", "modificationCountChanged"));
        }
    }

    public static class ScriptingDatabaseSessionClientHolder
    extends SessionClientHolder<JdbcConsole, Parameters> {
        public static final ScriptingDatabaseSessionClientHolder INSTANCE = new ScriptingDatabaseSessionClientHolder();
        private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

        protected ScriptingDatabaseSessionClientHolder() {
            super(JdbcConsole.class);
        }

        @Nullable
        public JdbcConsole getMaybeAttachedClient(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(0);
            }
            JdbcConsole console = (JdbcConsole)this.getClient(e);
            return e.getData(CLIENT_KEY) == null && console == null ? JdbcConsoleProvider.getAttachedConsole(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) : console;
        }

        @Nullable
        public JdbcConsole getMaybeAttachedClient(@Nullable Project project, @Nullable VirtualFile file) {
            JdbcConsole console = (JdbcConsole)this.getClient(project, file);
            return console != null ? console : JdbcConsoleProvider.getAttachedConsole(project, file);
        }

        @Override
        @NotNull
        protected JdbcConsole createClientInner(@NotNull Parameters parameters) {
            if (parameters == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(1);
            }
            JdbcConsole jdbcConsole = new JdbcConsole(parameters.project, parameters.virtualFile, parameters.session, parameters.dataSource);
            if (jdbcConsole == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(2);
            }
            return jdbcConsole;
        }

        @Override
        @NotNull
        protected List<JdbcConsole> getActiveClients(@NotNull Project project) {
            Key<List<JdbcConsole>> key2;
            List data;
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(3);
            }
            if ((data = (List)project.getUserData(key2 = DATABASE_CONSOLE_LIST)) == null) {
                data = ContainerUtil.createLockFreeCopyOnWriteList();
                project.putUserData(key2, (Object)data);
                DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                    public void modificationCountChanged(@NotNull DbPsiFacade dbFacade) {
                        if (dbFacade == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Project project = dbFacade.getProject();
                        List validAndInvalidConsoles = ContainerUtil.notNullize((List)((List)project.getUserData(DATABASE_CONSOLE_LIST)));
                        for (JdbcConsole console : validAndInvalidConsoles) {
                            if (!JdbcConsole.isDataSourceValid(dbFacade, (DasDataSource)console.getTarget())) continue;
                            console.updateTitle();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFacade", "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder$1", "modificationCountChanged"));
                    }
                }, (Disposable)project);
            }
            Iterator it = data.iterator();
            while (it.hasNext()) {
                JdbcConsole console = (JdbcConsole)it.next();
                if (console.isValid()) continue;
                it.remove();
                TransactionGuard.submitTransaction((Disposable)project, () -> Disposer.dispose((Disposable)console));
            }
            List list = data;
            if (list == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        protected void register(@NotNull Project project, @NotNull JdbcConsole console) {
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(5);
            }
            if (console == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(6);
            }
            this.getActiveClients(project).add(console);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createClientInner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveClients";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaybeAttachedClient";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createClientInner";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveClients";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Parameters
        extends SessionClientHolder.Parameters {
            final LocalDataSource dataSource;
            final VirtualFile virtualFile;

            Parameters(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull VisibleDatabaseSession session2, @NotNull LocalDataSource dataSource) {
                if (project == null) {
                    Parameters.$$$reportNull$$$0(0);
                }
                if (virtualFile == null) {
                    Parameters.$$$reportNull$$$0(1);
                }
                if (session2 == null) {
                    Parameters.$$$reportNull$$$0(2);
                }
                if (dataSource == null) {
                    Parameters.$$$reportNull$$$0(3);
                }
                super(project, session2);
                this.virtualFile = virtualFile;
                this.dataSource = dataSource;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder$Parameters";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface SearchPathReceiver
    extends EventListener,
    Disposable {
        public void receive(@Nullable SearchPath var1);
    }

    public static interface SearchPathSender {
        public void subscribe(@NotNull SearchPathReceiver var1);
    }

    public static interface RawErrorsObtainer
    extends DataAuditor,
    Disposable {
        public boolean obtainErrors(@NotNull DataRequest.Context var1, @NotNull String var2);
    }

    public static class Builder {
        private final Project myProject;
        private VirtualFile myVirtualFile;
        private DasDataSource myInfo;

        public Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder fromDataSource(DasDataSource info) {
            this.myInfo = info;
            return this;
        }

        @NotNull
        public JdbcConsole buildAndShow() {
            JdbcConsole console = this.build();
            console.getView().ensureContentInitialized(false);
            ValueLookupManager instance = ValueLookupManager.getInstance((Project)this.myProject);
            if (instance != null) {
                instance.startListening();
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return jdbcConsole;
        }

        @NotNull
        public JdbcConsole build() {
            LocalDataSource dataSource = DbImplUtil.getLocalDataSource(this.myInfo);
            VirtualFile file = this.myVirtualFile != null ? this.myVirtualFile : DatabaseEditorHelper.getConsoleVirtualFile(this.myInfo);
            LOG.assertTrue(file != null, (Object)"Console file is not available");
            JdbcConsole existing = (JdbcConsole)JBIterable.from(ScriptingDatabaseSessionClientHolder.INSTANCE.getActiveClients(this.myProject)).find(s -> s.getVirtualFile().equals(file));
            LOG.assertTrue(existing == null, (Object)("Console already created for " + file.getName()));
            VisibleDatabaseSession session2 = DatabaseSessionManager.getSession(this.myProject, dataSource, JdbcConsole.getTitle(this.myProject, file), file);
            JdbcConsole jdbcConsole = (JdbcConsole)ScriptingDatabaseSessionClientHolder.INSTANCE.createClient(new ScriptingDatabaseSessionClientHolder.Parameters(this.myProject, file, session2, dataSource));
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return jdbcConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildAndShow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

