/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceGeneralPanel {
    private final DataSourceConfigurable myConfigurable;
    private JBScrollPane myPanel;
    private JComponent myConnectionPropertiesComponent;
    private JComponent myTxComponent;
    private JBCheckBox myAutoSyncCheckBox;
    private JCheckBox myReadOnlyCheckBox;
    private final DynamicJdbcUrlEditor myUrlPanel;
    private String myGeneratedName;
    private final MyTxIsolationSelector mySelector;

    DataSourceGeneralPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(0);
        }
        this.myGeneratedName = "";
        this.myConfigurable = configurable;
        LocalDataSource dataSource = (LocalDataSource)configurable.getDataSource();
        this.myUrlPanel = new DynamicJdbcUrlEditor(configurable, new Runnable(){

            @Override
            public void run() {
                String generatedName = DataSourceGeneralPanel.this.myUrlPanel.generateNameFromParameters();
                if (!Comparing.equal((String)generatedName, (String)DataSourceGeneralPanel.this.myGeneratedName) && Comparing.equal((String)DataSourceGeneralPanel.this.myConfigurable.createUniqueName(DataSourceGeneralPanel.this.myGeneratedName), (String)DataSourceGeneralPanel.this.myConfigurable.getNameValue()) || StringUtil.isEmptyOrSpaces((String)DataSourceGeneralPanel.this.myConfigurable.getNameValue())) {
                    DataSourceGeneralPanel.this.myConfigurable.setGeneratedName(DataSourceGeneralPanel.this.myConfigurable.createUniqueName(generatedName));
                }
                DataSourceGeneralPanel.this.myGeneratedName = generatedName;
            }
        });
        this.mySelector = new MyTxIsolationSelector();
        this.$$$setupUI$$$();
        this.myUrlPanel.getComponent().setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.myPanel.setBorder(null);
        JComponent view = (JComponent)this.myPanel.getViewport().getView();
        view.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        ((GridLayoutManager)view.getLayout()).setHGap(5);
        this.myTxComponent.setVisible(TransactionAction.isTransactionsSupported(dataSource.getDbms()));
    }

    @NotNull
    public JScrollPane getComponent() {
        JBScrollPane jBScrollPane = this.myPanel;
        if (jBScrollPane == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    @Nullable
    public String getUserName() {
        return this.myUrlPanel.getUserName();
    }

    @Nullable
    public char[] getPassword() {
        return this.myUrlPanel.getPassword();
    }

    public void setCanConnect(boolean canConnect) {
        this.myUrlPanel.setCanConnect(canConnect);
    }

    public void onActivity() {
        this.myUrlPanel.onActivity();
    }

    public void saveSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(2);
        }
        this.myUrlPanel.saveSettings(dataSource, copyCredentials, actual);
        dataSource.setAutoCommit(this.mySelector.isAuto());
        dataSource.setTxIsolation(this.mySelector.getIsolation().getIsolation());
        dataSource.setAutoSynchronize(this.myAutoSyncCheckBox.isSelected());
        dataSource.setReadOnly(this.myReadOnlyCheckBox.isSelected());
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(3);
        }
        this.myUrlPanel.reset(dataSource);
        this.mySelector.toggle(null, dataSource.isAutoCommit());
        this.mySelector.select(TransactionAction.TxIsolation.of(dataSource.getTxIsolation()), null);
        this.myAutoSyncCheckBox.setSelected(dataSource.isAutoSynchronize());
        this.myReadOnlyCheckBox.setSelected(dataSource.isReadOnly());
    }

    public void requestUrlFocus() {
        this.myUrlPanel.requestUrlFocus();
    }

    @NotNull
    public String generateNameFromParameters() {
        String string = this.myConfigurable.createUniqueName(this.myUrlPanel.generateNameFromParameters());
        if (string == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void createUIComponents() {
        this.myConnectionPropertiesComponent = this.myUrlPanel.getComponent();
        this.myTxComponent = DbUIUtil.createActionComponent((AnAction)new DataSourceTxModeAction(this.mySelector, ((LocalDataSource)this.myConfigurable.myTarget).getDbms()));
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        this.myUrlPanel.setDriver(driver, this.myUrlPanel.getUrl(), this.myUrlPanel.isUrlOnly());
    }

    public void resetCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(5);
        }
        this.myUrlPanel.resetCredentials(dataSource);
    }

    public boolean isPasswordChanged() {
        return this.myUrlPanel.isPasswordChanged();
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myUrlPanel.getActualDriver();
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myUrlPanel.getDriver();
    }

    @NotNull
    public UrlEditorModel getUrlEditorModel() {
        UrlEditorModel urlEditorModel = this.myUrlPanel.getEditorModel();
        if (urlEditorModel == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(6);
        }
        return urlEditorModel;
    }

    public void updateDriverLink() {
        this.myUrlPanel.updateDriverLink();
    }

    public void onApply() {
        this.myUrlPanel.forgetPassword();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNameFromParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resetCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myPanel = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JComponent jComponent = this.myConnectionPropertiesComponent;
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 5, 0));
        jPanel2.add((Component)jPanel3, "East");
        JComponent jComponent2 = this.myTxComponent;
        Component component = jPanel3.add(jComponent2);
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.myReadOnlyCheckBox = jBCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/DatabaseBundle").getString("read.only"));
        Component component2 = jPanel3.add((Component)jBCheckBox2);
        this.myAutoSyncCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/DatabaseBundle").getString("auto.sync"));
        Component component3 = jPanel3.add((Component)jBCheckBox);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyUserActivityWrapper
    extends TransactionAction.PreferencesUserActivityWrapper
    implements DescriptionPopup.TxPopup.TxIsolationSelector {
        private final DescriptionPopup.TxPopup.TxIsolationSelector mySelector;

        MyUserActivityWrapper(@NotNull JComponent component, @NotNull DescriptionPopup.TxPopup.TxIsolationSelector selector) {
            if (component == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(1);
            }
            super(component);
            this.mySelector = selector;
        }

        @Override
        @NotNull
        protected DescriptionPopup.TxPopup.TxSelector getSelector() {
            DescriptionPopup.TxPopup.TxIsolationSelector txIsolationSelector = this.mySelector;
            if (txIsolationSelector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(2);
            }
            return txIsolationSelector;
        }

        @Override
        public boolean isSelected(@NotNull TransactionAction.TxIsolation isolation) {
            if (isolation == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(3);
            }
            return this.mySelector.isSelected(isolation);
        }

        @Override
        public void select(@NotNull TransactionAction.TxIsolation isolation, AnActionEvent e) {
            if (isolation == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(4);
            }
            this.mySelector.select(isolation, e);
            this.fireUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyUserActivityWrapper";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyUserActivityWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DataSourceTxModeAction
    extends TransactionAction.PreferencesTxModeAction {
        private final MyTxIsolationSelector mySelector;
        private final List<TransactionAction.TxIsolation> availableLevels;

        DataSourceTxModeAction(MyTxIsolationSelector selector, @NotNull Dbms id) {
            if (id == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
            this.availableLevels = DataSourceTxModeAction.getAvailableLevels(id);
        }

        @Override
        @NotNull
        public MyTxIsolationSelector getSelector() {
            MyTxIsolationSelector myTxIsolationSelector = this.mySelector;
            if (myTxIsolationSelector == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(1);
            }
            return myTxIsolationSelector;
        }

        @Override
        @NotNull
        protected TransactionAction.PreferencesUserActivityWrapper createActivityWrapper(@NotNull JComponent component) {
            if (component == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(2);
            }
            MyUserActivityWrapper myUserActivityWrapper = new MyUserActivityWrapper(component, this.mySelector);
            if (myUserActivityWrapper == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(3);
            }
            return myUserActivityWrapper;
        }

        @Override
        @Nullable
        protected DescriptionPopup.TxSettingsPopup createPopup(@NotNull TransactionAction.PreferencesUserActivityWrapper activityWrapper) {
            MyUserActivityWrapper myUserActivityWrapper;
            if (activityWrapper == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(4);
            }
            if ((myUserActivityWrapper = (MyUserActivityWrapper)ObjectUtils.tryCast((Object)activityWrapper, MyUserActivityWrapper.class)) == null) {
                return null;
            }
            return new DescriptionPopup.TxSettingsPopup(this.availableLevels, myUserActivityWrapper);
        }

        @NotNull
        private static List<TransactionAction.TxIsolation> getAvailableLevels(@NotNull Dbms id) {
            if (id == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(5);
            }
            List list = TransactionAction.TxIsolation.levelsSupported(id) ? ContainerUtil.filter((Object[])TransactionAction.TxIsolation.values(), isolation -> {
                if (id == null) {
                    DataSourceTxModeAction.$$$reportNull$$$0(7);
                }
                return isolation.isSupported(id, null);
            }) : ContainerUtil.emptyList();
            if (list == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$DataSourceTxModeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$DataSourceTxModeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActivityWrapper";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createActivityWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopup";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getAvailableLevels";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getAvailableLevels$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyTxIsolationSelector
    extends DescriptionPopup.TxPopup.TxSelectorImpl
    implements DescriptionPopup.TxPopup.TxIsolationSelector {
        private TransactionAction.TxIsolation myIsolation = TransactionAction.TxIsolation.DEFAULT;

        @Override
        public boolean isSelected(@NotNull TransactionAction.TxIsolation isolation) {
            if (isolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(0);
            }
            return this.myIsolation == isolation;
        }

        @Override
        public void select(@NotNull TransactionAction.TxIsolation isolation, AnActionEvent e) {
            if (isolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(1);
            }
            this.myIsolation = isolation;
        }

        @NotNull
        public TransactionAction.TxIsolation getIsolation() {
            TransactionAction.TxIsolation txIsolation = this.myIsolation;
            if (txIsolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(2);
            }
            return txIsolation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyTxIsolationSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyTxIsolationSelector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIsolation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

