/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.plan.OraclePlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleExplainPlanProvider
extends ExplainPlanProvider {
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";

    public OracleExplainPlanProvider(@NotNull Dbms dbms) {
        if (dbms == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(0);
        }
        super(dbms);
    }

    @Override
    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(1);
        }
        ScriptModel scriptModel = model.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v -> {
                if (!(v instanceof SqlParameter)) {
                    return false;
                }
                CharSequence text2 = api.textOf(v);
                return text2.equals("?") || StringUtil.startsWith((CharSequence)text2, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return scriptModel;
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (consumer2 == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            OracleExplainPlanProvider.$$$reportNull$$$0(6);
        }
        return new OraclePlanModelBuilder(owner, consumer2, statement, DEFAULT_PLAN_TABLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OracleExplainPlanProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OracleExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExplainRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

