/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultValuesExtractor<T extends DatabaseSettings.DatabaseBaseState>
implements DataExtractor {
    private final ObjectFormatter myConverter;
    protected final T myState;

    public DefaultValuesExtractor(@NotNull T state, @NotNull ObjectFormatter converter) {
        if (state == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(1);
        }
        this.myConverter = converter;
        this.myState = state;
    }

    @NotNull
    protected ObjectFormatter getFormatter() {
        ObjectFormatter objectFormatter = this.myConverter;
        if (objectFormatter == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(2);
        }
        return objectFormatter;
    }

    public T getState() {
        return this.myState;
    }

    public boolean isIncludeColumnNames() {
        T state = this.getState();
        return state instanceof DatabaseSettings.StdState && ((DatabaseSettings.StdState)state).columnNames;
    }

    public void setIncludeColumnNames(boolean columnNames) {
        T state = this.getState();
        if (state instanceof DatabaseSettings.StdState) {
            ((DatabaseSettings.StdState)state).columnNames = columnNames;
        }
    }

    public void setIncludeRowNumbers(boolean rowNumbers) {
        T state = this.getState();
        if (state instanceof DatabaseSettings.StdState) {
            ((DatabaseSettings.StdState)state).rowNumber = rowNumbers;
        }
    }

    public boolean isIncludeRowNumbers() {
        T state = this.getState();
        return state instanceof DatabaseSettings.StdState && ((DatabaseSettings.StdState)state).rowNumber;
    }

    public String getValueSeparator() {
        return " ";
    }

    public String getLineSeparator() {
        return "\n";
    }

    @NotNull
    public String getLinePrefix() {
        if ("" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public String getLineSuffix() {
        if ("" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(4);
        }
        return "";
    }

    @NotNull
    public String getValuePrefix() {
        if ("" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    public String getValueSuffix() {
        if ("" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(6);
        }
        return "";
    }

    @NotNull
    public String getValueLiteral(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms) {
        String value;
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(9);
        }
        String string = (value = this.getValueAsString(row, column2, dbms, false)) == null ? this.getNullLiteral(row, column2) : this.getValueLiteral(dbms, value, row, column2);
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, boolean forDisplay) {
        if (row == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(12);
        }
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(13);
        }
        return this.myConverter.getValueLiteral(row, column2, dbms, DefaultValuesExtractor.isPgDecodedLiteral(column2, row));
    }

    public String getValueLiteral(@NotNull Dbms dbms, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(14);
        }
        if (value == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(15);
        }
        return this.isStringLiteral(dbms, value, row, column2) ? this.getStringValue(dbms, column2, value) : value;
    }

    protected boolean isStringLiteral(@NotNull Dbms dbms, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(16);
        }
        if (value == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(17);
        }
        return column2 != null && (DefaultValuesExtractor.isCommonLiteral(dbms, column2) || ObjectFormatter.isJson(column2, dbms) || DefaultValuesExtractor.isPostgresLiteral(dbms, column2, row));
    }

    private static boolean isCommonLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column2) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(18);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(19);
        }
        JdbcHelper helper = DbImplUtil.getJdbcHelper(dbms);
        int jdbcType = ExtractorsUtil.guessJdbcType(column2);
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 91 || jdbcType == 2005 || jdbcType == -8 || jdbcType == 239 || helper.isTimestamp(jdbcType) || helper.isZonedColumn(column2.typeName, jdbcType) || ObjectFormatter.isBitString(column2) || StringUtil.equalsIgnoreCase((CharSequence)column2.typeName, (CharSequence)"uuid");
    }

    private static boolean isPostgresLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column2, @Nullable DataConsumer.Row row) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(20);
        }
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(21);
        }
        return dbms.isPostgres() && (ObjectFormatter.isHstore(column2) || ObjectFormatter.isPostgresRangeType(column2) || ObjectFormatter.isPostgresArray(column2) || DefaultValuesExtractor.isPgDecodedLiteral(column2, row));
    }

    private static boolean isPgDecodedLiteral(@NotNull DataConsumer.Column column2, @Nullable DataConsumer.Row row) {
        if (column2 == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(22);
        }
        Object value = row == null ? null : column2.getValue(row);
        return value instanceof ObjectFormatter.TextInfo && ObjectFormatter.isBinaryTextColumn(column2);
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new DefaultExtraction(out, dbms, forceSkipHeader, allColumns, selectedColumns);
    }

    public String getColumnName(DataConsumer.Column column2) {
        return column2.name;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("txt" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(23);
        }
        return "txt";
    }

    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column2) {
        if ("NULL" == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(24);
        }
        return "NULL";
    }

    @NotNull
    public String getStringValue(@NotNull Dbms dbms, @Nullable DataConsumer.Column column2, @NotNull String value) {
        if (dbms == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(25);
        }
        if (value == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(26);
        }
        String string = value;
        if (string == null) {
            DefaultValuesExtractor.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 23: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 23: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 8: 
            case 12: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DefaultValuesExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinePrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSuffix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePrefix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueSuffix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteral";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullLiteral";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCommonLiteral";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresLiteral";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPgDecodedLiteral";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 23: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class DefaultExtraction
    implements DataExtractor.Extraction {
        protected final CharOut myOutput;
        protected final List<DataConsumer.Column> myAllColumns;
        protected final int[] mySelectedColumnIndices;
        protected final Dbms myDbms;
        protected final boolean myForceSkipHeader;
        protected boolean myHeaderAppended;
        protected boolean myFooterAppended;

        public DefaultExtraction(CharOut output, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            this.myOutput = output;
            this.myDbms = dbms;
            this.myForceSkipHeader = forceSkipHeader;
            this.myAllColumns = allColumns;
            this.mySelectedColumnIndices = selectedColumnIndices;
        }

        @Override
        public void addData(List<DataConsumer.Row> rows) {
            if (!this.myHeaderAppended && !this.myForceSkipHeader) {
                this.appendHeader(!rows.isEmpty());
                this.myHeaderAppended = true;
            }
            this.appendData(rows);
        }

        @Override
        public void complete() {
            if (!this.myHeaderAppended && !this.myForceSkipHeader) {
                this.appendHeader(false);
                this.myHeaderAppended = true;
            }
            if (!this.myFooterAppended) {
                this.appendFooter();
                this.myFooterAppended = true;
            }
        }

        protected void appendHeader(boolean appendNewLine) {
            if (DefaultValuesExtractor.this.isIncludeColumnNames() && !this.myForceSkipHeader) {
                String number = DefaultValuesExtractor.this.isIncludeRowNumbers() ? DefaultValuesExtractor.this.getColumnName(this.getRowNumbersColumn()) + DefaultValuesExtractor.this.getValueSeparator() : "";
                this.myOutput.append(DefaultValuesExtractor.this.getLinePrefix()).append(number);
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                boolean first = true;
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (!first) {
                        this.myOutput.append(DefaultValuesExtractor.this.getValueSeparator());
                    } else {
                        first = false;
                    }
                    this.myOutput.append(DefaultValuesExtractor.this.getColumnName(column2));
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLineSuffix());
                if (appendNewLine) {
                    this.myOutput.append(DefaultValuesExtractor.this.getLineSeparator());
                }
            }
        }

        protected void appendData(List<DataConsumer.Row> rows) {
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            boolean first = true;
            for (DataConsumer.Row row : rows) {
                if (!first) {
                    this.myOutput.append(DefaultValuesExtractor.this.getLineSeparator());
                } else {
                    first = false;
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLinePrefix());
                if (DefaultValuesExtractor.this.isIncludeRowNumbers()) {
                    this.myOutput.append(DefaultValuesExtractor.this.getValuePrefix()).append(DefaultValuesExtractor.this.getValueLiteral(this.myDbms, this.getRowNumber(row), null, null)).append(DefaultValuesExtractor.this.getValueSuffix()).append(DefaultValuesExtractor.this.getValueSeparator());
                }
                boolean innerFirst = true;
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (!innerFirst) {
                        this.myOutput.append(DefaultValuesExtractor.this.getValueSeparator());
                    } else {
                        innerFirst = false;
                    }
                    String value = DefaultValuesExtractor.this.getValueLiteral(row, column2, this.myDbms);
                    this.myOutput.append(DefaultValuesExtractor.this.getValuePrefix()).append(value).append(DefaultValuesExtractor.this.getValueSuffix());
                }
                this.myOutput.append(DefaultValuesExtractor.this.getLineSuffix());
            }
        }

        protected void appendFooter() {
        }

        @NotNull
        protected String getRowNumber(DataConsumer.Row row) {
            String string = String.valueOf(row.rowNum);
            if (string == null) {
                DefaultExtraction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            DataConsumer.Column column2 = new DataConsumer.Column(0, "#", 12, "", "");
            if (column2 == null) {
                DefaultExtraction.$$$reportNull$$$0(1);
            }
            return column2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/extractors/DefaultValuesExtractor$DefaultExtraction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumber";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumbersColumn";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

