/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CvsConflictsParser {
    private static final String LEFT = "<<<<<<< ";
    private static final String RIGHT = "=======";
    private static final String END = ">>>>>>> ";
    private static final int LENGTH = "=======".length();
    private final StringBuilder myLeftBuffer = new StringBuilder();
    private final StringBuilder myCenterBuffer = new StringBuilder();
    private final StringBuilder myRightBuffer = new StringBuilder();
    private final Stack<State> myStateStack = new Stack();

    public String getLeftVersion() {
        return this.myLeftBuffer.toString();
    }

    public String getCenterVersion() {
        return this.myCenterBuffer.toString();
    }

    public String getRightVersion() {
        return this.myRightBuffer.toString();
    }

    private CvsConflictsParser() {
    }

    public static CvsConflictsParser createOn(InputStream merged) throws IOException {
        CvsConflictsParser result = new CvsConflictsParser();
        result.parseFile(merged);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(InputStream merged) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(merged));){
            String line;
            while ((line = br.readLine()) != null) {
                if (this.processLeftMarker(line) || this.processRightMarker(line) || this.processEndMarker(line)) continue;
                this.appendToMainOrCurrent(line);
            }
        }
    }

    private boolean processLeftMarker(String line) {
        int idx = line.lastIndexOf(LEFT);
        if (idx < 0) {
            return false;
        }
        if (this.myStateStack.isEmpty()) {
            String fragment = line.substring(0, idx);
            if (!fragment.isEmpty()) {
                this.appendToMainOrCurrent(fragment);
            }
        } else {
            this.appendToMainOrCurrent(line);
        }
        this.myStateStack.push((Object)State.LEFT);
        return true;
    }

    private boolean processRightMarker(String line) {
        if (!line.endsWith(RIGHT)) {
            return false;
        }
        if (!this.myStateStack.isEmpty() && this.myStateStack.peek() == State.LEFT) {
            if (this.myStateStack.size() > 1) {
                this.appendToMainOrCurrent(line);
            } else {
                String fragment = line.substring(0, line.length() - LENGTH);
                if (!fragment.isEmpty()) {
                    this.appendToMainOrCurrent(fragment);
                }
            }
            this.myStateStack.pop();
            this.myStateStack.push((Object)State.RIGHT);
        } else {
            this.appendToMainOrCurrent(line);
        }
        return true;
    }

    private boolean processEndMarker(String line) {
        int idx = line.lastIndexOf(END);
        if (idx < 0) {
            return false;
        }
        if (!this.myStateStack.isEmpty()) {
            if (this.myStateStack.size() > 1) {
                this.appendToMainOrCurrent(line);
            } else {
                String fragment = line.substring(0, idx);
                if (!fragment.isEmpty()) {
                    this.appendToMainOrCurrent(fragment);
                }
            }
            this.myStateStack.pop();
        } else {
            this.appendToMainOrCurrent(line);
        }
        return true;
    }

    private void appendToMainOrCurrent(String line) {
        if (this.myStateStack.isEmpty()) {
            CvsConflictsParser.append(line, this.myLeftBuffer);
            CvsConflictsParser.append(line, this.myCenterBuffer);
            CvsConflictsParser.append(line, this.myRightBuffer);
        } else if (this.myStateStack.get(0) == State.RIGHT) {
            CvsConflictsParser.append(line, this.myRightBuffer);
        } else {
            CvsConflictsParser.append(line, this.myLeftBuffer);
        }
    }

    private static void append(String line, StringBuilder out) {
        if (out.length() > 0) {
            out.append("\n");
        }
        out.append(line);
    }

    private static enum State {
        RIGHT,
        LEFT;

    }
}

