/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine;

import java.util.List;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.Watchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Debugger
extends Watchable {
    public State getState();

    public boolean start();

    public void stop(boolean var1);

    public void step();

    public void stepInto();

    public void resume();

    public void pause();

    public boolean isStopped();

    public StyleFrame getCurrentFrame();

    public SourceFrame getSourceFrame();

    public Value eval(String var1) throws EvaluationException;

    public List<Variable> getGlobalVariables();

    public BreakpointManager getBreakpointManager();

    public OutputEventQueue getEventQueue();

    public boolean waitForDebuggee();

    public State waitForStateChange(State var1);

    public static class EvaluationException
    extends Exception {
        public EvaluationException(String message) {
            super(message);
        }
    }

    public static interface Variable
    extends Locatable {
        public boolean isGlobal();

        public Kind getKind();

        public String getName();

        public Value getValue();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            VARIABLE,
            PARAMETER,
            EXPRESSION;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SourceFrame
    extends Frame<SourceFrame> {
        public String getXPath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StyleFrame
    extends Frame<StyleFrame> {
        public String getInstruction();

        public Value eval(String var1) throws EvaluationException;

        public List<Variable> getVariables();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Frame<T extends Frame>
    extends Locatable {
        public T getNext();

        public T getPrevious();
    }

    public static interface Locatable {
        public String getURI();

        public int getLineNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        RUNNING,
        SUSPENDED,
        STOPPED;

    }
}

