/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountCombobox;

public class GithubCreateGistDialog
extends DialogWrapper {
    @Nullable
    private final JBTextField myFileNameField;
    @NotNull
    private final JTextArea myDescriptionField;
    @NotNull
    private final JBCheckBox mySecretCheckBox;
    @NotNull
    private final JBCheckBox myOpenInBrowserCheckBox;
    @NotNull
    private final JBCheckBox myCopyLinkCheckBox;
    @NotNull
    private final GithubAccountCombobox myAccountSelector;

    public GithubCreateGistDialog(@NotNull Project project, @NotNull Set<GithubAccount> accounts, @Nullable GithubAccount defaultAccount, @Nullable String fileName, boolean secret, boolean openInBrowser, boolean copyLink) {
        if (project == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(0);
        }
        if (accounts == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myFileNameField = fileName != null ? new JBTextField(fileName) : null;
        this.myDescriptionField = new JTextArea();
        this.mySecretCheckBox = new JBCheckBox("Secret", secret);
        this.myOpenInBrowserCheckBox = new JBCheckBox("Open in browser", openInBrowser);
        this.myCopyLinkCheckBox = new JBCheckBox("Copy URL", copyLink);
        this.myAccountSelector = new GithubAccountCombobox(accounts, defaultAccount, null);
        this.setTitle("Create Gist");
        this.init();
    }

    protected JComponent createCenterPanel() {
        JBBox checkBoxes = JBBox.createHorizontalBox();
        checkBoxes.add((Component)this.mySecretCheckBox);
        checkBoxes.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        checkBoxes.add((Component)this.myOpenInBrowserCheckBox);
        checkBoxes.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        checkBoxes.add((Component)this.myCopyLinkCheckBox);
        JBScrollPane descriptionPane = new JBScrollPane((Component)this.myDescriptionField);
        descriptionPane.setPreferredSize((Dimension)new JBDimension(270, 55));
        descriptionPane.setMinimumSize((Dimension)new JBDimension(270, 55));
        PanelGridBuilder grid = UI.PanelFactory.grid().resize();
        if (this.myFileNameField != null) {
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myFileNameField).withLabel("Filename:"));
        }
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)descriptionPane).withLabel("Description:").anchorLabelOn(UI.Anchor.Top).resizeY(true)).add((PanelBuilder)UI.PanelFactory.panel((JComponent)checkBoxes));
        if (this.myAccountSelector.isEnabled()) {
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)this.myAccountSelector)).withLabel("Create for:").resizeX(false));
        }
        return grid.createPanel();
    }

    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDescriptionField;
    }

    @Nullable
    public String getFileName() {
        return this.myFileNameField != null ? this.myFileNameField.getText() : null;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescriptionField.getText();
        if (string == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isSecret() {
        return this.mySecretCheckBox.isSelected();
    }

    public boolean isOpenInBrowser() {
        return this.myOpenInBrowserCheckBox.isSelected();
    }

    public boolean isCopyURL() {
        return this.myCopyLinkCheckBox.isSelected();
    }

    @NotNull
    public GithubAccount getAccount() {
        GithubAccount githubAccount = (GithubAccount)this.myAccountSelector.getSelectedItem();
        if (githubAccount == null) {
            GithubCreateGistDialog.$$$reportNull$$$0(3);
        }
        return githubAccount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accounts";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/ui/GithubCreateGistDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

