/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.drawing;

import com.glavsoft.drawing.ColorDecoder;
import com.glavsoft.drawing.SoftCursor;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Reader;
import java.util.Arrays;

public abstract class Renderer {
    protected Reader reader;
    private final Object lock = new Object();
    protected int width;
    protected int height;
    protected int[] pixels;
    protected SoftCursor cursor;
    public PixelFormat pixelFormat;
    protected ColorDecoder colorDecoder;

    public abstract void drawJpegImage(byte[] var1, int var2, int var3, FramebufferUpdateRectangle var4);

    protected void init(Reader reader, int width, int height, PixelFormat pixelFormat) {
        this.reader = reader;
        this.width = width;
        this.height = height;
        this.initPixelFormat(pixelFormat);
        this.pixels = new int[width * height];
        Arrays.fill(this.pixels, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPixelFormat(PixelFormat pixelFormat) {
        Object object = this.lock;
        synchronized (object) {
            this.pixelFormat = pixelFormat;
            this.colorDecoder = new ColorDecoder(pixelFormat);
        }
    }

    public void drawBytes(byte[] bytes, int x, int y, int width, int height) {
        int i = 0;
        for (int ly = y; ly < y + height; ++ly) {
            int end = ly * this.width + x + width;
            for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = this.getPixelColor(bytes, i);
                i += this.colorDecoder.bytesPerPixel;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drawCompactBytes(byte[] bytes, int offset, int x, int y, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            int i = offset;
            for (int ly = y; ly < y + height; ++ly) {
                int end = ly * this.width + x + width;
                for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                    this.pixels[pixelsOffset] = this.getCompactPixelColor(bytes, i);
                    i += this.colorDecoder.bytesPerCPixel;
                }
            }
            return i - offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawColoredBitmap(int[] colors, int x, int y, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            for (int ly = y; ly < y + height; ++ly) {
                int end = ly * this.width + x + width;
                for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                    this.pixels[pixelsOffset] = colors[i++];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drawTightBytes(byte[] bytes, int offset, int x, int y, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            int i = offset;
            for (int ly = y; ly < y + height; ++ly) {
                int end = ly * this.width + x + width;
                for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                    this.pixels[pixelsOffset] = this.colorDecoder.getTightColor(bytes, i);
                    i += this.colorDecoder.bytesPerPixelTight;
                }
            }
            return i - offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawUncaliberedRGBLine(byte[] bytes, int x, int y, int width) {
        Object object = this.lock;
        synchronized (object) {
            int end = y * this.width + x + width;
            int i = 3;
            for (int pixelsOffset = y * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = (0xFF & 255 * (this.colorDecoder.redMax & bytes[i++]) / this.colorDecoder.redMax) << 16 | (0xFF & 255 * (this.colorDecoder.greenMax & bytes[i++]) / this.colorDecoder.greenMax) << 8 | 0xFF & 255 * (this.colorDecoder.blueMax & bytes[i++]) / this.colorDecoder.blueMax;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBytesWithPalette(byte[] buffer, FramebufferUpdateRectangle rect, int[] palette, int paletteSize) {
        Object object = this.lock;
        synchronized (object) {
            if (2 == paletteSize) {
                int i = rect.y * this.width + rect.x;
                int rowBytes = (rect.width + 7) / 8;
                for (int dy = 0; dy < rect.height; ++dy) {
                    int n;
                    int dx;
                    for (dx = 0; dx < rect.width / 8; ++dx) {
                        byte b = buffer[dy * rowBytes + dx];
                        for (n = 7; n >= 0; --n) {
                            this.pixels[i++] = palette[b >> n & 1];
                        }
                    }
                    for (n = 7; n >= 8 - rect.width % 8; --n) {
                        this.pixels[i++] = palette[buffer[dy * rowBytes + dx] >> n & 1];
                    }
                    i += this.width - rect.width;
                }
            } else {
                int i = 0;
                for (int ly = rect.y; ly < rect.y + rect.height; ++ly) {
                    for (int lx = rect.x; lx < rect.x + rect.width; ++lx) {
                        int pixelsOffset = ly * this.width + lx;
                        this.pixels[pixelsOffset] = palette[buffer[i++] & 0xFF];
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRect(int srcX, int srcY, FramebufferUpdateRectangle dstRect) {
        int deltaY;
        int dstY;
        int endSrcY;
        int startSrcY;
        if (srcY > dstRect.y) {
            startSrcY = srcY;
            endSrcY = srcY + dstRect.height;
            dstY = dstRect.y;
            deltaY = 1;
        } else {
            startSrcY = srcY + dstRect.height - 1;
            endSrcY = srcY - 1;
            dstY = dstRect.y + dstRect.height - 1;
            deltaY = -1;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int y = startSrcY; y != endSrcY; y += deltaY) {
                System.arraycopy(this.pixels, y * this.width + srcX, this.pixels, dstY * this.width + dstRect.x, dstRect.width);
                dstY += deltaY;
            }
        }
    }

    public void fillRect(int color, FramebufferUpdateRectangle rect) {
        this.fillRect(color, rect.x, rect.y, rect.width, rect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillRect(int color, int x, int y, int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            int sy = y * this.width + x;
            int ey = sy + height * this.width;
            for (int i = sy; i < ey; i += this.width) {
                Arrays.fill(this.pixels, i, i + width, color);
            }
        }
    }

    public int readPixelColor(Reader reader) throws TransportException {
        return this.colorDecoder.readColor(reader);
    }

    public int readTightPixelColor(Reader reader) throws TransportException {
        return this.colorDecoder.readTightColor(reader);
    }

    public ColorDecoder getColorDecoder() {
        return this.colorDecoder;
    }

    public int getCompactPixelColor(byte[] bytes, int offset) {
        return this.colorDecoder.getCompactColor(bytes, offset);
    }

    public int getPixelColor(byte[] bytes, int offset) {
        return this.colorDecoder.getColor(bytes, offset);
    }

    public int getBytesPerPixel() {
        return this.colorDecoder.bytesPerPixel;
    }

    public int getBytesPerCPixel() {
        return this.colorDecoder.bytesPerCPixel;
    }

    public int getBytesPerPixelTight() {
        return this.colorDecoder.bytesPerPixelTight;
    }

    public void fillColorBitmapWithColor(int[] bitmapData, int decodedOffset, int rlength, int color) {
        while (rlength-- > 0) {
            bitmapData[decodedOffset++] = color;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCursor(int[] cursorPixels, FramebufferUpdateRectangle rect) throws TransportException {
        Object object = this.cursor.getLock();
        synchronized (object) {
            this.cursor.createCursor(cursorPixels, rect.x, rect.y, rect.width, rect.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeCursorPosition(FramebufferUpdateRectangle rect) {
        Object object = this.cursor.getLock();
        synchronized (object) {
            this.cursor.updatePosition(rect.x, rect.y);
        }
    }

    public Object getLock() {
        return this.lock;
    }
}

