/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.RatioDistribution;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.predefined.CqlCounterAdder;
import org.apache.cassandra.stress.operations.predefined.CqlCounterGetter;
import org.apache.cassandra.stress.operations.predefined.CqlInserter;
import org.apache.cassandra.stress.operations.predefined.CqlReader;
import org.apache.cassandra.stress.operations.predefined.ThriftCounterAdder;
import org.apache.cassandra.stress.operations.predefined.ThriftCounterGetter;
import org.apache.cassandra.stress.operations.predefined.ThriftInserter;
import org.apache.cassandra.stress.operations.predefined.ThriftReader;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.CqlVersion;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public abstract class PredefinedOperation
extends PartitionOperation {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public final Command type;
    private final Distribution columnCount;
    private Object cqlCache;

    public PredefinedOperation(Command type, Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(timer, settings, PredefinedOperation.spec(generator, seedManager, settings.insert.rowPopulationRatio.get()));
        this.type = type;
        this.columnCount = settings.columns.countDistribution.get();
    }

    private static PartitionOperation.DataSpec spec(PartitionGenerator generator, SeedManager seedManager, RatioDistribution rowPopulationCount) {
        return new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), rowPopulationCount, 1);
    }

    public boolean isCql3() {
        return this.settings.mode.cqlVersion == CqlVersion.CQL3;
    }

    public Object getCqlCache() {
        return this.cqlCache;
    }

    public void storeCqlCache(Object val) {
        this.cqlCache = val;
    }

    protected ByteBuffer getKey() {
        return (ByteBuffer)((PartitionIterator)this.partitions.get(0)).getPartitionKey(0);
    }

    public String toString() {
        return this.type.toString();
    }

    ColumnSelection select() {
        int c;
        if (this.settings.columns.slice) {
            int count = (int)this.columnCount.next();
            int start = count == this.settings.columns.maxColumnsPerKey ? 0 : 1 + ThreadLocalRandom.current().nextInt(this.settings.columns.maxColumnsPerKey - count);
            return new ColumnSelection(null, start, start + count);
        }
        int count = (int)this.columnCount.next();
        int totalCount = this.settings.columns.names.size();
        if (count == this.settings.columns.names.size()) {
            return new ColumnSelection(null, 0, count);
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int[] indices = new int[count];
        int o = 0;
        for (c = 0; c < count && count + o < totalCount; ++c) {
            int leeway = totalCount - (count + o);
            int spreadover = count - c;
            o = (int)((long)o + Math.round(rnd.nextDouble() * ((double)leeway / (double)spreadover)));
            indices[c] = o + c;
        }
        while (c < count) {
            indices[c] = o + c;
            ++c;
        }
        return new ColumnSelection(indices, 0, 0);
    }

    protected List<ByteBuffer> getColumnValues() {
        return this.getColumnValues(new ColumnSelection(null, 0, this.settings.columns.names.size()));
    }

    protected List<ByteBuffer> getColumnValues(ColumnSelection columns) {
        Row row = (Row)((PartitionIterator)this.partitions.get(0)).next();
        ByteBuffer[] r = new ByteBuffer[columns.count()];
        int c = 0;
        if (columns.indices != null) {
            for (int i : columns.indices) {
                r[c++] = (ByteBuffer)row.get(i);
            }
        } else {
            for (int i = columns.lb; i < columns.ub; ++i) {
                r[c++] = (ByteBuffer)row.get(i);
            }
        }
        return Arrays.asList(r);
    }

    public static Operation operation(Command type, Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings, DistributionFactory counteradd) {
        switch (type) {
            case READ: {
                switch (settings.mode.style) {
                    case THRIFT: {
                        return new ThriftReader(timer, generator, seedManager, settings);
                    }
                    case CQL: 
                    case CQL_PREPARED: {
                        return new CqlReader(timer, generator, seedManager, settings);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case COUNTER_READ: {
                switch (settings.mode.style) {
                    case THRIFT: {
                        return new ThriftCounterGetter(timer, generator, seedManager, settings);
                    }
                    case CQL: 
                    case CQL_PREPARED: {
                        return new CqlCounterGetter(timer, generator, seedManager, settings);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case WRITE: {
                switch (settings.mode.style) {
                    case THRIFT: {
                        return new ThriftInserter(timer, generator, seedManager, settings);
                    }
                    case CQL: 
                    case CQL_PREPARED: {
                        return new CqlInserter(timer, generator, seedManager, settings);
                    }
                }
                throw new UnsupportedOperationException();
            }
            case COUNTER_WRITE: {
                switch (settings.mode.style) {
                    case THRIFT: {
                        return new ThriftCounterAdder(counteradd, timer, generator, seedManager, settings);
                    }
                    case CQL: 
                    case CQL_PREPARED: {
                        return new CqlCounterAdder(counteradd, timer, generator, seedManager, settings);
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    final class ColumnSelection {
        final int[] indices;
        final int lb;
        final int ub;

        private ColumnSelection(int[] indices, int lb, int ub) {
            this.indices = indices;
            this.lb = lb;
            this.ub = ub;
        }

        public <V> List<V> select(List<V> in) {
            ArrayList<V> out = new ArrayList<V>();
            if (this.indices != null) {
                for (int i : this.indices) {
                    out.add(in.get(i));
                }
            } else {
                out.addAll(in.subList(this.lb, this.ub));
            }
            return out;
        }

        int count() {
            return this.indices != null ? this.indices.length : this.ub - this.lb;
        }

        SlicePredicate predicate() {
            SlicePredicate predicate = new SlicePredicate();
            if (this.indices == null) {
                predicate.setSlice_range(new SliceRange().setStart(PredefinedOperation.this.settings.columns.names.get(this.lb)).setFinish(EMPTY_BYTE_ARRAY).setReversed(false).setCount(this.count()));
            } else {
                predicate.setColumn_names(this.select(PredefinedOperation.this.settings.columns.names));
            }
            return predicate;
        }
    }
}

