/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class ExecutionTimesReport
implements AggregatedEventListener {
    public static final int DEFAULT_HISTORY_LENGTH = 10;
    private File hintsFile;
    private Map hints;
    private int historyLength = 10;
    private JUnit4 outer;

    public void setFile(File file) {
        this.hintsFile = file;
    }

    public void setHistoryLength(int n) {
        if (n < 0) {
            throw new BuildException("History length must be >= 1: " + n);
        }
        this.historyLength = n;
    }

    @Subscribe
    public void onSuiteResult(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        long l = aggregatedSuiteResultEvent.getExecutionTime();
        String string = aggregatedSuiteResultEvent.getDescription().getDisplayName();
        ArrayList<Long> arrayList = (ArrayList<Long>)this.hints.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Long>();
            this.hints.put(string, arrayList);
        }
        arrayList.add(l);
        while (arrayList.size() > this.historyLength) {
            arrayList.remove(0);
        }
    }

    @Subscribe
    public void onEnd(AggregatedQuitEvent aggregatedQuitEvent) {
        try {
            ExecutionTimesReport.writeHints(this.hintsFile, this.hints);
        }
        catch (IOException iOException) {
            this.outer.log("Could not write back the hints file.", iOException, 0);
        }
    }

    @Override
    public void setOuter(JUnit4 jUnit4) {
        if (this.hintsFile == null) {
            throw new BuildException("Execution times listener requires file attribute.");
        }
        try {
            if (this.hintsFile.isFile()) {
                this.hints = ExecutionTimesReport.readHints(this.hintsFile);
            } else {
                if (!this.hintsFile.createNewFile()) {
                    throw new BuildException("Could not create file: " + this.hintsFile.getAbsolutePath());
                }
                this.hints = new HashMap();
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read or create hints file: " + this.hintsFile.getAbsolutePath(), (Throwable)iOException);
        }
        this.outer = jUnit4;
    }

    public static Map readHints(File file) {
        HashMap hashMap = new HashMap();
        FileInputStream fileInputStream = new FileInputStream(file);
        ExecutionTimesReport.mergeHints(fileInputStream, hashMap);
        return hashMap;
    }

    public static void mergeHints(InputStream inputStream, Map map) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.startsWith("#")) continue;
            int n = string.indexOf(61);
            if (n <= 0) {
                throw new IOException("No '=' character on a non-comment line?: " + string);
            }
            String string2 = string.substring(0, n);
            ArrayList<Long> arrayList = (ArrayList<Long>)map.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<Long>();
                map.put(string2, arrayList);
            }
            for (String string3 : string.substring(n + 1).split("[\\,]")) {
                if (string3.isEmpty()) continue;
                arrayList.add(Long.parseLong(string3));
            }
        }
    }

    public static void writeHints(File file, Map treeMap) {
        try (Closer closer = Closer.create();){
            BufferedWriter bufferedWriter = (BufferedWriter)closer.register(Files.newWriter(file, Charsets.UTF_8));
            if (!(treeMap instanceof SortedMap)) {
                treeMap = new TreeMap(treeMap);
            }
            Joiner joiner = Joiner.on(',');
            for (Map.Entry entry : treeMap.entrySet()) {
                bufferedWriter.write((String)entry.getKey());
                bufferedWriter.write("=");
                joiner.appendTo((Appendable)bufferedWriter, (Iterable)entry.getValue());
                bufferedWriter.write("\n");
            }
        }
    }

    public static Map mergeHints(Collection collection, Collection collection2) {
        HashMap hashMap = new HashMap();
        for (ResourceCollection resourceCollection : collection) {
            Iterator iterator = resourceCollection.iterator();
            while (iterator.hasNext()) {
                InputStream inputStream = null;
                Resource resource = (Resource)iterator.next();
                try {
                    inputStream = resource.getInputStream();
                    ExecutionTimesReport.mergeHints(inputStream, hashMap);
                    if (collection2 == null) continue;
                    hashMap.keySet().retainAll(collection2);
                }
                catch (IOException iOException) {
                    throw new BuildException("Could not read hints from resource: " + resource.getDescription(), (Throwable)iOException);
                }
                finally {
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new BuildException("Could not close hints file: " + resource.getDescription());
                    }
                }
            }
        }
        return hashMap;
    }
}

