/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.TestRuleMarkFailure;

final class RemoveUponClose
implements Closeable {
    private final Path path;
    private final TestRuleMarkFailure failureMarker;
    private final String creationStack;

    public RemoveUponClose(Path path, TestRuleMarkFailure failureMarker) {
        this.path = path;
        this.failureMarker = failureMarker;
        StringBuilder b = new StringBuilder();
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            b.append('\t').append(e.toString()).append('\n');
        }
        this.creationStack = b.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.failureMarker.wasSuccessful() && Files.exists(this.path, new LinkOption[0])) {
            try {
                IOUtils.rm((Path[])new Path[]{this.path});
            }
            catch (IOException e) {
                throw new IOException("Could not remove temporary location '" + this.path.toAbsolutePath() + "', created at stack trace:\n" + this.creationStack, e);
            }
        }
    }
}

