/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.skeleton;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.skeleton.SkeletonPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonFisbone
extends HighLevelOggStreamPacket
implements SkeletonPacket {
    private static final int MESSAGE_HEADER_OFFSET = 52 - MAGIC_FISBONE_BYTES.length;
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private int messageHeaderOffset;
    private int serialNumber;
    private int numHeaderPackets;
    private long granulerateNumerator;
    private long granulerateDenominator;
    private long baseGranule;
    private int preroll;
    private byte granuleShift;
    private String contentType;
    private Map<String, String> messageHeaders = new HashMap<String, String>();

    public SkeletonFisbone() {
        this.messageHeaderOffset = MESSAGE_HEADER_OFFSET;
        this.contentType = OggStreamIdentifier.UNKNOWN.mimetype;
    }

    public SkeletonFisbone(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        if (!IOUtils.byteRangeMatches(MAGIC_FISBONE_BYTES, data, 0)) {
            throw new IllegalArgumentException("Invalid type, not a Skeleton Fisbone Header");
        }
        this.messageHeaderOffset = (int)IOUtils.getInt4(data, 8);
        if (this.messageHeaderOffset != MESSAGE_HEADER_OFFSET) {
            throw new IllegalArgumentException("Unsupported Skeleton message offset " + this.messageHeaderOffset + " detected");
        }
        this.serialNumber = (int)IOUtils.getInt4(data, 12);
        this.numHeaderPackets = (int)IOUtils.getInt4(data, 16);
        this.granulerateNumerator = IOUtils.getInt8(data, 20);
        this.granulerateDenominator = IOUtils.getInt8(data, 28);
        this.baseGranule = IOUtils.getInt8(data, 36);
        this.preroll = (int)IOUtils.getInt4(data, 44);
        this.granuleShift = data[48];
        String headers = IOUtils.getUTF8(data, 52, data.length - 52);
        if (!headers.contains(HEADER_CONTENT_TYPE)) {
            throw new IllegalArgumentException("No Content Type header found in " + headers);
        }
        StringTokenizer st = new StringTokenizer(headers, "\r\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            int splitAt = line.indexOf(": ");
            String k = line.substring(0, splitAt);
            String v = line.substring(splitAt + 2);
            this.messageHeaders.put(k, v);
            if (!HEADER_CONTENT_TYPE.equals(k)) continue;
            this.contentType = v;
        }
    }

    @Override
    public OggPacket write() {
        StringBuffer headersStr = new StringBuffer();
        for (String k : this.messageHeaders.keySet()) {
            headersStr.append(k);
            headersStr.append(": ");
            headersStr.append(this.messageHeaders.get(k));
            headersStr.append("\r\n");
        }
        byte[] headers = IOUtils.toUTF8Bytes(headersStr.toString());
        int size = 52 + headers.length;
        byte[] data = new byte[size];
        System.arraycopy(MAGIC_FISBONE_BYTES, 0, data, 0, 8);
        IOUtils.putInt4(data, 8, this.messageHeaderOffset);
        IOUtils.putInt4(data, 12, this.serialNumber);
        IOUtils.putInt4(data, 16, this.numHeaderPackets);
        IOUtils.putInt8(data, 20, this.granulerateNumerator);
        IOUtils.putInt8(data, 28, this.granulerateDenominator);
        IOUtils.putInt8(data, 36, this.baseGranule);
        IOUtils.putInt4(data, 44, this.preroll);
        data[48] = this.granuleShift;
        System.arraycopy(headers, 0, data, 52, headers.length);
        this.setData(data);
        return super.write();
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public int getNumHeaderPackets() {
        return this.numHeaderPackets;
    }

    public void setNumHeaderPackets(int numHeaderPackets) {
        this.numHeaderPackets = numHeaderPackets;
    }

    public long getGranulerateNumerator() {
        return this.granulerateNumerator;
    }

    public void setGranulerateNumerator(long granulerateNumerator) {
        this.granulerateNumerator = granulerateNumerator;
    }

    public long getGranulerateDenominator() {
        return this.granulerateDenominator;
    }

    public void setGranulerateDenominator(long granulerateDenominator) {
        this.granulerateDenominator = granulerateDenominator;
    }

    public long getBaseGranule() {
        return this.baseGranule;
    }

    public void setBaseGranule(long baseGranule) {
        this.baseGranule = baseGranule;
    }

    public int getPreroll() {
        return this.preroll;
    }

    public void setPreroll(int preroll) {
        this.preroll = preroll;
    }

    public byte getGranuleShift() {
        return this.granuleShift;
    }

    public void setGranuleShift(byte granuleShift) {
        this.granuleShift = granuleShift;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.messageHeaders.put(HEADER_CONTENT_TYPE, contentType);
    }

    public Map<String, String> getMessageHeaders() {
        return this.messageHeaders;
    }
}

