/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.types.discovery;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithOp;
import org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer;
import org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder;
import org.benf.cfr.reader.bytecode.analysis.types.JavaArrayTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericBaseInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericPlaceholderTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.types.StackType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.CastAction;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.util.BoolPair;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.MiscUtils;
import org.benf.cfr.reader.util.SetFactory;

public class InferredJavaType {
    private static int global_id = 0;
    private IJTInternal value;
    public static final InferredJavaType IGNORE = new InferredJavaType();

    public InferredJavaType() {
        this.value = new IJTInternal_Impl(RawJavaType.VOID, Source.UNKNOWN, false);
    }

    public InferredJavaType(JavaTypeInstance type, Source source) {
        this.value = new IJTInternal_Impl(type, source, false);
    }

    public InferredJavaType(JavaTypeInstance type, Source source, boolean locked) {
        this.value = new IJTInternal_Impl(type, source, locked);
    }

    private InferredJavaType(IJTInternal_Clash clash) {
        this.value = clash;
    }

    public static InferredJavaType mkClash(JavaTypeInstance ... types) {
        List ints = ListFactory.newList();
        for (JavaTypeInstance type : types) {
            ints.add(new IJTInternal_Impl(type, Source.UNKNOWN, false));
        }
        return new InferredJavaType(new IJTInternal_Clash(ints));
    }

    public Source getSource() {
        return this.value.getSource();
    }

    private void mergeGenericInfo(JavaGenericRefTypeInstance otherTypeInstance) {
        if (this.value.isLocked()) {
            return;
        }
        JavaGenericRefTypeInstance thisType = (JavaGenericRefTypeInstance)this.value.getJavaTypeInstance();
        if (!thisType.hasUnbound()) {
            return;
        }
        ClassFile degenerifiedThisClassFile = thisType.getDeGenerifiedType().getClassFile();
        if (degenerifiedThisClassFile == null) {
            return;
        }
        JavaGenericRefTypeInstance boundThisType = degenerifiedThisClassFile.getBindingSupers().getBoundAssignable(thisType, otherTypeInstance);
        if (!((Object)boundThisType).equals(thisType)) {
            InferredJavaType.mkDelegate(this.value, new IJTInternal_Impl(boundThisType, Source.GENERICCALL, true));
        }
    }

    public void noteUseAs(JavaTypeInstance type) {
        BindingSuperContainer bindingSuperContainer;
        if (this.value.getClashState() == ClashState.Clash && (bindingSuperContainer = this.getJavaTypeInstance().getBindingSupers()).containsBase(type.getDeGenerifiedType())) {
            this.value.forceType(type, false);
            this.value.markClashState(ClashState.Resolved);
        }
    }

    public void forceType(JavaTypeInstance type, boolean ignoreLockIfResolveClash) {
        boolean ignoreLock = this.value.isLocked() && this.value.getSource() == Source.RESOLVE_CLASH;
        this.value.forceType(type, ignoreLock);
    }

    public boolean isClash() {
        return this.value.getClashState() == ClashState.Clash;
    }

    public void collapseTypeClash() {
        this.value.collapseTypeClash();
    }

    public int getLocalId() {
        return this.value.getLocalId();
    }

    public int getTaggedBytecodeLocation() {
        return this.value.getTaggedBytecodeLocation();
    }

    public void setTaggedBytecodeLocation(int location) {
        this.value.setTaggedBytecodeLocation(location);
    }

    private boolean checkGenericCompatibility(JavaGenericRefTypeInstance thisType, JavaGenericRefTypeInstance otherType) {
        List<JavaTypeInstance> thisTypes = thisType.getGenericTypes();
        List<JavaTypeInstance> otherTypes = otherType.getGenericTypes();
        if (thisTypes.size() != otherTypes.size()) {
            return true;
        }
        int len = thisTypes.size();
        for (int x = 0; x < len; ++x) {
            JavaTypeInstance other1;
            JavaTypeInstance this1 = thisTypes.get(x);
            if (this.checkBaseCompatibility(this1, other1 = otherTypes.get(x))) continue;
            return false;
        }
        return true;
    }

    private boolean checkBaseCompatibility(JavaTypeInstance otherType) {
        return this.checkBaseCompatibility(this.getJavaTypeInstance(), otherType);
    }

    private boolean checkBaseCompatibility(JavaTypeInstance thisType, JavaTypeInstance otherType) {
        JavaTypeInstance otherStripped;
        if (thisType instanceof JavaGenericPlaceholderTypeInstance || otherType instanceof JavaGenericPlaceholderTypeInstance) {
            return thisType.equals(otherType);
        }
        JavaTypeInstance thisStripped = thisType.getDeGenerifiedType();
        if (thisStripped.equals(otherStripped = otherType.getDeGenerifiedType())) {
            boolean genericThis = thisType instanceof JavaGenericRefTypeInstance;
            boolean genericThat = otherType instanceof JavaGenericRefTypeInstance;
            if (genericThis && genericThat) {
                return this.checkGenericCompatibility((JavaGenericRefTypeInstance)thisType, (JavaGenericRefTypeInstance)otherType);
            }
            return true;
        }
        BindingSuperContainer otherSupers = otherType.getBindingSupers();
        if (otherSupers == null) {
            return true;
        }
        return otherSupers.containsBase(thisStripped);
    }

    private CastAction chainFrom(InferredJavaType other) {
        if (this == other) {
            return CastAction.None;
        }
        JavaTypeInstance thisTypeInstance = this.value.getJavaTypeInstance();
        JavaTypeInstance otherTypeInstance = other.value.getJavaTypeInstance();
        if (thisTypeInstance != RawJavaType.VOID) {
            boolean basecast = false;
            if (thisTypeInstance.isComplexType() && otherTypeInstance.isComplexType()) {
                if (!this.checkBaseCompatibility(other.getJavaTypeInstance())) {
                    this.value = IJTInternal_Clash.mkClash(this.value, other.value);
                    return CastAction.None;
                }
                if (this.value.getClashState() == ClashState.Resolved) {
                    return CastAction.None;
                }
                if (thisTypeInstance.getClass() == otherTypeInstance.getClass()) {
                    basecast = true;
                }
            }
            if (otherTypeInstance instanceof JavaGenericRefTypeInstance && thisTypeInstance instanceof JavaGenericRefTypeInstance) {
                other.mergeGenericInfo((JavaGenericRefTypeInstance)thisTypeInstance);
            }
            if (basecast) {
                return CastAction.None;
            }
            if (otherTypeInstance instanceof JavaGenericPlaceholderTypeInstance ^ thisTypeInstance instanceof JavaGenericPlaceholderTypeInstance) {
                return CastAction.InsertExplicit;
            }
        }
        InferredJavaType.mkDelegate(this.value, other.value);
        if (!other.value.isLocked()) {
            this.value = other.value;
        }
        return CastAction.None;
    }

    private static void mkDelegate(IJTInternal a, IJTInternal b) {
        if (a.getFinalId() != b.getFinalId()) {
            a.mkDelegate(b);
        }
    }

    public void forceDelegate(InferredJavaType other) {
        InferredJavaType.mkDelegate(this.value, other.value);
    }

    private CastAction chainIntegralTypes(InferredJavaType other) {
        if (this == other) {
            return CastAction.None;
        }
        int pri = this.getRawType().compareTypePriorityTo(other.getRawType());
        if (pri >= 0) {
            IJTInternal otherLocked;
            if (other.value.isLocked()) {
                if (pri > 0) {
                    return CastAction.InsertExplicit;
                }
                return CastAction.None;
            }
            if (pri > 0 && (otherLocked = other.value.getFirstLocked()) != null && otherLocked.getJavaTypeInstance() == other.getJavaTypeInstance()) {
                return CastAction.InsertExplicit;
            }
            InferredJavaType.mkDelegate(other.value, this.value);
        } else {
            if (this.value.isLocked()) {
                return CastAction.InsertExplicit;
            }
            InferredJavaType.mkDelegate(this.value, other.value);
            this.value = other.value;
        }
        return CastAction.None;
    }

    public static void compareAsWithoutCasting(InferredJavaType a, InferredJavaType b, boolean aLit, boolean bLit) {
        if (a == IGNORE) {
            return;
        }
        if (b == IGNORE) {
            return;
        }
        RawJavaType art = a.getRawType();
        RawJavaType brt = b.getRawType();
        if (art.getStackType() != StackType.INT || brt.getStackType() != StackType.INT) {
            return;
        }
        InferredJavaType litType = null;
        InferredJavaType betterType = null;
        Object litExp = null;
        BoolPair whichLit = BoolPair.get(a.getSource() == Source.LITERAL, b.getSource() == Source.LITERAL);
        if (whichLit.getCount() != 1) {
            whichLit = BoolPair.get(aLit, bLit);
        }
        if (art == RawJavaType.BOOLEAN && brt.getStackType() == StackType.INT && brt.compareTypePriorityTo(art) > 0) {
            litType = a;
            betterType = b;
        } else if (brt == RawJavaType.BOOLEAN && art.getStackType() == StackType.INT && art.compareTypePriorityTo(brt) > 0) {
            litType = b;
            betterType = a;
        } else {
            switch (whichLit) {
                case FIRST: {
                    litType = a;
                    betterType = b;
                    break;
                }
                case SECOND: {
                    litType = b;
                    betterType = a;
                    break;
                }
                case NEITHER: 
                case BOTH: {
                    return;
                }
            }
        }
        litType.chainFrom(betterType);
    }

    public void useAsWithCast(RawJavaType otherRaw) {
        if (this == IGNORE) {
            return;
        }
        this.value = new IJTInternal_Impl(otherRaw, Source.OPERATION, true);
    }

    public void useInArithOp(InferredJavaType other, RawJavaType otherRaw, boolean forbidBool) {
        if (this == IGNORE) {
            return;
        }
        if (other == IGNORE) {
            return;
        }
        RawJavaType thisRaw = this.getRawType();
        if (thisRaw.getStackType() != otherRaw.getStackType()) {
            return;
        }
        if (thisRaw.getStackType() == StackType.INT) {
            int cmp = thisRaw.compareTypePriorityTo(otherRaw);
            if (cmp < 0) {
                if (thisRaw == RawJavaType.BOOLEAN && forbidBool) {
                    this.value.forceType(otherRaw, false);
                }
            } else if (cmp == 0 && thisRaw == RawJavaType.BOOLEAN && forbidBool) {
                this.value.forceType(RawJavaType.INT, false);
            }
        }
    }

    public static void useInArithOp(InferredJavaType lhs, InferredJavaType rhs, ArithOp op) {
        boolean forbidBool = true;
        if ((op == ArithOp.OR || op == ArithOp.AND || op == ArithOp.XOR) && lhs.getJavaTypeInstance() == RawJavaType.BOOLEAN && rhs.getJavaTypeInstance() == RawJavaType.BOOLEAN) {
            forbidBool = false;
        }
        lhs.useInArithOp(rhs, rhs.getRawType(), forbidBool);
        RawJavaType lhsRawType = lhs.getRawType();
        switch (op) {
            case SHL: 
            case SHR: 
            case SHRU: {
                lhsRawType = RawJavaType.INT;
            }
        }
        rhs.useInArithOp(lhs, lhsRawType, forbidBool);
    }

    public void useAsWithoutCasting(JavaTypeInstance otherTypeInstance) {
        if (this == IGNORE) {
            return;
        }
        if (otherTypeInstance == TypeConstants.OBJECT) {
            return;
        }
        JavaTypeInstance thisTypeInstance = this.getJavaTypeInstance();
        if (thisTypeInstance == RawJavaType.NULL) {
            this.value.markKnownBaseClass(otherTypeInstance);
        }
        if (thisTypeInstance instanceof RawJavaType && otherTypeInstance instanceof RawJavaType) {
            RawJavaType otherRaw = otherTypeInstance.getRawTypeOfSimpleType();
            RawJavaType thisRaw = this.getRawType();
            if (thisRaw.getStackType() != otherRaw.getStackType()) {
                return;
            }
            if (thisRaw.getStackType() == StackType.INT) {
                int cmp = thisRaw.compareTypePriorityTo(otherRaw);
                if (cmp > 0) {
                    this.value.forceType(otherRaw, false);
                } else if (cmp < 0 && thisRaw == RawJavaType.BOOLEAN) {
                    this.value.forceType(otherRaw, false);
                }
            }
        } else if (thisTypeInstance instanceof JavaArrayTypeInstance && otherTypeInstance instanceof JavaArrayTypeInstance) {
            JavaArrayTypeInstance thisArrayTypeInstance = (JavaArrayTypeInstance)thisTypeInstance;
            JavaArrayTypeInstance otherArrayTypeInstance = (JavaArrayTypeInstance)otherTypeInstance;
            if (thisArrayTypeInstance.getNumArrayDimensions() != otherArrayTypeInstance.getNumArrayDimensions()) {
                return;
            }
            JavaTypeInstance thisStripped = thisArrayTypeInstance.getArrayStrippedType().getDeGenerifiedType();
            JavaTypeInstance otherArrayStripped = otherArrayTypeInstance.getArrayStrippedType();
            JavaTypeInstance otherStripped = otherArrayStripped.getDeGenerifiedType();
            if (otherArrayStripped instanceof JavaGenericBaseInstance) {
                return;
            }
            if (thisStripped instanceof JavaRefTypeInstance && otherStripped instanceof JavaRefTypeInstance) {
                JavaRefTypeInstance thisRef = (JavaRefTypeInstance)thisStripped;
                JavaRefTypeInstance otherRef = (JavaRefTypeInstance)otherStripped;
                BindingSuperContainer bindingSuperContainer = thisRef.getBindingSupers();
                if (bindingSuperContainer == null) {
                    if (otherRef == TypeConstants.OBJECT) {
                        this.value.forceType(otherTypeInstance, false);
                    }
                } else if (bindingSuperContainer.containsBase(otherRef)) {
                    this.value.forceType(otherTypeInstance, false);
                }
            }
        } else if (thisTypeInstance instanceof JavaGenericRefTypeInstance && otherTypeInstance instanceof JavaGenericRefTypeInstance) {
            this.improveGenericType((JavaGenericRefTypeInstance)otherTypeInstance);
        }
    }

    private void improveGenericType(JavaGenericRefTypeInstance otherGeneric) {
        JavaGenericRefTypeInstance thisUnbound;
        GenericTypeBinder thisBindings;
        JavaTypeInstance thisTypeInstance = this.getJavaTypeInstance();
        if (!(thisTypeInstance instanceof JavaGenericRefTypeInstance)) {
            throw new IllegalStateException();
        }
        JavaGenericRefTypeInstance thisGeneric = (JavaGenericRefTypeInstance)thisTypeInstance;
        JavaRefTypeInstance other = otherGeneric.getDeGenerifiedType();
        BindingSuperContainer thisBindingContainer = thisTypeInstance.getBindingSupers();
        if (thisBindingContainer == null) {
            return;
        }
        JavaGenericRefTypeInstance otherUnbound = thisBindingContainer.getBoundSuperForBase(other);
        if (otherUnbound == null) {
            return;
        }
        GenericTypeBinder otherBindings = GenericTypeBinder.extractBindings(otherUnbound, otherGeneric);
        GenericTypeBinder improvementBindings = otherBindings.createAssignmentRhsBindings(thisBindings = GenericTypeBinder.extractBindings(thisUnbound = thisBindingContainer.getBoundSuperForBase(thisGeneric.getDeGenerifiedType()), thisGeneric));
        if (improvementBindings == null) {
            return;
        }
        if (thisUnbound == null) {
            return;
        }
        JavaTypeInstance thisRebound = improvementBindings.getBindingFor(thisUnbound);
        if (thisRebound == null || thisRebound.equals(thisGeneric)) {
            return;
        }
        if (!(thisRebound instanceof JavaGenericRefTypeInstance)) {
            return;
        }
        this.value.forceType(thisRebound, true);
    }

    public void deGenerify(JavaTypeInstance other) {
        JavaTypeInstance typeInstanceThis = this.getJavaTypeInstance().getDeGenerifiedType();
        JavaTypeInstance typeInstanceOther = other.getDeGenerifiedType();
        if (!typeInstanceOther.equals(typeInstanceThis) && TypeConstants.OBJECT != typeInstanceThis) {
            throw new ConfusedCFRException("Incompatible types : " + typeInstanceThis.getClass() + "[" + typeInstanceThis + "] / " + typeInstanceOther.getClass() + "[" + typeInstanceOther + "]");
        }
        this.value.forceType(other, true);
    }

    public void applyKnownBaseType() {
        JavaTypeInstance type = this.value.getKnownBaseType();
        if (type == null) {
            return;
        }
        this.value.forceType(type, false);
    }

    public CastAction chain(InferredJavaType other) {
        if (this == IGNORE) {
            return CastAction.None;
        }
        if (other == IGNORE) {
            return CastAction.None;
        }
        if (other.getRawType() == RawJavaType.VOID) {
            return CastAction.None;
        }
        RawJavaType thisRaw = this.value.getRawType();
        RawJavaType otherRaw = other.getRawType();
        if (thisRaw == RawJavaType.VOID) {
            return this.chainFrom(other);
        }
        if (thisRaw.getStackType() != otherRaw.getStackType()) {
            if (MiscUtils.xor(thisRaw.getStackType(), otherRaw.getStackType(), StackType.REF)) {
                this.value = IJTInternal_Clash.mkClash(this.value, other.value);
            }
            return CastAction.InsertExplicit;
        }
        if (thisRaw == otherRaw && thisRaw.getStackType() != StackType.INT) {
            return this.chainFrom(other);
        }
        if (thisRaw == RawJavaType.NULL && (otherRaw == RawJavaType.NULL || otherRaw == RawJavaType.REF)) {
            return this.chainFrom(other);
        }
        if (thisRaw == RawJavaType.REF && otherRaw == RawJavaType.NULL) {
            return CastAction.None;
        }
        if (thisRaw.getStackType() == StackType.INT) {
            if (otherRaw.getStackType() != StackType.INT) {
                throw new IllegalStateException();
            }
            return this.chainIntegralTypes(other);
        }
        throw new ConfusedCFRException("Don't know how to tighten from " + thisRaw + " to " + otherRaw);
    }

    public RawJavaType getRawType() {
        return this.value.getRawType();
    }

    public JavaTypeInstance getJavaTypeInstance() {
        return this.value.getJavaTypeInstance();
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.value.getClashState() == ClashState.Clash ? " /* !! */ " : "";
    }

    private static class IJTInternal_Impl
    implements IJTInternal {
        private boolean isDelegate = false;
        private final boolean locked;
        private JavaTypeInstance type;
        private JavaTypeInstance knownBase;
        private int taggedBytecodeLocation = -1;
        private final Source source;
        private final int id;
        private IJTInternal delegate;

        private IJTInternal_Impl(JavaTypeInstance type, Source source, boolean locked) {
            this.type = type;
            this.source = source;
            this.id = global_id++;
            this.locked = locked;
        }

        @Override
        public RawJavaType getRawType() {
            if (this.isDelegate) {
                return this.delegate.getRawType();
            }
            return this.type.getRawTypeOfSimpleType();
        }

        @Override
        public int getTaggedBytecodeLocation() {
            if (this.isDelegate) {
                return this.delegate.getTaggedBytecodeLocation();
            }
            return this.taggedBytecodeLocation;
        }

        @Override
        public void setTaggedBytecodeLocation(int location) {
            if (this.isDelegate) {
                this.delegate.setTaggedBytecodeLocation(location);
            } else {
                this.taggedBytecodeLocation = location;
            }
        }

        @Override
        public JavaTypeInstance getJavaTypeInstance() {
            if (this.isDelegate) {
                return this.delegate.getJavaTypeInstance();
            }
            return this.type;
        }

        @Override
        public Source getSource() {
            if (this.isDelegate) {
                return this.delegate.getSource();
            }
            return this.source;
        }

        @Override
        public void collapseTypeClash() {
            if (this.isDelegate) {
                this.delegate.collapseTypeClash();
            }
        }

        @Override
        public int getFinalId() {
            if (this.isDelegate) {
                return this.delegate.getFinalId();
            }
            return this.id;
        }

        @Override
        public int getLocalId() {
            return this.id;
        }

        @Override
        public ClashState getClashState() {
            return ClashState.None;
        }

        @Override
        public void mkDelegate(IJTInternal newDelegate) {
            if (this.isDelegate) {
                this.delegate.mkDelegate(newDelegate);
            } else {
                this.isDelegate = true;
                this.delegate = newDelegate;
            }
        }

        @Override
        public void markKnownBaseClass(JavaTypeInstance newKnownBase) {
            if (this.isDelegate) {
                this.delegate.markKnownBaseClass(newKnownBase);
                return;
            }
            if (this.knownBase == null) {
                this.knownBase = newKnownBase;
            } else {
                BindingSuperContainer boundSupers = this.knownBase.getBindingSupers();
                if (boundSupers == null || !boundSupers.containsBase(newKnownBase.getDeGenerifiedType())) {
                    this.knownBase = newKnownBase;
                }
            }
        }

        @Override
        public JavaTypeInstance getKnownBaseType() {
            if (this.isDelegate) {
                return this.delegate.getKnownBaseType();
            }
            return this.knownBase;
        }

        @Override
        public void forceType(JavaTypeInstance rawJavaType, boolean ignoreLock) {
            if (!ignoreLock && this.isLocked()) {
                return;
            }
            if (this.isDelegate && this.delegate.isLocked() && !ignoreLock) {
                this.isDelegate = false;
            }
            if (this.isDelegate) {
                this.delegate.forceType(rawJavaType, ignoreLock);
            } else {
                this.type = rawJavaType;
            }
        }

        @Override
        public void markClashState(ClashState newClashState) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.isDelegate) {
                return "#" + this.id + " -> " + this.delegate.toString();
            }
            return "#" + this.id + " " + this.type.toString();
        }

        @Override
        public boolean isLocked() {
            return this.locked;
        }

        @Override
        public IJTInternal getFirstLocked() {
            if (this.locked) {
                return this;
            }
            if (this.delegate != null) {
                return this.delegate.getFirstLocked();
            }
            return null;
        }
    }

    private static class IJTInternal_Clash
    implements IJTInternal {
        private boolean resolved = false;
        private List<IJTInternal> clashes;
        private final int id = InferredJavaType.access$008();
        private JavaTypeInstance type = null;

        private IJTInternal_Clash(Collection<IJTInternal> clashes) {
            this.clashes = ListFactory.newList(clashes);
        }

        private static Map<JavaTypeInstance, JavaGenericRefTypeInstance> getMatches(List<IJTInternal> clashes) {
            Map<JavaTypeInstance, JavaGenericRefTypeInstance> matches = MapFactory.newMap();
            IJTInternal clash = clashes.get(0);
            JavaTypeInstance clashType = clash.getJavaTypeInstance();
            BindingSuperContainer otherSupers = clashType.getBindingSupers();
            if (otherSupers != null) {
                Map<JavaRefTypeInstance, JavaGenericRefTypeInstance> boundSupers = otherSupers.getBoundSuperClasses();
                matches.putAll(boundSupers);
            }
            int len = clashes.size();
            for (int x = 1; x < len; ++x) {
                IJTInternal clash2 = clashes.get(x);
                JavaTypeInstance clashType2 = clash2.getJavaTypeInstance();
                BindingSuperContainer otherSupers2 = clashType2.getBindingSupers();
                if (otherSupers2 == null) continue;
                Map<JavaRefTypeInstance, JavaGenericRefTypeInstance> boundSupers = otherSupers2.getBoundSuperClasses();
                Iterator<Map.Entry<JavaTypeInstance, JavaGenericRefTypeInstance>> iterator = matches.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<JavaTypeInstance, JavaGenericRefTypeInstance> entry = iterator.next();
                    if (boundSupers.containsKey(entry.getKey())) continue;
                    iterator.remove();
                }
            }
            return matches;
        }

        private static IJTInternal mkClash(IJTInternal delegate1, IJTInternal delegate2) {
            List<IJTInternal> clashes = ListFactory.newList();
            if (delegate1 instanceof IJTInternal_Clash) {
                for (IJTInternal clash : ((IJTInternal_Clash)delegate1).clashes) {
                    clashes.add(clash);
                }
            } else {
                clashes.add(delegate1);
            }
            if (delegate2 instanceof IJTInternal_Clash) {
                for (IJTInternal clash : ((IJTInternal_Clash)delegate2).clashes) {
                    clashes.add(clash);
                }
            } else {
                clashes.add(delegate2);
            }
            Map<JavaTypeInstance, JavaGenericRefTypeInstance> matches = IJTInternal_Clash.getMatches(clashes);
            if (matches.isEmpty()) {
                return new IJTInternal_Impl(TypeConstants.OBJECT, Source.RESOLVE_CLASH, true);
            }
            if (matches.size() == 1) {
                return new IJTInternal_Impl(matches.keySet().iterator().next(), Source.RESOLVE_CLASH, true);
            }
            return new IJTInternal_Clash(clashes);
        }

        @Override
        public void collapseTypeClash() {
            if (this.resolved) {
                return;
            }
            Map<JavaTypeInstance, JavaGenericRefTypeInstance> matches = IJTInternal_Clash.getMatches(this.clashes);
            if (matches.isEmpty()) {
                this.type = TypeConstants.OBJECT;
                this.resolved = true;
                return;
            }
            List<JavaTypeInstance> poss = ListFactory.newList(matches.keySet());
            boolean effect = true;
            block0: do {
                effect = false;
                for (JavaTypeInstance pos : poss) {
                    BindingSuperContainer superContainer = pos.getBindingSupers();
                    if (superContainer == null) continue;
                    Set<JavaRefTypeInstance> supers = SetFactory.newSet(superContainer.getBoundSuperClasses().keySet());
                    supers.remove(pos);
                    if (!poss.removeAll(supers)) continue;
                    effect = true;
                    continue block0;
                }
            } while (effect);
            JavaTypeInstance oneClash = this.clashes.get(0).getJavaTypeInstance();
            Map<JavaRefTypeInstance, BindingSuperContainer.Route> routes = oneClash.getBindingSupers().getBoundSuperRoute();
            if (poss.isEmpty()) {
                poss = ListFactory.newList(matches.keySet());
            }
            for (JavaTypeInstance pos : poss) {
                if (BindingSuperContainer.Route.EXTENSION != routes.get(pos)) continue;
                this.type = pos;
                this.resolved = true;
                return;
            }
            this.type = poss.get(0);
            this.resolved = true;
        }

        @Override
        public RawJavaType getRawType() {
            if (this.resolved) {
                return this.type.getRawTypeOfSimpleType();
            }
            return this.clashes.get(0).getRawType();
        }

        @Override
        public int getTaggedBytecodeLocation() {
            return -1;
        }

        @Override
        public void setTaggedBytecodeLocation(int location) {
        }

        @Override
        public JavaTypeInstance getJavaTypeInstance() {
            if (this.resolved) {
                return this.type;
            }
            return this.clashes.get(0).getJavaTypeInstance();
        }

        @Override
        public Source getSource() {
            return this.clashes.get(0).getSource();
        }

        @Override
        public int getFinalId() {
            return this.id;
        }

        @Override
        public int getLocalId() {
            return this.id;
        }

        @Override
        public ClashState getClashState() {
            if (this.resolved) {
                return ClashState.Resolved;
            }
            return ClashState.Clash;
        }

        @Override
        public void mkDelegate(IJTInternal newDelegate) {
        }

        @Override
        public void forceType(JavaTypeInstance rawJavaType, boolean ignoreLock) {
            this.type = rawJavaType;
            this.resolved = true;
        }

        @Override
        public void markKnownBaseClass(JavaTypeInstance knownBase) {
        }

        @Override
        public JavaTypeInstance getKnownBaseType() {
            return null;
        }

        @Override
        public void markClashState(ClashState newClashState) {
        }

        @Override
        public boolean isLocked() {
            return this.resolved;
        }

        @Override
        public IJTInternal getFirstLocked() {
            return null;
        }

        public String toString() {
            if (this.resolved) {
                return "#" + this.id + " " + this.type.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (IJTInternal clash : this.clashes) {
                sb.append(this.id).append(" -> ").append(clash.toString()).append(", ");
            }
            return sb.toString();
        }
    }

    private static interface IJTInternal {
        public RawJavaType getRawType();

        public JavaTypeInstance getJavaTypeInstance();

        public Source getSource();

        public int getLocalId();

        public int getFinalId();

        public ClashState getClashState();

        public void collapseTypeClash();

        public void mkDelegate(IJTInternal var1);

        public void forceType(JavaTypeInstance var1, boolean var2);

        public void markKnownBaseClass(JavaTypeInstance var1);

        public JavaTypeInstance getKnownBaseType();

        public void markClashState(ClashState var1);

        public boolean isLocked();

        public IJTInternal getFirstLocked();

        public int getTaggedBytecodeLocation();

        public void setTaggedBytecodeLocation(int var1);
    }

    private static enum ClashState {
        None,
        Clash,
        Resolved;

    }

    public static enum Source {
        TEST,
        UNKNOWN,
        LITERAL,
        FIELD,
        FUNCTION,
        OPERATION,
        EXPRESSION,
        INSTRUCTION,
        GENERICCALL,
        EXCEPTION,
        STRING_TRANSFORM,
        IMPROVED_ITERATION,
        RESOLVE_CLASH;

    }
}

