/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpterminal;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.gtpterminal.GtpTerminal;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"config:", "help", "size:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                return;
            }
            if (options.isSet("version")) {
                System.out.println("GtpTerminal " + Version.get());
                return;
            }
            int n = options.getInteger("size", 19, 1, 25);
            boolean bl = options.isSet("verbose");
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() != 1) {
                Main.printUsage(System.err);
                System.exit(-1);
            }
            String string = (String)arrayList.get(0);
            GtpTerminal gtpTerminal = new GtpTerminal(string, n, bl);
            gtpTerminal.mainLoop();
            gtpTerminal.close();
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private Main() {
    }

    private static void printUsage(PrintStream printStream) {
        String string = "Usage: java -jar gtpterminal.jar program\n\n-config       config file\n-help         print help and exit\n-size n       board size (default 19)\n-verbose      print debug information\n-version      print version and exit\n";
        printStream.print(string);
    }
}

