/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;

public abstract class AbstractPlugin
implements Plugin,
Comparable {
    protected static final int PATTERN_PARAM = 10;
    protected static final String CRLF = "\r\n";
    private HostProcess parent = null;
    private HttpMessage msg = null;
    private Log log = LogFactory.getLog(this.getClass());
    private Configuration config = null;

    public abstract int getId();

    public abstract String getName();

    public String getCodeName() {
        String string = this.getClass().getName();
        int n = this.getClass().getName().lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public abstract String[] getDependency();

    public abstract String getDescription();

    public abstract int getCategory();

    public abstract String getSolution();

    public abstract String getReference();

    public void init(HttpMessage httpMessage, HostProcess hostProcess) {
        this.msg = httpMessage.cloneAll();
        this.parent = hostProcess;
        this.init();
    }

    public abstract void init();

    protected HttpMessage getNewMsg() {
        return this.msg.cloneRequest();
    }

    protected HttpMessage getBaseMsg() {
        return this.msg;
    }

    protected void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, true);
    }

    protected void sendAndReceive(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        httpMessage.getRequestHeader().setContentLength(httpMessage.getRequestBody().length());
        this.parent.getHttpSender().sendAndReceive(httpMessage, bl);
    }

    public void run() {
        try {
            if (!this.isStop()) {
                this.scan();
            }
        }
        catch (Exception exception) {
            this.getLog().warn(exception.getMessage());
        }
        this.notifyPluginCompleted(this.getParent());
    }

    public abstract void scan();

    protected void bingo(int n, int n2, String string, String string2, String string3, HttpMessage httpMessage) {
        this.bingo(n, n2, this.getName(), this.getDescription(), string, string2, string3, this.getSolution(), httpMessage);
    }

    protected void bingo(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, HttpMessage httpMessage) {
        Alert alert = new Alert(this.getId(), n, n2, string);
        if (string3 == null || string3.equals("")) {
            string3 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (string4 == null) {
            string4 = "";
        }
        alert.setDetail(string2, string3, string4, string5, string6, this.getReference(), httpMessage);
        this.parent.alertFound(alert);
    }

    protected boolean isFileExist(HttpMessage httpMessage) {
        return this.parent.getAnalyser().isFileExist(httpMessage);
    }

    protected boolean isStop() {
        return this.parent.isStop();
    }

    public boolean isEnabled() {
        return this.getProperty("enabled").equals("1");
    }

    public boolean isVisible() {
        return true;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.setProperty("enabled", "1");
        } else {
            this.setProperty("enabled", "0");
        }
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof AbstractPlugin) {
            AbstractPlugin abstractPlugin = (AbstractPlugin)object;
            n = this.getId() < abstractPlugin.getId() ? -1 : (this.getId() > abstractPlugin.getId() ? 1 : 0);
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    protected boolean matchHeaderPattern(HttpMessage httpMessage, String string, Pattern pattern) {
        if (httpMessage.getResponseHeader().isEmpty()) {
            return false;
        }
        String string2 = httpMessage.getResponseHeader().getHeader(string);
        if (string2 == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string2);
        return matcher.find();
    }

    protected boolean matchBodyPattern(HttpMessage httpMessage, Pattern pattern, StringBuffer stringBuffer) {
        Matcher matcher = pattern.matcher(httpMessage.getResponseBody().toString());
        boolean bl = matcher.find();
        if (bl && stringBuffer != null) {
            stringBuffer.append(matcher.group());
        }
        return bl;
    }

    protected void writeProgress(String string) {
    }

    protected HostProcess getParent() {
        return this.parent;
    }

    public abstract void notifyPluginCompleted(HostProcess var1);

    protected String stripOff(String string, String string2) {
        String string3 = AbstractPlugin.getURLEncode(string2);
        String string4 = AbstractPlugin.getURLDecode(string2);
        String string5 = AbstractPlugin.getHTMLEncode(string2);
        String string6 = AbstractPlugin.getHTMLEncode(string3);
        String string7 = AbstractPlugin.getHTMLEncode(string4);
        String string8 = string.replaceAll("\\Q" + string2 + "\\E", "").replaceAll("\\Q" + string3 + "\\E", "").replaceAll("\\Q" + string4 + "\\E", "");
        string8 = string8.replaceAll("\\Q" + string5 + "\\E", "").replaceAll("\\Q" + string6 + "\\E", "").replaceAll("\\Q" + string7 + "\\E", "");
        return string8;
    }

    public static String getURLEncode(String string) {
        String string2 = "";
        try {
            string2 = URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getURLDecode(String string) {
        String string2 = "";
        try {
            string2 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String getHTMLEncode(String string) {
        String string2 = string.replaceAll("<", "&#60;");
        string2 = string2.replaceAll(">", "&#62;");
        return string2;
    }

    protected Kb getKb() {
        return this.getParent().getKb();
    }

    protected Log getLog() {
        return this.log;
    }

    public String getProperty(String string) {
        return this.config.getString("plugins.p" + this.getId() + "." + string);
    }

    public void setProperty(String string, String string2) {
        this.config.setProperty("plugins.p" + this.getId() + "." + string, string2);
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void createParamIfNotExist() {
        if (this.getProperty("enabled") == null) {
            this.setProperty("enabled", "1");
        }
    }
}

