/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sftp;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jcraft.jsch.JSch;
import com.jetbrains.plugins.webDeployment.config.sftp.HostKeyCheckingLevel;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;

public class SftpAdvancedOptions
implements Cloneable {
    @Attribute(value="hostKeyCheckingLevel")
    private HostKeyCheckingLevel myHostKeyCheckingLevel = HostKeyCheckingLevel.ASK;
    @Attribute(value="hashKnownHosts")
    private boolean myHashHost = !SystemInfo.isMac;

    public HostKeyCheckingLevel getHostKeyCheckingLevel() {
        return this.myHostKeyCheckingLevel;
    }

    public void setHostKeyCheckingLevel(HostKeyCheckingLevel hostKeyCheckingLevel) {
        this.myHostKeyCheckingLevel = hostKeyCheckingLevel;
    }

    public boolean getHashHost() {
        return this.myHashHost;
    }

    public void setHashHost(boolean hashHost) {
        this.myHashHost = hashHost;
    }

    public void applyTo(FileSystemOptions options) throws FileSystemException {
        JSch.setConfig((String)"HashKnownHosts", (String)(this.myHashHost ? "yes" : "no"));
        this.myHostKeyCheckingLevel.apply(options);
    }

    public SftpAdvancedOptions clone() {
        try {
            return (SftpAdvancedOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cloneable is broken");
        }
    }
}

