/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringUtil {
    private static final String arrName = "$_$Arr$_$";

    private JSDestructuringUtil() {
    }

    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSElement element) {
        if (element == null) {
            JSDestructuringUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isDestructuring(@Nullable PsiElement parent) {
        return parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            JSDestructuringUtil.$$$reportNull$$$0(1);
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_ARRAY_REST == parent.getElementType()) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(2);
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            JSExpression initializer;
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializer()) != null) {
                return initializer;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static JSExpression getNearestInitializerStubSafely(@NotNull JSVariable var) {
        if (var == null) {
            JSDestructuringUtil.$$$reportNull$$$0(3);
        }
        JSVariable context = var;
        do {
            JSExpression initializer;
            if (!(context instanceof JSInitializerOwner) || (initializer = ((JSInitializerOwner)context).getInitializerOrStub()) == null) continue;
            return initializer;
        } while (JSDestructuringUtil.isDestructuring((PsiElement)(context = context.getContext())));
        return null;
    }

    @Nullable
    public static JSExpression getDestructuringAssignmentInitializer(@NotNull JSExpression expression) {
        if (expression == null) {
            JSDestructuringUtil.$$$reportNull$$$0(4);
        }
        PsiElement parent = expression.getParent();
        while (parent instanceof JSProperty || parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression || parent instanceof JSSpreadExpression) {
            parent = parent.getParent();
        }
        return parent instanceof JSDefinitionExpression ? ((JSDefinitionExpression)parent).getInitializer() : null;
    }

    public static boolean parentIsDestructuringAssignmentLHS(@Nullable JSExpression referenceExpression) {
        return referenceExpression != null && JSDestructuringUtil.getDestructuringAssignmentInitializer(referenceExpression) != null;
    }

    @Contract(value="null -> false")
    public static boolean arrayLiteralCorrespondsToDestructuringArray(@Nullable JSExpression arrayLiteral) {
        JSDestructuringElement destructuringElement = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)arrayLiteral, JSDestructuringElement.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
        if (destructuringElement == null) {
            return false;
        }
        JSExpression init = destructuringElement.getInitializer();
        if (init == null) {
            return false;
        }
        JSDestructuringContainer target = destructuringElement.getTarget();
        Stack items = new Stack();
        JSExpression expr = arrayLiteral;
        while (expr != null) {
            if (expr instanceof JSArrayLiteralExpression) {
                items.add((Object)arrName);
                if (expr == init) break;
                expr = expr.getParent();
                continue;
            }
            if (expr instanceof JSProperty) {
                items.add((Object)((JSProperty)expr).getName());
                expr = PsiTreeUtil.getParentOfType((PsiElement)expr, JSObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
                if (expr == init) break;
                if (expr == null) continue;
                expr = expr.getParent();
                continue;
            }
            PsiElement parent = expr.getParent();
            if (parent instanceof JSArrayLiteralExpression) {
                items.add((Object)String.valueOf(ArrayUtil.indexOf((Object[])((JSArrayLiteralExpression)parent).getExpressions(), (Object)expr)));
                if (parent == init) break;
                expr = parent.getParent();
                continue;
            }
            if (parent instanceof JSProperty) {
                items.add((Object)((JSProperty)parent).getName());
                expr = PsiTreeUtil.getParentOfType((PsiElement)expr, JSObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
                if (expr == init) break;
                if (expr == null) continue;
                expr = parent.getParent();
                continue;
            }
            return false;
        }
        while (!items.empty()) {
            JSDestructuringContainer initializer;
            JSInitializerOwner element;
            int i;
            String item = (String)items.pop();
            if (Objects.equals(item, arrName)) {
                return target instanceof JSDestructuringArray;
            }
            if (target instanceof JSDestructuringObject) {
                JSDestructuringContainer initializer2;
                JSInitializerOwner element2;
                Optional<JSDestructuringProperty> prop = Arrays.stream(((JSDestructuringObject)target).getProperties()).filter(p -> Objects.equals(item, p.getName())).findAny();
                if (prop.isPresent() && (element2 = prop.get().getDestructuringElement()) instanceof JSDestructuringElement && (initializer2 = ((JSDestructuringElement)element2).getTarget()) != null) {
                    target = initializer2;
                    continue;
                }
                return false;
            }
            if (!(target instanceof JSDestructuringArray)) continue;
            JSInitializerOwner[] elements = ((JSDestructuringArray)target).getElements();
            try {
                i = Integer.parseInt(item);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (i >= 0 && i < elements.length && (element = elements[i]) instanceof JSDestructuringElement && (initializer = ((JSDestructuringElement)element).getTarget()) != null) {
                target = initializer;
                continue;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static JSInitializerOwner findDestructuringParent(@NotNull JSElement destructuringElement, @NotNull JSEvaluateContext context, @NotNull Condition<? super JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            JSDestructuringUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSDestructuringUtil.$$$reportNull$$$0(6);
        }
        if (parentCondition == null) {
            JSDestructuringUtil.$$$reportNull$$$0(7);
        }
        JSElement element = destructuringElement;
        JSElement prevElement = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.value((Object)((JSInitializerOwner)element))) {
                return (JSInitializerOwner)element;
            }
            if (element instanceof JSDestructuringArray) {
                context.pushJSElementToApply(new JSApplyIndexedAccessElement((JSDestructuringArray)element, (PsiElement)prevElement));
            } else if (element instanceof JSDestructuringProperty) {
                context.pushJSElementToApply(new JSApplyPropertyElement((JSDestructuringProperty)element));
            }
            prevElement = element;
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public static List<JSReferenceExpression> collectAssignmentTargets(@NotNull JSExpression pattern) {
        if (pattern == null) {
            JSDestructuringUtil.$$$reportNull$$$0(8);
        }
        assert (pattern instanceof JSObjectLiteralExpression || pattern instanceof JSArrayLiteralExpression);
        final ArrayList result2 = ContainerUtil.newArrayList();
        pattern.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSDefinitionExpression definition = node.getDefinitionExpression();
                if (definition != null) {
                    definition.accept((PsiElementVisitor)this);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                super.visitJSReferenceExpression(node);
                result2.add(node);
            }
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSDestructuringUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean hasSingleProperty(@NotNull JSDestructuringObject objectPattern) {
        if (objectPattern == null) {
            JSDestructuringUtil.$$$reportNull$$$0(10);
        }
        return objectPattern.getProperties().length == 1;
    }

    public static boolean hasSingleElement(@NotNull JSDestructuringArray arrayPattern) {
        if (arrayPattern == null) {
            JSDestructuringUtil.$$$reportNull$$$0(11);
        }
        return arrayPattern.getRestElement() != null && arrayPattern.getElements().length == 0 || arrayPattern.getElements().length == 1 && arrayPattern.getRestElement() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCondition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSDestructuringUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectPattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignmentTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkippingDestructuring";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNearestDestructuringInitializer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNearestInitializerStubSafely";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDestructuringAssignmentInitializer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignmentTargets";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

