/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JSDirectiveCommentUtil {
    private static final String[] GLOBAL_DIRECTIVES = new String[]{"globals", "global"};
    private static final String[] ALL_DIRECTIVES = new String[]{"jshint", "jslint", "exported", "globals", "global", "properties", "property", "members", "member"};
    private static final String COMMENT_PREFIX = "/*";

    private JSDirectiveCommentUtil() {
    }

    public static boolean isDirectiveCommentTokenType(PsiComment comment) {
        return JSTokenTypes.C_STYLE_COMMENT.equals(comment.getTokenType());
    }

    public static boolean isDirectiveCommentTokenType(IElementType tokenType) {
        return JSTokenTypes.C_STYLE_COMMENT.equals(tokenType);
    }

    public static int getGlobalDirectiveBodyStartIndex(@NotNull CharSequence comment) {
        if (comment == null) {
            JSDirectiveCommentUtil.$$$reportNull$$$0(0);
        }
        return JSDirectiveCommentUtil.getDirectiveCommentBodyStartIndex(comment, GLOBAL_DIRECTIVES);
    }

    public static boolean isDirectiveComment(CharSequence comment) {
        return JSDirectiveCommentUtil.getDirectiveCommentBodyStartIndex(comment, ALL_DIRECTIVES) != -1;
    }

    private static int getDirectiveCommentBodyStartIndex(CharSequence comment, String[] directives) {
        int startInd;
        if (!StringUtil.startsWith((CharSequence)comment, (CharSequence)COMMENT_PREFIX)) {
            return -1;
        }
        int textLength = comment.length();
        for (startInd = COMMENT_PREFIX.length(); startInd < textLength && Character.isWhitespace(comment.charAt(startInd)); ++startInd) {
        }
        if (startInd == textLength) {
            return -1;
        }
        if (!Character.isLetter(comment.charAt(startInd))) {
            return -1;
        }
        for (String directive : directives) {
            int endIndex;
            int directiveLength = directive.length();
            if (!CharArrayUtil.regionMatches((CharSequence)comment, (int)startInd, (CharSequence)directive) || (endIndex = startInd + directiveLength) >= textLength) continue;
            char endChar = comment.charAt(endIndex);
            if (endIndex != textLength - 2 && !Character.isWhitespace(endChar)) continue;
            return endIndex;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/psi/util/JSDirectiveCommentUtil", "getGlobalDirectiveBodyStartIndex"));
    }
}

