/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.util.NoopVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ILocalVariableVisitor
extends NoopVisitor {
    private List<ILocalVariable> list = new ArrayList<ILocalVariable>();
    private String name;
    private IScope scope;

    public static List<ILocalVariable> findOccurrencesIn(IScope scope, String name) {
        ILocalVariableVisitor visitor = new ILocalVariableVisitor(scope, name);
        visitor.run();
        return visitor.getVariableList();
    }

    public ILocalVariableVisitor(IScope scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public void run() {
        for (Node child : ((Node)((Object)this.scope)).childNodes()) {
            child.accept(this);
        }
    }

    public List<ILocalVariable> getVariableList() {
        return this.list;
    }

    private void addVariableIfInScopeAndRightName(ILocalVariable variable) {
        if (variable.getDefinedScope() == this.scope && this.name.equals(variable.getName())) {
            this.list.add(variable);
        }
    }

    @Override
    public Object visitArgumentNode(ArgumentNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        return null;
    }

    @Override
    public Object visitBlockArgNode(BlockArgNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        return null;
    }

    @Override
    public Object visitClassNode(ClassNode iVisited) {
        return null;
    }

    @Override
    public Object visitDAsgnNode(DAsgnNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        this.visit(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitDVarNode(DVarNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        return null;
    }

    @Override
    public Object visitDefnNode(DefnNode iVisited) {
        return null;
    }

    @Override
    public Object visitDefsNode(DefsNode iVisited) {
        return null;
    }

    @Override
    public Object visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        this.visit(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitLocalVarNode(LocalVarNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        return null;
    }

    @Override
    public Object visitModuleNode(ModuleNode iVisited) {
        return null;
    }

    @Override
    public Object visitRestArgNode(RestArgNode iVisited) {
        this.addVariableIfInScopeAndRightName(iVisited);
        return null;
    }

    @Override
    public Object visitRootNode(RootNode iVisited) {
        return null;
    }

    @Override
    public Object visitSClassNode(SClassNode iVisited) {
        return null;
    }
}

