/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;

public class CloudTerminalRunner
extends AbstractTerminalRunner<CloudTerminalProcess> {
    private final String myPipeName;
    private final CloudTerminalProcess myProcess;

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process) {
        if (project == null) {
            CloudTerminalRunner.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPipeName = pipeName;
        this.myProcess = process;
    }

    @Override
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        if (parent == null) {
            CloudTerminalRunner.$$$reportNull$$$0(1);
        }
        JBTerminalWidget jBTerminalWidget = super.createTerminalWidget(parent, currentWorkingDirectory, false);
        if (jBTerminalWidget == null) {
            CloudTerminalRunner.$$$reportNull$$$0(2);
        }
        return jBTerminalWidget;
    }

    @Override
    protected CloudTerminalProcess createProcess(@Nullable String directory) throws ExecutionException {
        return this.myProcess;
    }

    @Override
    protected ProcessHandler createProcessHandler(final CloudTerminalProcess process) {
        return new ProcessHandler(){

            protected void destroyProcessImpl() {
                process.destroy();
            }

            protected void detachProcessImpl() {
                process.destroy();
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return process.getOutputStream();
            }
        };
    }

    @Override
    protected String getTerminalConnectionName(CloudTerminalProcess process) {
        return "Terminal: " + this.myPipeName;
    }

    @Override
    protected TtyConnector createTtyConnector(CloudTerminalProcess process) {
        return new ProcessTtyConnector(process, Charset.defaultCharset()){

            protected void resizeImmediately() {
            }

            public String getName() {
                return "Connector: " + CloudTerminalRunner.this.myPipeName;
            }

            public boolean isConnected() {
                return true;
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Cloud terminal";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/cloud/CloudTerminalRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalWidget";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

