/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.XmlElementVisitor;
import java.util.List;

public class XmlRecursiveElementVisitor
extends XmlElementVisitor
implements PsiRecursiveVisitor {
    private final boolean myVisitAllFileRoots;

    public XmlRecursiveElementVisitor() {
        this.myVisitAllFileRoots = false;
    }

    public XmlRecursiveElementVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        element.acceptChildren(this);
    }

    @Override
    public void visitFile(PsiFile file) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file.getViewProvider()).getAllFiles()).size() > 1 && file == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file);
    }
}

